/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dao.helper.impl;

import java.lang.reflect.Method;
import org.seasar.extension.dao.DaoNotFoundRuntimeException;
import org.seasar.extension.dao.helper.DaoHelper;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TextUtil;

public class DaoHelperImpl
implements DaoHelper {
    private NamingConvention namingConvention;
    static /* synthetic */ Class class$java$lang$Object;

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public Class getDaoInterface(Class clazz) {
        if (clazz.isInterface()) {
            return clazz;
        }
        for (Class target = clazz; target != (class$java$lang$Object == null ? DaoHelperImpl.class$("java.lang.Object") : class$java$lang$Object); target = target.getSuperclass()) {
            Class<?>[] interfaces = target.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> intf = interfaces[i];
                if (!intf.getName().endsWith(this.namingConvention.getDaoSuffix())) continue;
                return intf;
            }
        }
        throw new DaoNotFoundRuntimeException(clazz);
    }

    public String getDataSourceName(Class daoClass) {
        String key;
        Class intf = this.getDaoInterface(daoClass);
        String className = intf.getName();
        int index = className.lastIndexOf(key = "." + this.namingConvention.getDaoPackageName() + ".");
        if (index < 0) {
            return null;
        }
        int index2 = className.lastIndexOf(46);
        if (index + key.length() - 1 == index2) {
            return null;
        }
        return className.substring(index + key.length(), index2);
    }

    public String getSqlBySqlFile(Class daoClass, Method method, String suffix) {
        String base = daoClass.getName().replace('.', '/') + "_" + method.getName();
        String dbmsPath = base + (StringUtil.isEmpty((String)suffix) ? "" : "_" + suffix) + ".sql";
        String standardPath = base + ".sql";
        if (ResourceUtil.isExist((String)dbmsPath)) {
            return TextUtil.readUTF8((String)dbmsPath);
        }
        if (ResourceUtil.isExist((String)standardPath)) {
            return TextUtil.readUTF8((String)standardPath);
        }
        return null;
    }
}

