package common.transaction;


/**
 * トランザクションユーティリティ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class TransactionUtil {
	/** トランザクション用変数 */
	private static final ThreadLocal<Boolean> JTA = new ThreadLocal<>();

	/**
	 * コンストラクタ
	 *
	 */
	private TransactionUtil() {
		throw new AssertionError();
	}

	/**
	 * 開始処理
	 *
	 */
	public static void begin() {
		JTA.set(Boolean.TRUE);
	}

	/**
	 * トランザクション中確認
	 *
	 * @return トランザクション時 true を返す。
	 */
	public static boolean isInTransaction() {
		Boolean val = JTA.get();
		return val != null && val.booleanValue();
	}

	/**
	 * 終了処理
	 *
	 */
	public static void end() {
		JTA.remove();
	}
}
