package batch.controller;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * バッチ管理インターフェース
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface JobManager extends Remote {

	/** バッチ管理バインド名 */
	String BATCH_BIND_NAME = "/JobManager";
	/** バッチ起動時オプション */
	String ID_B_ONLINE_OPTION = "-o";

	/**
	 * バッチジョブ処理中止メソッド
	 *
	 * @param jobseq ジョブ連番
	 * @throws RemoteException リモート例外
	 */
	void cancel(long jobseq) throws RemoteException;
}
