package online.context.token;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;

/**
 * TokenUtil
 *
 * @author Tadashi Nakayama
 */
public final class TokenUtil {

	/** タグ TOKEN */
	private static final String TAG_TOKEN = "TOKEN";

	/**
	 * コンストラクタ
	 */
	private TokenUtil() {
		throw new AssertionError();
	}

	/**
	 * トークン設定
	 * @param request リクエスト
	 * @param token トークン文字列
	 */
	public static void setTokenTo(final HttpServletRequest request, final String token) {
		request.setAttribute(TAG_TOKEN, token);
	}

	/**
	 * トークン取得
	 * @param request リクエスト
	 * @return トークン文字列
	 */
	public static String getTokenFrom(final HttpServletRequest request) {
		return String.class.cast(request.getAttribute(TAG_TOKEN));
	}

	/**
	 * パラメータトークン設定
	 * @param request サーブレットリクエスト
	 */
	public static void setParameterTokenTo(final HttpServletRequest request) {
		String tk = request.getParameter(TAG_TOKEN);
		if (tk != null) {
			setTokenTo(request, tk);
		}
	}

	/**
	 * トークン同一確認
	 * @param token 比較対象トークン文字列
	 * @param request リクエスト
	 * @return 同一の場合 true を返す。
	 */
	public static boolean isSameToken(final String token, final HttpServletRequest request) {
		return Objects.equals(token, request.getParameter(TAG_TOKEN));
	}

	/**
	 * パラメータマップ取得
	 * @param request リクエスト
	 * @return パラメータマップ
	 */
	public static Map<String, String[]> getParameterMapFrom(final HttpServletRequest request) {
		Map<String, String[]> map = new HashMap<>(request.getParameterMap());
		map.remove(TAG_TOKEN);
		return map;
	}
}
