package project.batch;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;

import common.db.dao.Dao;
import common.db.dao.hibernate.HibernateJdbcWork;
import common.sql.SelectQuery;
import common.sql.Selector;
import core.config.Factory;
import core.util.DateUtil;

/**
 * SQLクエリ
 * @author Tadashi Nakayama
 */
public abstract class JdbcQuery extends HibernateJdbcWork implements SelectQuery {

	/** パラメタ */
	private Map<String, Object> param;
	/** DAO */
	private Dao dao;

	/** 処理ユーザID */
	private String uid;
	/** 処理日時 */
	private Timestamp dateTime;

	/** フェッチサイズ */
	private int fetchSize = 1000;

	/**
	 * ユーザID設定
	 * @param val ユーザID
	 */
	public final void setUid(final String val) {
		this.uid = val;
	}

	/**
	 * ユーザID取得
	 * @return ユーザID
	 */
	protected final String getUid() {
		return this.uid;
	}

	/**
	 * 処理日時設定
	 * @param val 処理日時
	 */
	public final void setDateTime(final Timestamp val) {
		this.dateTime = DateUtil.copyOf(val);
	}

	/**
	 * 処理日時取得
	 * @return val 処理日時
	 */
	protected final Timestamp getDateTime() {
		return DateUtil.copyOf(this.dateTime);
	}

	/**
	 * パラメタ設定
	 * @param val パラメタマップ
	 */
	public final void setParam(final Map<String, Object> val) {
		this.param = val;
	}

	/**
	 * パラメタ取得
	 * @return パラメタマップ
	 */
	@Override
	public final Map<String, Object> makeParam() {
		return this.param;
	}

	/**
	 * DAO取得
	 * @return DAO
	 */
	protected final Dao getDao() {
		return this.dao;
	}

	/**
	 * フェッチサイズ設定
	 * @param val フェッチサイズ
	 */
	public final void setFetchSize(final int val) {
		this.fetchSize = val;
	}

	/**
	 * @see common.db.dao.hibernate.HibernateJdbcWork#execute(java.sql.Connection)
	 */
	@Override
	public final void execute(final Connection conn) throws SQLException {
		Selector sc = Factory.create(Selector.class);
		sc.setConnection(conn);
		sc.setFetchSize(this.fetchSize);
		sc.search(this);
	}

	/**
	 * 処理実行
	 * @param val DAO
	 */
	public final void execute(final Dao val) {
		this.dao = val;
		this.dao.doWork(this);
	}
}
