package common.db.dao.hibernate;

import org.hibernate.dialect.Dialect;

import common.db.dao.Dao.JdbcWork;

/**
 * JDBC実行クラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public abstract class HibernateJdbcWork implements JdbcWork {

	/** ダイアレクト */
	private Dialect dialect = null;

	/**
	 * ダイアレクト設定
	 * @param val ダイアレクト
	 */
	public final void setDialect(final Dialect val) {
		this.dialect = val;
	}

	/**
	 * シーケンスSQL取得
	 * @param name シーケンス名
	 * @return シーケンスSQL
	 */
	protected final String getSequenceNextValString(final String name) {
		return this.dialect != null ? this.dialect.getSequenceNextValString(name) : null;
	}
}
