package project.check.existence;

import java.util.Objects;
import java.util.Optional;

import core.util.ArrayUtil;
import core.util.bean.Pair;
import project.check.BaseCheck;
import project.master.MsgUtil;

/**
 * 全く入力無しか、全て必須入力チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class AllorNothingCheck extends BaseCheck {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public AllorNothingCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public AllorNothingCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = ArrayUtil.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			String[] val = super.getArrayParameter(item);
			for (int j = 0; val != null && j < val.length; j++) {
				if (Objects.toString(val[j], "").isEmpty()) {
					if (!MsgUtil.hasItemMessage(super.getUniModel(), item)) {
						super.addTopMessage(this.mid, this.prm);
					}
					// if (!MsgUtil.hasItemMessage(super.getUniModel(), item, j)) {
					// 	MsgUtil.putItemMessage(super.getUniModel(), item, j, this.mid, this.prm);
					// }
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
