package project.check.range;

import java.util.Objects;
import java.util.Optional;

import core.util.ArrayUtil;
import core.util.bean.Pair;
import online.model.ModelUtil;
import project.check.BaseCheck;

/**
 * 指定文字数範囲内チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class LengthRangeCheck extends BaseCheck {

	/** 最大文字数 */
	private final int maxlen;
	/** 最小文字数 */
	private final int minlen;
	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 *
	 * @param min 指定最小文字数
	 * @param max 指定最大文字数
	 */
	public LengthRangeCheck(final int min, final int max) {
		this.minlen = min;
		this.maxlen = max;
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param min 指定最小文字数
	 * @param max 指定最大文字数
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public LengthRangeCheck(final int min, final int max,
					final String msgId, final String... param) {
		this.minlen = min;
		this.maxlen = max;
		this.mid = msgId;
		this.prm = ArrayUtil.extend(param, String.valueOf(max), String.valueOf(min));
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			String[] val = super.getArrayParameter(item);
			for (int j = 0; val != null && j < val.length; j++) {
				if (!super.isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
				} else if (Objects.toString(val[j], "").isEmpty()) {
					continue;
				} else if (val[j].length() > this.maxlen || val[j].length() < this.minlen) {
					super.setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
