package common.db.dao.hibernate;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

import common.db.dao.hibernate.EntityUtil;

public class TestEntityUtil {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestEntityUtil.class.getName());
	}

	@Test
	public void エンティティから挿入SQLとパラメータリスト変換() {
		FooMaster fm = new FooMaster();
		fm.setCreateDateTime(new Timestamp(new Date().getTime()));
		fm.setCreateUserId("abcd");
		fm.setFooAddress("fooAddress");
		fm.setFooId("fooId");
		fm.setFooName("fooName");
		fm.setFooPhone("fooPhone");
		fm.setHooId("hooId");
		fm.setId(Long.valueOf(1));
		fm.setTorokuDateTime(fm.getCreateDateTime());
		fm.setUpdateDateTime(fm.getTorokuDateTime());
		fm.setUpdateUserId("updateUserId");
		fm.setVersion(1);

		List<Object> param = new ArrayList<>();
		String sql = EntityUtil.toInsertSql(fm, param);

		Assert.assertEquals(param.size(), 12);
		Assert.assertEquals(sql, "INSERT INTO foo_master(create_date_time, create_user_id, foo_address, foo_id, foo_name, foo_phone, hoo_id, id, toroku_date_time, update_date_time, update_user_id, version) VALUES(:1, :2, :3, :4, :5, :6, :7, :8, :9, :10, :11, :12)");
	}

	@Test
	public void エンティティから更新SQLとパラメータリストに変換() {
		FooMaster fm = new FooMaster();
		fm.setCreateDateTime(new Timestamp(new Date().getTime()));
		fm.setCreateUserId("abcd");
		fm.setFooAddress("fooAddress");
		fm.setFooId("fooId");
		fm.setFooName("fooName");
		fm.setFooPhone("fooPhone");
		fm.setHooId("hooId");
		fm.setId(Long.valueOf(1));
		fm.setTorokuDateTime(fm.getCreateDateTime());
		fm.setUpdateDateTime(fm.getTorokuDateTime());
		fm.setUpdateUserId("updateUserId");
		fm.setVersion(1);

		List<Object> param = new ArrayList<>();
		String sql = EntityUtil.toUpdateSql(fm, param);

		Assert.assertEquals(param.size(), 12);
		Assert.assertEquals(sql, "UPDATE foo_master SET create_date_time = :1, create_user_id = :2, foo_address = :3, foo_id = :4, foo_name = :5, foo_phone = :6, hoo_id = :7, toroku_date_time = :8, update_date_time = :9, update_user_id = :10, version = :11 WHERE id = :12");
	}

	@Test
	public void エンティティから削除SQLとパラメータリストに変換() {
		FooMaster fm = new FooMaster();
		fm.setCreateDateTime(new Timestamp(new Date().getTime()));
		fm.setCreateUserId("abcd");
		fm.setFooAddress("fooAddress");
		fm.setFooId("fooId");
		fm.setFooName("fooName");
		fm.setFooPhone("fooPhone");
		fm.setHooId("hooId");
		fm.setId(Long.valueOf(1));
		fm.setTorokuDateTime(fm.getCreateDateTime());
		fm.setUpdateDateTime(fm.getTorokuDateTime());
		fm.setUpdateUserId("updateUserId");
		fm.setVersion(1);

		List<Object> param = new ArrayList<>();
		String sql = EntityUtil.toDeleteSql(fm, param);

		Assert.assertEquals(sql, "DELETE FROM foo_master WHERE id = :1");
		Assert.assertEquals(param.size(), 1);
	}

	@Test
	public void マップからエンティティ変換() {
		Timestamp now = new Timestamp(new Date().getTime());
		Map<String, Object> map = new HashMap<>();
		map.put("create_user_id", "abcd");
		map.put("id", Long.valueOf(1));
		map.put("create_date_time", now);

		FooMaster fm = EntityUtil.toEntity(map, FooMaster.class);
		Assert.assertEquals("abcd", fm.getCreateUserId());
		Assert.assertEquals(Long.valueOf(1), fm.getId());
		Assert.assertEquals(now, fm.getCreateDateTime());
	}
}
