/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat;

import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.NATURE_ID;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PROPERTIES_PAGE_PROJECT_EXTRAINFO_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PROPERTIES_PAGE_PROJECT_ISTOMCATPROJECT_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_REDIRECTLOGGER_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_RELOADABLE_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_ROOTDIR_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_UPDATEXML_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_WEBPATH_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_WORKDIR_LABEL;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * TomcatProjectGeneralPropertyPage
 *
 */
public class TomcatProjectGeneralPropertyPage {

	/** TEXT_FIELD_WIDTH */
	private static final int TEXT_FIELD_WIDTH = 200;

	/** isTomcatProjectCheck */
	private Button isTomcatProjectCheck;
	/** updateXmlCheck */
	private Button updateXmlCheck;
	/** reloadableCheck */
	private Button reloadableCheck;
	/** redirectLoggerCheck */
	private Button redirectLoggerCheck;
	/** webpathText */
	private Text webpathText;
	/** rootDirText */
	private Text rootDirText;
	/** extraInfoText */
	private Text extraInfoText;
	/** DirectoryFieldEditor */
	private DirectoryFieldEditor workDir;

	/** IJavaProject */
	private final IJavaProject javaProject;
	/** TomcatProject */
	private final TomcatProject tomcatProject;

	/**
	 * Constructor
	 * @param java IJavaProject
	 * @param tomcat TomcatProject
	 */
	public TomcatProjectGeneralPropertyPage(final IJavaProject java, final TomcatProject tomcat) {
		this.javaProject = java;
		this.tomcatProject = tomcat;
	}

	/**
	 * returns a control which consists of the ui elements of this page
	 * @param parent Composite
	 * @return Control
	 */
	protected Control createContents(final Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		createIsTomcatProjectGroup(composite);

		Group group = new Group(composite, SWT.NONE);
		group.setLayout(new GridLayout());
		createWebpathGroup(group);
		createExtraInformationGroup(group);

		createRootDirGroup(group);

		return composite;
	}

	/**
	 *
	 * @param parent Composite
	 */
	public void createIsTomcatProjectGroup(final Composite parent) {
		Composite isTomcatProjectGroup = new Composite(parent, SWT.NONE);
		isTomcatProjectGroup.setLayout(new GridLayout(3, false));
		isTomcatProjectGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		// project location entry field
		this.isTomcatProjectCheck = new Button(isTomcatProjectGroup, SWT.CHECK | SWT.LEFT);
		this.isTomcatProjectCheck.setText(PROPERTIES_PAGE_PROJECT_ISTOMCATPROJECT_LABEL);
		this.isTomcatProjectCheck.setEnabled(true);

		try {
			this.isTomcatProjectCheck.setSelection(this.javaProject.getProject().hasNature(NATURE_ID));
		} catch (final CoreException ex) {
			TomcatLauncherPlugin.log(ex.getMessage());
		}
	}

	/**
	 *
	 * @param parent Composite
	 */
	public void createWebpathGroup(final Composite parent) {
		Composite webpathGroup = new Composite(parent, SWT.NONE);
		webpathGroup.setLayout(new GridLayout(3, false));
		webpathGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		// location label
		Label webpathLabel = new Label(webpathGroup, SWT.NONE);
		webpathLabel.setText(WIZARD_PROJECT_WEBPATH_LABEL);
		webpathLabel.setEnabled(true);

		// project location entry field
		this.webpathText = new Text(webpathGroup, SWT.BORDER);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = TEXT_FIELD_WIDTH;
		this.webpathText.setLayoutData(data);
		this.webpathText.setText(getWebPath());
		this.webpathText.setEnabled(true);

		// project location entry field
		this.updateXmlCheck = new Button(webpathGroup, SWT.CHECK | SWT.LEFT);
		this.updateXmlCheck.setText(WIZARD_PROJECT_UPDATEXML_LABEL);
		this.updateXmlCheck.setLayoutData(newGridData(3));
		this.updateXmlCheck.setEnabled(true);
		this.updateXmlCheck.setSelection(getUpdateXml());

		// reloadable attribute
		this.reloadableCheck = new Button(webpathGroup, SWT.CHECK | SWT.LEFT);
		this.reloadableCheck.setText(WIZARD_PROJECT_RELOADABLE_LABEL);
		this.reloadableCheck.setLayoutData(newGridData(3));
		this.reloadableCheck.setEnabled(true);
		this.reloadableCheck.setSelection(getReloadable());

		// reloadable attribute
		this.redirectLoggerCheck = new Button(webpathGroup, SWT.CHECK | SWT.LEFT);
		this.redirectLoggerCheck.setText(WIZARD_PROJECT_REDIRECTLOGGER_LABEL);
		this.redirectLoggerCheck.setLayoutData(newGridData(3));
		this.redirectLoggerCheck.setEnabled(true);
		this.redirectLoggerCheck.setSelection(getRedirectLogger());
	}

	/**
	 * new GridData
	 * @param span horizontal span
	 * @return GridData
	 */
	private GridData newGridData(final int span) {
		GridData data = new GridData();
		data.horizontalSpan = span;
		return data;
	}

	/**
	 *
	 * @param parent Composite
	 */
	public void createRootDirGroup(final Composite parent) {
		Composite workDirGroup = new Composite(parent, SWT.NONE);
		workDirGroup.setLayout(new GridLayout(3, false));
		workDirGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		this.workDir = new DirectoryFieldEditor("",
				WIZARD_PROJECT_WORKDIR_LABEL, workDirGroup);
		this.workDir.setStringValue(getWorkDir());

		Composite rootDirGroup = new Composite(parent, SWT.NONE);
		rootDirGroup.setLayout(new GridLayout(2, false));
		rootDirGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		// location label
		Label rootDirLabel = new Label(rootDirGroup, SWT.NONE);
		rootDirLabel.setText(WIZARD_PROJECT_ROOTDIR_LABEL);
		rootDirLabel.setEnabled(true);

		// project location entry field
		this.rootDirText = new Text(rootDirGroup, SWT.BORDER);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 30;
		this.rootDirText.setLayoutData(data);
		this.rootDirText.setText(getRootDir());
		this.rootDirText.setEnabled(true);
	}

	/**
	 * @param parent Composite
	 */
	public void createExtraInformationGroup(final Composite parent) {
		Composite contextGroup = new Composite(parent, SWT.NONE);
		contextGroup.setLayout(new GridLayout(1, false));
		contextGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		// Extra information label
		Label rootDirLabel = new Label(contextGroup, SWT.NONE);
		rootDirLabel.setText(PROPERTIES_PAGE_PROJECT_EXTRAINFO_LABEL);
		rootDirLabel.setEnabled(true);

		// Extra information field
		this.extraInfoText = new Text(contextGroup, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.grabExcessHorizontalSpace = true;
		data.grabExcessVerticalSpace = true;
		data.widthHint = 500;
		data.heightHint = 100;
		this.extraInfoText.setLayoutData(data);
		this.extraInfoText.setText(getExtraInfo());
		this.extraInfoText.setEnabled(true);
	}

	/**
	 *
	 * @return WebPath
	 */
	protected String getWebPath() {
		String result = "";
		TomcatProject prj = this.tomcatProject;
		if (prj != null) {
			result = prj.getWebPath();
		}
		return result;
	}

	/**
	 *
	 * @return RootDir
	 */
	protected String getRootDir() {
		String result = "/";
		TomcatProject prj = this.tomcatProject;
		if (prj != null) {
			result = prj.getRootDir();
		}
		return result;
	}

	/**
	 *
	 * @return WorkDir
	 */
	protected String getWorkDir() {
		String result = "";
		TomcatProject prj = this.tomcatProject;
		if (prj != null) {
			result = prj.getWorkDir();
		}
		return result;
	}

	/**
	 *
	 * @return ExtraInfo
	 */
	protected String getExtraInfo() {
		String result = "";
		TomcatProject prj = this.tomcatProject;
		if (prj != null) {
			result = prj.getExtraInfo();
		}
		return result;
	}

	/**
	 *
	 * @return boolean
	 */
	protected boolean getUpdateXml() {
		boolean result = true;
		TomcatProject prj = this.tomcatProject;
		if (prj != null) {
			result = prj.getUpdateXml();
		}
		return result;
	}

	/**
	 *
	 * @return boolean
	 */
	protected boolean getReloadable() {
		boolean result = true;
		TomcatProject prj = this.tomcatProject;
		if (prj != null) {
			result = prj.getReloadable();
		}
		return result;
	}

	/**
	 *
	 * @return boolean
	 */
	protected boolean getRedirectLogger() {
		boolean result = false;
		TomcatProject prj = this.tomcatProject;
		if (prj != null) {
			result = prj.getRedirectLogger();
		}
		return result;
	}

	/**
	 * performes the ok action for this property page
	 * @return boolean
	 */
	public boolean performOk() {
		try {
			if (this.isTomcatProjectCheck.getSelection()) {
				TomcatProject.addTomcatNature(this.javaProject);
				TomcatProject prj = this.tomcatProject;
				prj.updateWebPath(this.webpathText.getText());
				prj.setUpdateXml(this.updateXmlCheck.getSelection());
				prj.setReloadable(this.reloadableCheck.getSelection());
				prj.setRedirectLogger(this.redirectLoggerCheck.getSelection());
				prj.setExtraInfo(this.extraInfoText.getText());
				prj.setRootDir(this.rootDirText.getText());
				prj.setWorkDir(this.workDir.getStringValue());
				prj.saveProperties();
			} else {
				this.tomcatProject.removeContext();
				TomcatProject.removeTomcatNature(this.javaProject);
			}
		} catch (final CoreException ex) {
			TomcatLauncherPlugin.log(ex.getMessage());
			return false;
		}
		return true;
	}

	/**
	 *
	 * @return boolean
	 */
	public boolean isTomcatProjectChecked() {
		return this.isTomcatProjectCheck.getSelection();
	}
}
