/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat.actions;

import org.eclipse.core.runtime.CoreException;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatProject;

/**
 * CreateJSPWorkDirectoryActionDelegate
 *
 */
public class CreateJSPWorkDirectoryActionDelegate extends TomcatProjectAbstractActionDelegate {

	/**
	 * @see com.sysdeo.eclipse.tomcat.actions.TomcatProjectAbstractActionDelegate
	 * #doActionOn(com.sysdeo.eclipse.tomcat.TomcatProject)
	 */
	@Override
	public void doActionOn(final TomcatProject prj) throws CoreException {
		prj.createWorkFolder();
		try {
			prj.setWorkAsSourceFolder();
		} catch (final CoreException ex) {
			TomcatLauncherPlugin.log(ex.getMessage());
		}

		if (prj.getUpdateXml()) {
			prj.updateContext();
		} else {
			throw new TomcatActionException(
					TomcatLauncherPlugin.getResourceString("msg.action.updateServerXML.failed"));
		}
	}
}
