/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.TwitterException;
import twitter4j.TwitterOAuthSupportBase;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.AuthorizationFactory;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.NullAuthorization;
import twitter4j.http.OAuthAuthorization;
import twitter4j.http.OAuthSupport;
import twitter4j.http.RequestToken;
import twitter4j.internal.http.XAuthAuthorization;

class TwitterOAuthSupportBaseImpl
extends TwitterOAuthSupportBase {
    private static final long serialVersionUID = 2166151122833272805L;
    protected transient String screenName = null;
    protected transient int id = 0;

    TwitterOAuthSupportBaseImpl(Configuration conf) {
        super(conf);
    }

    TwitterOAuthSupportBaseImpl() {
        super(ConfigurationContext.getInstance());
    }

    TwitterOAuthSupportBaseImpl(String screenName, String password) {
        super(ConfigurationContext.getInstance(), screenName, password);
    }

    TwitterOAuthSupportBaseImpl(Configuration conf, String screenName, String password) {
        super(conf, screenName, password);
    }

    TwitterOAuthSupportBaseImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.getOAuthRequestToken(null);
    }

    public RequestToken getOAuthRequestToken(String callbackUrl) throws TwitterException {
        return this.getOAuth().getOAuthRequestToken(callbackUrl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized AccessToken getOAuthAccessToken() throws TwitterException {
        AccessToken oauthAccessToken;
        Authorization auth = this.getAuthorization();
        if (auth instanceof BasicAuthorization) {
            BasicAuthorization basicAuth = (BasicAuthorization)auth;
            auth = AuthorizationFactory.getInstance(this.conf, true);
            if (!(auth instanceof OAuthAuthorization)) throw new IllegalStateException("consumer key / secret combination not supplied.");
            this.auth = auth;
            OAuthAuthorization oauthAuth = (OAuthAuthorization)auth;
            oauthAccessToken = oauthAuth.getOAuthAccessToken(basicAuth.getUserId(), basicAuth.getPassword());
        } else if (auth instanceof XAuthAuthorization) {
            XAuthAuthorization xauth = (XAuthAuthorization)auth;
            this.auth = xauth;
            OAuthAuthorization oauthAuth = new OAuthAuthorization(this.conf, xauth.getConsumerKey(), xauth.getConsumerSecret());
            oauthAccessToken = oauthAuth.getOAuthAccessToken(xauth.getUserId(), xauth.getPassword());
        } else {
            oauthAccessToken = this.getOAuth().getOAuthAccessToken();
        }
        this.screenName = oauthAccessToken.getScreenName();
        this.id = oauthAccessToken.getUserId();
        return oauthAccessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        AccessToken oauthAccessToken = this.getOAuth().getOAuthAccessToken(oauthVerifier);
        this.screenName = oauthAccessToken.getScreenName();
        return oauthAccessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        OAuthSupport oauth = this.getOAuth();
        AccessToken oauthAccessToken = oauth.getOAuthAccessToken(requestToken);
        this.screenName = oauthAccessToken.getScreenName();
        return oauthAccessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        return this.getOAuth().getOAuthAccessToken(requestToken, oauthVerifier);
    }

    public synchronized void setOAuthAccessToken(AccessToken accessToken) {
        this.getOAuth().setOAuthAccessToken(accessToken);
    }

    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret) throws TwitterException {
        return this.getOAuth().getOAuthAccessToken(new RequestToken(token, tokenSecret));
    }

    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret, String pin) throws TwitterException {
        return this.getOAuthAccessToken(new RequestToken(token, tokenSecret), pin);
    }

    public void setOAuthAccessToken(String token, String tokenSecret) {
        this.getOAuth().setOAuthAccessToken(new AccessToken(token, tokenSecret));
    }

    public boolean isOAuthEnabled() {
        return this.auth instanceof OAuthAuthorization && this.auth.isEnabled();
    }

    private OAuthSupport getOAuth() {
        if (!(this.auth instanceof OAuthSupport)) {
            throw new IllegalStateException("OAuth consumer key/secret combination not supplied");
        }
        return (OAuthSupport)((Object)this.auth);
    }

    public synchronized void setOAuthConsumer(String consumerKey, String consumerSecret) {
        if (null == consumerKey) {
            throw new NullPointerException("consumer key is null");
        }
        if (null == consumerSecret) {
            throw new NullPointerException("consumer secret is null");
        }
        if (this.auth instanceof NullAuthorization) {
            this.auth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
        } else if (this.auth instanceof BasicAuthorization) {
            XAuthAuthorization xauth = new XAuthAuthorization((BasicAuthorization)this.auth);
            xauth.setOAuthConsumer(consumerKey, consumerSecret);
            this.auth = xauth;
        } else if (this.auth instanceof OAuthAuthorization) {
            throw new IllegalStateException("consumer key/secret pair already set.");
        }
    }
}

