/*
 * Copyright (c) 2009,2010 Sony Ericsson Mobile Communications
 *
 * This file is subject to the terms and conditions of version 2 of
 * the GNU General Public License.  See the file COPYING in the main
 * directory of this archive for more details.
 */

#include "ovm7692.h"

/* device specific settings */
const struct regval_list ovm7692_device_init_regs[] = {
		{0x3e, 0x30},
		{0x28, 0x02}, /* VSYNC NEG */
		{0x11, 0x00}, /* Internal clock dividers, 30 fps default */
		{0x5e, 0x10}, /* Divided PCLK */
		{0x0e, 0x00}  /* Exit sleep mode necessary */
};
uint32_t size_ovm7692_device_init_regs = ARRAY_SIZE(ovm7692_device_init_regs);

/* framerate 30 fps */
const struct regval_list ovm7692_framerate_30_regs[] = {
		{0x11, 0x00}
};
uint32_t size_ovm7692_framerate_30_regs = ARRAY_SIZE(ovm7692_framerate_30_regs);

/* framerate 15 fps */
const struct regval_list ovm7692_framerate_15_regs[] = {
		{0x11, 0x01}
};
uint32_t size_ovm7692_framerate_15_regs = ARRAY_SIZE(ovm7692_framerate_15_regs);

/* reference from Omnivision */
const struct regval_list ovm7692_ref_vga_regs[] = {
		{0x12, 0x80},
		{0x0e, 0x08},
		{0x69, 0x52},
		{0x1e, 0xb3},
		{0x48, 0x42},
		{0xff, 0x01},
		{0xb5, 0x30},
		{0xff, 0x00},
		{0x16, 0x03},
		{0x62, 0x10}, /* YUV */
		{0x12, 0x00},
		{0x17, 0x65},
		{0x18, 0xa4},
		{0x19, 0x0a},
		{0x1a, 0xf6},
		/*{0x3e, 0x20}, part of ovm7692_device_init_regs */
		{0x64, 0x11},
		{0x67, 0x20},
		{0x81, 0x3f},
		{0xcc, 0x02},
		{0xcd, 0x80},
		{0xce, 0x01},
		{0xcf, 0xe0},
		{0xc8, 0x02},
		{0xc9, 0x80},
		{0xca, 0x01},
		{0xcb, 0xe0},
		{0xd0, 0x48},
		{0x82, 0x03},
		{0x70, 0x00},
		{0x71, 0x34},
		{0x74, 0x28},
		{0x75, 0x98},
		{0x76, 0x00},
		{0x77, 0x64},
		{0x78, 0x01},
		{0x79, 0xc2},
		{0x7a, 0x4e},
		{0x7b, 0x1f},
		{0x7c, 0x00},
		/*{0x11, 0x01}, ovm7692_device_init_regs */
		{0x20, 0x00},
		{0x21, 0x57},
		{0x50, 0x4d},
		{0x51, 0x40},
		{0x4c, 0x7d},
		{0x0e, 0x00},
		{0x80, 0x7f},
		{0x85, 0x00}, /*OVT default 0x10*/
		{0x86, 0x00},
		{0x87, 0x00},
		{0x88, 0x00},
		{0x89, 0x2a}, /*OVT default 0x2f*/
		{0x8a, 0x22}, /*OVT default 0x20*/ 
		{0x8b, 0x20}, /*OVT default 0x23*/
		{0xbb, 0xab}, /*OVT default 0x7a*/
		{0xbc, 0x84}, /*OVT default 0x69*/
		{0xbd, 0x27}, /*OVT default 0x11*/
		{0xbe, 0x0e}, /*OVT default 0x13*/
		{0xbf, 0xb8}, /*OVT default 0x81*/
		{0xc0, 0xc5}, /*OVT default 0x96*/
		{0xc1, 0x1e},
		{0xb7, 0x05},
		{0xb8, 0x09},
		{0xb9, 0x00},
		{0xba, 0x18},
		{0x5a, 0x1f}, /*OVT default 0x29*/
		{0x5b, 0x9f},
		{0x5c, 0x69}, /*OVT default 0x68*/
		{0x5d, 0x62}, /*exp set to center 1/4 average*/
		{0x24, 0x78},
		{0x25, 0x68},
		{0x26, 0xb3},
		{0xa3, 0x0b},
		{0xa4, 0x15},
		{0xa5, 0x29}, /*OVT default 0x2a*/
		{0xa6, 0x4a}, /*OVT default 0x51*/
		{0xa7, 0x58}, /*OVT default 0x63*/
		{0xa8, 0x65}, /*OVT default 0x74*/
		{0xa9, 0x70}, /*OVT default 0x83*/
		{0xaa, 0x7b}, /*OVT default 0x91*/
		{0xab, 0x85}, /*OVT default 0x9e*/
		{0xac, 0x8e}, /*OVT default 0xaa*/
		{0xad, 0xa0}, /*OVT default 0xbe*/
		{0xae, 0xb0}, /*OVT default 0xce*/
		{0xaf, 0xcb}, /*OVT default 0xe5*/
		{0xb0, 0xe1}, /*OVT default 0xf3*/
		{0xb1, 0xf1}, /*OVT default 0xfb*/
		{0xb2, 0x14}, /*OVT default 0x06*/
		{0x8c, 0x56}, /*OVT default 0x5c*/
		{0x8d, 0x11},
		{0x8e, 0x12},
		{0x8f, 0x19},
		{0x90, 0x50},
		{0x91, 0x22}, /*OVT default 0x20*/
		{0x92, 0x99}, /*OVT default 0x96*/
		{0x93, 0x8f}, /*OVT default 0x80*/
		{0x94, 0x11}, /*OVT default 0x13*/
		{0x95, 0x1f}, /*OVT default 0x1b*/
		{0x96, 0xff},
		{0x97, 0x00},
		{0x98, 0x33}, /*OVT default 0x3d*/
		{0x99, 0x2a}, /*OVT default 0x36*/
		{0x9a, 0x54}, /*OVT default 0x51*/
		{0x9b, 0x50}, /*OVT default 0x43*/
		{0x9c, 0xf0},
		{0x9d, 0xf0},
		{0x9e, 0xf0},
		{0x9f, 0xff},
		{0xa0, 0x61}, /*OVT default 0x68*/
		{0xa1, 0x5c}, /*OVT default 0x62*/
		{0xa2, 0x0c}, /*OVT default 0x0e*/
		/*{0x80, 0x7f},*/
};
uint32_t size_ovm7692_ref_vga_regs = ARRAY_SIZE(ovm7692_ref_vga_regs);
