/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.calllogplugin;

import android.net.Uri;

/**
 * @author Erik Hellman <erik.hellman@sonyericsson.com>
 */
public interface PluginConstants {

    /** Configurations in the event stream call log plug-in */
    public static class Config {
        /** Set to true if debug printouts should be shown */
        public static final boolean DEBUG = false;

        /** Log tag handled in the printouts */
        public static final String LOG_TAG = "CallLogPlugin";

        /** Delay to handle frequent changes in content observers */
        public static final int FRIEND_UPDATE_DELAY = 4 * 1000;
    }

    /** Plug-in service intent values */
    public static class ServiceIntentCmd {
        // Internal intents used in plugin
        public static final String SERVICE_COMMAND_KEY = "SERVICE_COMMAND";

        public static final String CALLLOG_REFRESH_REQUEST = "REFRESH_EVENTS";

        public static final String CALLLOG_REGISTER_PLUGIN = "REGISTER_PLUGIN";

        public static final String CALLLOG_UPDATE_STATUS = "UPDATE_STATUS";

        public static final String CALLLOG_VIEW_EVENT = "VIEW_EVENT";

        public static final String CALLLOG_UPDATE_FRIENDS = "UPDATE_FRIENDS";

        public static final String CALLLOG_UPDATE_CALLS = "UPDATE_CALLS";

        public static final String CALLOG_CONFIGURATION_CHANGED = "CONFIG_CHANGED";

        public static final String CALLLOG_LOCALE_CHANGED = "com.sonyericsson.eventstream.calllogplugin.LOCALE_CHANGED";
    }

    // Used when phone-number is not visible.
    // Values are copied from
    // /frameworks/base/telephony/java/com/android/internal/telephony/CallerInfo.java
    public interface CallerInfo {
        public static final String UNKNOWN_NUMBER = "-1";

        public static final String PRIVATE_NUMBER = "-2";

        public static final String PAYPHONE_NUMBER = "-3";
    }

    /** Event stream constants needed to access the engine */
    public static class EventStream {

        // Event Stream provider Uri:s
        public static final Uri EVENTSTREAM_FRIEND_PROVIDER_URI = Uri
                .parse("content://com.sonyericsson.eventstream/friends");

        public static final Uri EVENTSTREAM_EVENT_PROVIDER_URI = Uri.parse("content://com.sonyericsson.eventstream/events");

        public static final Uri EVENTSTREAM_SOURCE_PROVIDER_URI = Uri
                .parse("content://com.sonyericsson.eventstream/sources");

        public static final Uri EVENTSTREAM_PLUGIN_PROVIDER_URI = Uri
                .parse("content://com.sonyericsson.eventstream/plugins");

        // Sent from Event Stream to plugin
        public static final String EVENTSTREAM_REGISTER_ACTION = "com.sonyericsson.eventstream.REGISTER_PLUGINS";

        public static final String EVENTSTREAM_REFRESH_ACTION = "com.sonyericsson.eventstream.REFRESH_REQUEST";

        public static final String EVENTSTREAM_VIEW_EVENT_ACTION = "com.sonyericsson.eventstream.VIEW_EVENT_DETAIL";

        public static final String STATUS_UPDATE_ACTION = "com.sonyericsson.eventstream.calllogplugin.STATUS_UPDATE_ACTION";

        // Extra parameters used in intents
        public static final String EVENTSTREAM_VIEW_SERVICE_ID_EXTRA = "eventstreamViewServiceId";

        public static final String EVENTSTREAM_VIEW_FRIEND_ID_EXTRA = "eventstreamViewFriendId";

        public static final String EVENTSTREAM_VIEW_EVENT_KEY_EXTRA = "event_key";

        public static final String EVENTSTREAM_STATUS_MESSAGE_EXTRA = "STATUS_MESSAGE";

        public interface PluginTable {
            public static final String API_VERSION = "api_version";

            public static final String CONFIGURATION_STATE = "config_state";

            public static final String CONFIGURATION_ACTIVITY = "config_activity";

            public static final String CONFIGURATION_TEXT = "config_text";

            public static final String NAME = "name";

            public static final String ICON_URI = "icon_uri";

            public static final String STATUS_SUPPORT = "status_support";
        }

        public interface SourceTable {
            public static final String ID_COLUMN = "_id";

            public static final String PLUGIN_ID = "plugin_id";

            public static final String NAME = "name";

            public static final String ICON_URI = "icon_uri";

            public static final String ENABLED = "enabled";

            public static final String CURRENT_STATUS = "current_status";
        }

        public interface EventTable {
            public static final String ID_COLUMN = "_id";

            public static final String SOURCE_ID = "source_id";

            public static final String PLUGIN_ID = "plugin_id";

            public static final String FRIEND_KEY = "friend_key";

            public static final String MESSAGE = "message";

            public static final String IMAGE_URI = "image_uri";

            public static final String PUBLISHED_TIME = "published_time";

            public static final String STATUS_ICON_URI = "status_icon_uri";

            public static final String TITLE = "title";

            public static final String PERSONAL = "personal";

            public static final String OUTGOING = "outgoing";

            public static final String EVENT_KEY = "event_key";

            public static final String GEODATA = "geodata";

            public static final String DISPLAY_NAME = "display_name";

            public static final String HANDLED_TYPE = "handled_type";
        }

        public interface FriendTable {
            public static final String ID_COLUMN = "_id";

            public static final String SOURCE_ID = "source_id";

            public static final String PLUGIN_ID = "plugin_id";

            public static final String DISPLAY_NAME = "display_name";

            public static final String PROFILE_IMAGE_URI = "profile_image_uri";

            public static final String CONTACTS_REFERENCE = "contacts_reference";

            public static final String FRIEND_KEY = "friend_key";
        }

        public interface ConfigState {
            public static final int CONFIGURED = 0;

            public static final int NOT_CONFIGURED = 1;

            public static final int CONFIGURATION_NOT_NEEDED = 2;
        }
    }
}
