
package com.sonyericsson.esdatasourceplugin;

//REMOVED TIMESCAPE DEPENDENCY import com.sonyericsson.android.provider.ExtendContacts;
import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.ContactsContract;
import android.provider.ContactsContract.CommonDataKinds;
import android.provider.ContactsContract.Data;
import android.provider.ContactsContract.Groups;
import android.provider.ContactsContract.RawContacts;
import android.provider.ContactsContract.StatusUpdates;
import android.provider.ContactsContract.CommonDataKinds.GroupMembership;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.provider.ContactsContract.CommonDataKinds.StructuredName;
import android.provider.ContactsContract.CommonDataKinds.StructuredPostal;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

public class TestContact {

    // Test contact settings
    private String mGivenName;

    private String mFamilyName;

    private Uri mContactUri;

    private ContentResolver mResolver;

    private ContentValues mValues;

    private boolean mIsfavorite = false;

    private Bitmap mPhoto;

    private long mId;

    private long mRawId;

    private String mRingtoneName;

    private Uri mRingtoneUri;

    // Numbers
    public static final String[] testContactNumbers = {
            "+46701234567", "+4646987654", "+46105687498", "+4646562148", "+4646123589",
            "+466548987", "+4687222248"
    };

    // Contact Icon Numbers
    private static final String[] testContactIconNumbers = {
        "1111110000"
    };

    private static final int[] testContactNumberTypes = {
            Phone.TYPE_MOBILE, Phone.TYPE_HOME, Phone.TYPE_WORK, Phone.TYPE_FAX_HOME,
            Phone.TYPE_FAX_WORK, Phone.TYPE_PAGER, Phone.TYPE_OTHER
    };

    // Email
    private static final String[] testContactEmailAddress = {
            "Kalle@home.com", "Kalle@work.com", "kalle@other.com"
    };

    public static final int NBR_OF_TEST_CONTACT_EMAILS = testContactEmailAddress.length;

    private static final int[] testContactEmailTypes = {
            CommonDataKinds.Email.TYPE_HOME, CommonDataKinds.Email.TYPE_WORK,
            CommonDataKinds.Email.TYPE_OTHER
    };

    // IMS
    private static final int[] testContactIMProviders = {
            CommonDataKinds.Im.PROTOCOL_GOOGLE_TALK, CommonDataKinds.Im.PROTOCOL_AIM,
            CommonDataKinds.Im.PROTOCOL_MSN, CommonDataKinds.Im.PROTOCOL_YAHOO,
            CommonDataKinds.Im.PROTOCOL_JABBER, CommonDataKinds.Im.PROTOCOL_ICQ,
            CommonDataKinds.Im.PROTOCOL_SKYPE, CommonDataKinds.Im.PROTOCOL_QQ
    };

    private static final String[] testContactIMAccounts = {
            "Kalle@gmail.com", "Kalle@aim.com", "Kalle@msn.com", "Kalle@yahoo.com",
            "Kalle@jabber.com", "Kalle@icq.com", "Kalle@skype.com", "Kalle@qq.com"
    };

    // Postal
    private static final String[] testContactPostal = {
            "Testroad 51\n12345 Test city", "Work address 78\n98765 Work York"
    };

    private static final int[] testContactPostalType = {
            StructuredPostal.TYPE_HOME, StructuredPostal.TYPE_WORK
    };

    // Organization, company
    private static final String[] testContactOrganizationCompany = {
            "Work Company 1", "Other Company 2"
    };

    // Organization, position
    private static final String[] testContactOrganizationPosition = {
            "Work Position 1", "Other Position 2"
    };

    private static final int[] testContactOrganizationType = {
            CommonDataKinds.Organization.TYPE_WORK, CommonDataKinds.Organization.TYPE_OTHER
    };

    private static final String[] testContactTimescapePluginId = {
            "500", "501", "502"
    };

    private static final String[] testContactTimescapePluginName = {
            "Facebook", "SuperPlugin", "Twitter"
    };

    public static final int NBR_OF_TEST_CONTACT_TIMESCAPE_PLUGINS = 0;// testContactTimescapePluginId.length;

    // Notes
    private static final String testContactNotes = "Buy milk Kalle!!";

    // Photo
    private static final int testContactImage = R.drawable.miranda_contact;

    public TestContact(String name, ContentResolver resolver) {
        this(name, null, resolver);
    }

    public TestContact(String givenName, String familyName, ContentResolver resolver) {
        this("tester", "tester", givenName, familyName, resolver);
    }

    public TestContact(String accountType, String accountName, String givenName, String familyName,
            ContentResolver resolver) {
        mGivenName = givenName;
        mFamilyName = familyName;
        mResolver = resolver;
        mValues = new ContentValues();

        // Create contact with name only
        Long[] outs = new Long[2];
        mContactUri = createContact(mResolver, accountType, accountName, mGivenName, mFamilyName,
                outs);
        mId = outs[0];
        mRawId = outs[1];
    }

    public static Uri createContact(ContentResolver cr, String name, Long... outs) {
        return createContact(cr, name, null, outs);
    }

    public static Uri createContact(ContentResolver cr, String givenName, String familyName,
            Long... outs) {
        return createContact(cr, "tester", "tester", givenName, familyName, outs);
    }

    public static Uri createContact(ContentResolver cr, String accountType, String accountName,
            String givenName, String familyName, Long... outs) {
        long id = -1;
        long rawId = -1;
        ContentValues values = new ContentValues();

        if (accountType != null && accountName != null) {
            values.put(RawContacts.ACCOUNT_NAME, accountName);
            values.put(RawContacts.ACCOUNT_TYPE, accountType);
        } else {
            values.putNull(RawContacts.ACCOUNT_NAME);
            values.putNull(RawContacts.ACCOUNT_TYPE);
        }
        Uri rawContactUri = cr.insert(RawContacts.CONTENT_URI, values);
        rawId = ContentUris.parseId(rawContactUri);

        values.clear();
        values.put(StructuredName.FAMILY_NAME, familyName);
        values.put(StructuredName.GIVEN_NAME, givenName);

        values.put(StructuredName.RAW_CONTACT_ID, rawId);
        values.put(Data.MIMETYPE, StructuredName.CONTENT_ITEM_TYPE);
        cr.insert(Data.CONTENT_URI, values);

        Cursor c = cr.query(rawContactUri, new String[] {
            RawContacts.CONTACT_ID
        }, null, null, null);
        if (c != null) {
            try {
                if (c.moveToNext()) {
                    id = c.getLong(0);
                }
            } finally {
                c.close();
            }
        }

        if (outs != null) {
            if (outs.length > 0) {
                outs[0] = id;
            }
            if (outs.length > 1) {
                outs[1] = rawId;
            }
        }

        // save the newly created contacts id
        return ContentUris.withAppendedId(ContactsContract.Contacts.CONTENT_URI, id);
    }

    public TestContact(long id, ContentResolver resolver) {
        mResolver = resolver;
        mId = id;
        mContactUri = ContentUris.withAppendedId(ContactsContract.Contacts.CONTENT_URI, id);

        Cursor c = mResolver.query(RawContacts.CONTENT_URI, new String[] {
            RawContacts._ID
        }, RawContacts.CONTACT_ID + "=?", new String[] {
            String.valueOf(mId)
        }, null);
        if (c != null) {
            try {
                if (c.moveToNext()) {
                    mRawId = c.getLong(0);
                }
            } finally {
                c.close();
            }
        }
    }

    // Set contact as favorite
    public void setFavorite() {
        mValues.clear();
        mValues.put(ContactsContract.Contacts.STARRED, 1);
        mResolver.update(mContactUri, mValues, null, null);
        mIsfavorite = true;
    }

    // Unset contact as favorite
    public void unSetFavorite() {
        mValues.clear();
        mValues.put(ContactsContract.Contacts.STARRED, 0);
        mResolver.update(mContactUri, mValues, null, null);
        mIsfavorite = false;
    }

    // Add notes to contact information
    public void setNotes() {
        mValues.clear();
        mValues.put(CommonDataKinds.Note.MIMETYPE, CommonDataKinds.Note.CONTENT_ITEM_TYPE);
        mValues.put(CommonDataKinds.Note.NOTE, testContactNotes);
        mValues.put(CommonDataKinds.Note.RAW_CONTACT_ID, mRawId);
        mResolver.insert(Data.CONTENT_URI, mValues);
    }

    // Add a photo to the contact
    public void setPhoto(Context context, int drawable) {
        mPhoto = BitmapFactory.decodeResource(context.getResources(), drawable);

        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        mPhoto.compress(Bitmap.CompressFormat.JPEG, 75, stream);

        mValues.clear();
        mValues.put(CommonDataKinds.Photo.RAW_CONTACT_ID, mRawId);
        mValues.put(CommonDataKinds.Photo.MIMETYPE, CommonDataKinds.Photo.CONTENT_ITEM_TYPE);
        mValues.put(CommonDataKinds.Photo.PHOTO, stream.toByteArray());
        mResolver.insert(Data.CONTENT_URI, mValues);
    }

    // Add a photo to the contact
    public void setPhoto(Bitmap bitmap) {
        mPhoto = bitmap;

        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        mPhoto.compress(Bitmap.CompressFormat.JPEG, 75, stream);

        mValues.clear();
        mValues.put(CommonDataKinds.Photo.RAW_CONTACT_ID, mRawId);
        mValues.put(CommonDataKinds.Photo.MIMETYPE, CommonDataKinds.Photo.CONTENT_ITEM_TYPE);
        mValues.put(CommonDataKinds.Photo.PHOTO, stream.toByteArray());
        mResolver.insert(Data.CONTENT_URI, mValues);
    }

    // Add ringtone to contact information
    public void setRingtone(Context context) {
        mValues.clear();
        mRingtoneUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_RINGTONE);
        Ringtone ringtone = RingtoneManager.getRingtone(context, mRingtoneUri);
        if (ringtone != null) {
            mRingtoneName = ringtone.getTitle(context);
        } else {
            mRingtoneName = "";
        }

        // Uri ringtoneUri =
        // Uri.parse("android.resource://com.sonyericsson.contacts.tests/"
        // + com.sonyericsson.contacts.tests.R.raw.test);
        mValues.put(ContactsContract.Contacts.CUSTOM_RINGTONE, mRingtoneUri.toString());
        mResolver.update(mContactUri, mValues, null, null);
    }

    // Add phonenumbers of all types to contact information
    public void setNumbers() {
        // Create all Phone numbers based on the different types that
        // exists
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        for (int i = 0; i < testContactNumbers.length; i++) {
            ops.add(ContentProviderOperation.newInsert(Data.CONTENT_URI).withValue(
                    Phone.RAW_CONTACT_ID, mRawId)
                    .withValue(Phone.MIMETYPE, Phone.CONTENT_ITEM_TYPE).withValue(Phone.NUMBER,
                            testContactNumbers[i]).withValue(Phone.TYPE, testContactNumberTypes[i])
                    .build());
        }
        try {
            mResolver.applyBatch(ContactsContract.AUTHORITY, ops);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (OperationApplicationException e) {
            e.printStackTrace();
        }
    }

    // Adds one phone number to contact information
    public void setNumber() {
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        if (testContactNumbers.length > 0) {
            ops.add(ContentProviderOperation.newInsert(Data.CONTENT_URI).withValue(
                    Phone.RAW_CONTACT_ID, mRawId)
                    .withValue(Phone.MIMETYPE, Phone.CONTENT_ITEM_TYPE).withValue(Phone.NUMBER,
                            testContactNumbers[0]).withValue(Phone.TYPE, testContactNumberTypes[0])
                    .build());
        }
        try {
            mResolver.applyBatch(ContactsContract.AUTHORITY, ops);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (OperationApplicationException e) {
            e.printStackTrace();
        }
    }

    // Add phonenumber to contact information
    public void addPhoneNumber(int numberType, String number) {
        mValues.clear();
        mValues.put(Phone.MIMETYPE, Phone.CONTENT_ITEM_TYPE);
        mValues.put(Phone.NUMBER, number);
        mValues.put(Phone.TYPE, numberType);
        mValues.put(CommonDataKinds.Note.RAW_CONTACT_ID, mRawId);
        mResolver.insert(Data.CONTENT_URI, mValues);
    }

    // Add email to contact information
    public void addEmailAddress(int addressType, String address) {
        mValues.clear();
        mValues.put(CommonDataKinds.Email.MIMETYPE, CommonDataKinds.Email.CONTENT_ITEM_TYPE);
        mValues.put(CommonDataKinds.Email.DATA, address);
        mValues.put(CommonDataKinds.Email.TYPE, addressType);
        mValues.put(CommonDataKinds.Note.RAW_CONTACT_ID, mRawId);
        mResolver.insert(Data.CONTENT_URI, mValues);
    }

    public void addPostal(String valueType, String value, int type) {
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();

        ops.add(ContentProviderOperation.newInsert(Data.CONTENT_URI).withValue(
                StructuredPostal.RAW_CONTACT_ID, mRawId).withValue(StructuredPostal.MIMETYPE,
                StructuredPostal.CONTENT_ITEM_TYPE).withValue(valueType, value).withValue(
                StructuredPostal.TYPE, StructuredPostal.TYPE_WORK).build());

        try {
            mResolver.applyBatch(ContactsContract.AUTHORITY, ops);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (OperationApplicationException e) {
            e.printStackTrace();
        }
    }

    // Add email of all types to contact information
    public void setEmail() {
        // Create all email addresses
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        for (int i = 0; i < testContactEmailAddress.length; i++) {
            ops.add(ContentProviderOperation.newInsert(Data.CONTENT_URI).withValue(
                    CommonDataKinds.Email.RAW_CONTACT_ID, mRawId).withValue(
                    CommonDataKinds.Email.MIMETYPE, CommonDataKinds.Email.CONTENT_ITEM_TYPE)
                    .withValue(CommonDataKinds.Email.DATA, testContactEmailAddress[i]).withValue(
                            CommonDataKinds.Email.TYPE, testContactEmailTypes[i]).build());
        }
        try {
            mResolver.applyBatch(ContactsContract.AUTHORITY, ops);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (OperationApplicationException e) {
            e.printStackTrace();
        }
    }

    // Add IM addresses of all types to contact information
    public void setIM(int amount) {
        // Create all IMS addresses
        if (amount > testContactIMProviders.length) {
            amount = testContactIMProviders.length;
        }

        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        for (int i = 0; i < amount; i++) {
            // special-handle gtalk as email
            if (testContactIMProviders[i] == CommonDataKinds.Im.PROTOCOL_GOOGLE_TALK) {
                ops.add(ContentProviderOperation.newInsert(Data.CONTENT_URI).withValue(
                        CommonDataKinds.Email.RAW_CONTACT_ID, mRawId).withValue(
                        CommonDataKinds.Email.MIMETYPE, CommonDataKinds.Email.CONTENT_ITEM_TYPE)
                        .withValue(CommonDataKinds.Email.DATA, testContactIMAccounts[i]).withValue(
                                CommonDataKinds.Email.TYPE, CommonDataKinds.Email.TYPE_OTHER)
                        .build());
            } else {
                ops.add(ContentProviderOperation.newInsert(Data.CONTENT_URI).withValue(
                        CommonDataKinds.Im.RAW_CONTACT_ID, mRawId).withValue(
                        CommonDataKinds.Im.MIMETYPE, CommonDataKinds.Im.CONTENT_ITEM_TYPE)
                        .withValue(CommonDataKinds.Im.DATA, testContactIMAccounts[i]).withValue(
                                CommonDataKinds.Im.TYPE, CommonDataKinds.Im.TYPE_OTHER).withValue(
                                CommonDataKinds.Im.PROTOCOL, testContactIMProviders[i]).build());
            }
        }

        // for (int i = 0; i < amount; i++) {
        // // Add contact status online to every IM address
        // ops.add(ContentProviderOperation.newInsert(StatusUpdates.CONTENT_URI).withValue(
        // StatusUpdates.PROTOCOL, testContactIMProviders[i]).withValue(
        // StatusUpdates.IM_HANDLE, testContactIMAccounts[i]).withValue(
        // StatusUpdates.PRESENCE, Im.PRESENCE_AVAILABLE).build());
        // }
        try {
            mResolver.applyBatch(ContactsContract.AUTHORITY, ops);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (OperationApplicationException e) {
            e.printStackTrace();
        }
    }

    public void setPostal() {
        // Create all postal addresses

        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        for (int i = 0; i < testContactPostal.length; i++) {
            ops.add(ContentProviderOperation.newInsert(Data.CONTENT_URI).withValue(
                    StructuredPostal.RAW_CONTACT_ID, mRawId).withValue(StructuredPostal.MIMETYPE,
                    StructuredPostal.CONTENT_ITEM_TYPE).withValue(
                    StructuredPostal.FORMATTED_ADDRESS, testContactPostal[i]).withValue(
                    StructuredPostal.TYPE, testContactPostalType[i]).build());
        }
        try {
            mResolver.applyBatch(ContactsContract.AUTHORITY, ops);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (OperationApplicationException e) {
            e.printStackTrace();
        }
    }

    public void setOrganization() {
        // Create all Organizations

        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        for (int i = 0; i < testContactOrganizationCompany.length; i++) {
            ops.add(ContentProviderOperation.newInsert(Data.CONTENT_URI).withValue(
                    CommonDataKinds.Organization.RAW_CONTACT_ID, mRawId).withValue(
                    CommonDataKinds.Organization.MIMETYPE,
                    CommonDataKinds.Organization.CONTENT_ITEM_TYPE).withValue(
                    CommonDataKinds.Organization.COMPANY, testContactOrganizationCompany[i])
                    .withValue(CommonDataKinds.Organization.TITLE,
                            testContactOrganizationPosition[i]).withValue(
                            CommonDataKinds.Organization.TYPE, testContactOrganizationType[i])
                    .build());
        }
        try {
            mResolver.applyBatch(ContactsContract.AUTHORITY, ops);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (OperationApplicationException e) {
            e.printStackTrace();
        }
    }

    public void setTimescapePlugin() {
        mValues.clear();

        // REMOVED TIMESCAPE DEPENDENCY for (int i = 0; i <
        // testContactTimescapePluginName.length; i++) {
        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.SNS_ID,
        // testContactTimescapePluginId[i]);
        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.SNS,
        // testContactTimescapePluginName[i]);
        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.CONTACT_ID, mId);

        // insert the link to the sns map in the contacts provider
        // mResolver.insert(ExtendContacts.ExtendSns.CONTENT_URI, mValues);
        // REMOVED TIMESCAPE DEPENDENCY }
    }

    public void setTimescapeFacebookPlugin() {
        mValues.clear();

        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.SNS_ID,
        // testContactTimescapePluginId[0]);
        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.SNS,
        // testContactTimescapePluginName[0]);
        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.CONTACT_ID, mId);

        // insert the link to the sns map in the contacts provider
        // mResolver.insert(ExtendContacts.ExtendSns.CONTENT_URI, mValues);
    }

    public void setTimescapeTwitterPlugin() {
        mValues.clear();

        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.SNS_ID,
        // testContactTimescapePluginId[2]);
        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.SNS,
        // testContactTimescapePluginName[2]);
        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.CONTACT_ID, mId);

        // insert the link to the sns map in the contacts provider
        // mResolver.insert(ExtendContacts.ExtendSns.CONTENT_URI, mValues);

    }

    public void setTimescapeOtherPlugin() {
        mValues.clear();

        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.SNS_ID,
        // testContactTimescapePluginId[1]);
        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.SNS,
        // testContactTimescapePluginName[1]);
        // REMOVED TIMESCAPE DEPENDENCY
        // mValues.put(ExtendContacts.ExtendSns.CONTACT_ID, mId);

        // insert the link to the sns map in the contacts provider
        // mResolver.insert(ExtendContacts.ExtendSns.CONTENT_URI, mValues);
    }

    public Uri getUri() {
        return mContactUri;
    }

    public Uri getRawUri() {
        return ContentUris.withAppendedId(RawContacts.CONTENT_URI, mRawId);
    }

    public long getId() {
        return mId;
    }

    public long getRawId() {
        return mRawId;
    }

    public String getName() {
        return mGivenName;
    }

    public String getFamilyName() {
        return mFamilyName;
    }

    public String getGivenName() {
        return mGivenName;
    }

    public boolean isFavorite() {
        return mIsfavorite;
    }

    public static String getNotes() {
        return testContactNotes;
    }

    public Bitmap getPhoto() {
        return mPhoto;
    }

    public String getRingtone() {
        return mRingtoneName;
    }

    public String getRingtoneFull() {
        return mRingtoneUri.toString();
    }

    public static String[] getNumbers() {
        return testContactNumbers.clone();
    }

    public static int[] getNumberTypes() {
        return testContactNumberTypes.clone();
    }

    public static String[] getEmail() {
        return testContactEmailAddress.clone();
    }

    public static int[] getEmailTypes() {
        return testContactEmailTypes.clone();
    }

    public static String[] getIMAccounts() {
        return testContactIMAccounts.clone();
    }

    public static int[] getIMProviders() {
        return testContactIMProviders.clone();
    }

    public static String[] getPostal() {
        return testContactPostal.clone();
    }

    public static int[] getPostalTypes() {
        return testContactPostalType.clone();
    }

    public static String[] getOrganizationCompany() {
        return testContactOrganizationCompany.clone();
    }

    public static String[] getOrganizationPosition() {
        return testContactOrganizationPosition.clone();
    }

    public static int[] getOrganizationTypes() {
        return testContactOrganizationType.clone();
    }

    public static String[] getTimescapePluginNames() {
        return new String[0];// testContactTimescapePluginName.clone();
    }

    // NOTE!! The contact should not be used anymore after delete has been
    // called.
    public void delete() {
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();

        Uri uri = mContactUri.buildUpon().appendQueryParameter(
                ContactsContract.CALLER_IS_SYNCADAPTER, "1").build();
        ops.add(ContentProviderOperation.newDelete(uri).build());

        for (int i = 0; i < testContactIMAccounts.length; i++) {
            ops.add(ContentProviderOperation.newDelete(StatusUpdates.CONTENT_URI).withSelection(
                    StatusUpdates.IM_HANDLE + "=?", new String[] {
                        testContactIMAccounts[i]
                    }).build());
        }
        try {
            mResolver.applyBatch(ContactsContract.AUTHORITY, ops);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (OperationApplicationException e) {
            e.printStackTrace();
        }
    }

    /**
     * Add phone-numbers of all types to fetch contact icon information
     */
    public void setContactIconNumbers() {
        // Create all Phone numbers based on the different types that
        // exists
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        for (int i = 0; i < testContactIconNumbers.length; i++) {
            ops.add(ContentProviderOperation.newInsert(Data.CONTENT_URI).withValue(
                    Phone.RAW_CONTACT_ID, mRawId)
                    .withValue(Phone.MIMETYPE, Phone.CONTENT_ITEM_TYPE).withValue(Phone.NUMBER,
                            testContactIconNumbers[i]).withValue(Phone.TYPE,
                            testContactNumberTypes[i]).build());
        }
        try {
            mResolver.applyBatch(ContactsContract.AUTHORITY, ops);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (OperationApplicationException e) {
            e.printStackTrace();
        }
    }

    public void addToGroup(String groupName, String accountType, String accountName) {
        long groupId = -1;
        Cursor c = mResolver.query(Groups.CONTENT_URI, new String[] {
            Groups._ID
        }, Groups.TITLE + "=? AND " + Groups.ACCOUNT_NAME + "=? AND " + Groups.ACCOUNT_TYPE + "=?",
                new String[] {
                        groupName, accountName, accountType
                }, null);
        if (c != null) {
            try {
                if (c.moveToNext()) {
                    groupId = c.getLong(0);
                } else {
                    ContentValues values = new ContentValues();
                    values.put(Groups.TITLE, groupName);
                    values.put(Groups.GROUP_VISIBLE, true);
                    values.put(Groups.ACCOUNT_NAME, accountName);
                    values.put(Groups.ACCOUNT_TYPE, accountType);

                    Uri uri = mResolver.insert(Groups.CONTENT_URI, values);
                    groupId = ContentUris.parseId(uri);
                }
            } finally {
                c.close();
            }
        }

        if (groupId > -1) {
            ContentValues values = new ContentValues();
            values.put(GroupMembership.RAW_CONTACT_ID, getRawId());
            values.put(GroupMembership.MIMETYPE, GroupMembership.CONTENT_ITEM_TYPE);
            values.put(GroupMembership.GROUP_ROW_ID, groupId);
            mResolver.insert(Data.CONTENT_URI, values);
        }
    }
}
