/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file
 * @author Niklas Karlsson (niklas.karlsson@sonyericsson.com)
 */
package com.sonyericsson.eventstream.facebookplugin.util;

import android.content.Context;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileReader {
    public static final int MAX_FILE_SIZE = 1024*50;

    public static String readFile(Context context, String filename) {
        if (filename == null) {
            return null;
        }

        String result = null;
        FileInputStream stream = null;
        byte[] buffer = new byte[MAX_FILE_SIZE];

        try {
            stream = context.openFileInput(filename);
            int size = stream.read(buffer, 0, MAX_FILE_SIZE);
            if (size > 0) {
                result = new String(buffer, "UTF-8");
            }
        } catch (FileNotFoundException exception) {
            exception.printStackTrace();
        } catch (IOException io) {
            io.printStackTrace();
        } finally {
            if (stream != null) {
                try {
                    stream.close();
                } catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return result;
    }
}