/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin;

import android.net.Uri;

/**
 * NOTE: This file must not be distributed as sample code externally or internally
 * or by any other means outside SonyEricsson.
 *
 * @author Erik Hellman <erik.hellman@sonyericsson.com>
 *
 */
public interface PluginConstants {

    // Event Stream provider Uri:s
    Uri EVENTSTREAM_FRIEND_PROVIDER_URI = Uri.parse("content://com.sonyericsson.eventstream/friends");
    Uri EVENTSTREAM_EVENT_PROVIDER_URI = Uri.parse("content://com.sonyericsson.eventstream/events");
    Uri EVENTSTREAM_SOURCE_PROVIDER_URI = Uri.parse("content://com.sonyericsson.eventstream/sources");
    Uri EVENTSTREAM_PLUGIN_PROVIDER_URI = Uri.parse("content://com.sonyericsson.eventstream/plugins");

    // Internal intents used in plugin
    String TWITTER_REFRESH_REQUEST = "com.sonyericsson.eventstream.twitterplugin.REFRESH_STATUSES";
    String TWITTER_REGISTER_PLUGIN = "com.sonyericsson.eventstream.twitterplugin.REGISTER_PLUGIN";
    String TWITTER_UPDATE_STATUS = "com.sonyericsson.eventstream.twitterplugin.UPDATE_STATUS";
    String TWITTER_AUTHENTICATE = "com.sonyericsson.eventstream.twitterplugin.AUTHENTICATE";
    String TWITTER_LOGOUT = "com.sonyericsson.eventstream.twitterplugin.TWITTER_LOGOUT";
    String TWITTER_LOCALE_CHANGED = "com.sonyericsson.eventstream.twitterplugin.LOCALE_CHANGED";

    /** Key separator to make event key unique */
    public static final String EVENT_KEY_DATA_SEPARATOR = ";";

    /** Data set as plug-in key value to check that the event signals are valid */
    public static final String PLUGIN_IDENTIFIER = "twitterplugin1424513341302181662identifier";

    /** Configurations in the event stream telephony plug-in */
    public interface Config {
        /** Set to true if debug printouts should be shown */
        public static final boolean DEBUG = false;

        /** Log tag handled in the printouts */
        public static final String LOG_TAG = "TwitterPlugin";
    }

    public interface EventStreamIntentActions {
        public static final String REGISTER = "com.sonyericsson.eventstream.REGISTER_PLUGINS";
        public static final String REFRESH = "com.sonyericsson.eventstream.REFRESH_REQUEST";
        public static final String VIEW_EVENT = "com.sonyericsson.eventstream.VIEW_EVENT_DETAIL";
        public static final String STATUS_UPDATE = "com.sonyericsson.eventstream.SEND_STATUS_UPDATE";
    }

    public interface EventStreamIntentExtraParams {
        public static final String EXTRA_SOURCE_ID = "source_id";
        public static final String EXTRA_FRIEND_ID = "friend_id";
        public static final String EXTRA_EVENT_ID = "event_id";
        public static final String EXTRA_STATUS_UPDATE_MESSAGE = "new_status_message";
        public static final String EXTRA_PLUGIN_KEY = "plugin_key";
        public static final String EXTRA_FRIEND_KEY = "friend_key";
        public static final String EXTRA_EVENT_KEY = "event_key";
    }

    public interface InternalIntentExtraParams {
        public static final String USERNAME = "twitter_username";
        public static final String PASSWORD = "twitter_password";
    }

    public interface PluginColumns {
        public static final String API_VERSION = "api_version";
        public static final String CONFIGURATION_STATE = "config_state";
        public static final String CONFIGURATION_ACTIVITY = "config_activity";
        public static final String CONFIGURATION_TEXT = "config_text";
        public static final String NAME = "name";
        public static final String ICON_URI = "icon_uri";
        public static final String PLUGIN_KEY = "plugin_key";
        public static final String STATUS_SUPPORT = "status_support";
        public static final String STATUS_TEXT_MAX_LENGTH = "status_text_max_length";
    }

    public interface SourceColumns {
        public static final String _ID = "_id";
        public static final String NAME = "name";
        public static final String ICON_URI = "icon_uri";
        public static final String ENABLED = "enabled";
        public static final String CURRENT_STATUS = "current_status";
        public static final String STATUS_TIMESTAMP  = "status_timestamp";
    }

    public interface FriendColumns {
        public static final String _ID = "_id";
        public static final String SOURCE_ID = "source_id";
        public static final String DISPLAY_NAME = "display_name";
        public static final String PROFILE_IMAGE_URI = "profile_image_uri";
        public static final String CONTACTS_REFERENCE = "contacts_reference";
        public static final String FRIEND_KEY = "friend_key";
    }

    public interface EventColumns {
        public static final String _ID = "_id";
        public static final String SOURCE_ID = "source_id";
        public static final String FRIEND_KEY = "friend_key";
        public static final String MESSAGE = "message";
        public static final String IMAGE_URI = "image_uri";
        public static final String PUBLISHED_TIME = "published_time";
        public static final String STATUS_ICON_URI = "status_icon_uri";
        public static final String GEODATA = "geodata";
        public static final String TITLE = "title";
        public static final String PERSONAL = "personal";
        public static final String OUTGOING = "outgoing";
        public static final String EVENT_KEY = "event_key";
    }

    /**
     * Configuration values for Twitter
     */
    public interface TwitterConf {
        int PAGING_COUNT = 200;
        int MAX_CHARACTERS = 140;
        String PAGING_TYPE_MESSAGE = "paging_type_message";
        String PAGING_TYPE_STATUS = "paging_type_status";
        String ACCOUNT_TYPE_SEARCH = "%twitter%";
        String CREATE_ACCOUNT_URL = "https://mobile.twitter.com/signup";
    }
}
