/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin.utils;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.http.AccessToken;

import com.sonyericsson.eventstream.twitterplugin.twitter.TwitterFactoryWrapper;

public class MockTwitterFactory extends TwitterFactoryWrapper {

    private static final int MINUS_ONE = -1;

    private MockTwitter mTwitter;

    private boolean mStatusCodeMinusOne = false;

    public MockTwitterFactory() {
    }

    public void setThrowsExceptionWithStatusCodeMinusOne() {
        mStatusCodeMinusOne = true;
    }
    /**
     * Set a instance of a mock twitter object
     * @param twitter
     */
    public void setMockTwitterInstance(MockTwitter twitter) {
        mTwitter = twitter;
    }

    @Override
    public Twitter getInstance(String screenName, String password) throws TwitterException {
        if (mTwitter == null) {
            throw new TwitterException("", new IllegalStateException(), TwitterException.UNAUTHORIZED);
        }
        return mTwitter;
    }

    @Override
    public Twitter getOAuthAuthorizedInstance(AccessToken accessToken) throws TwitterException {
        if (mTwitter == null) {
            throw new TwitterException("", new IllegalStateException(), TwitterException.UNAUTHORIZED);
        }

        if (mStatusCodeMinusOne) {
            throw new TwitterException("", new IllegalStateException(), MINUS_ONE);
        }

        return mTwitter;
    }
}
