/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin.utils;

import twitter4j.PagableResponseList;
import twitter4j.RateLimitStatus;
import twitter4j.User;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

@SuppressWarnings("serial")
// Twitter4j: Implementation of PagableResponseList with User. Cursor is used to set/get
// >100users in list.
public class PagableResponseListImpl implements PagableResponseList<User> {

    List<User> mUsers;

    long previous = 0;
    long next = 0;

    boolean hasNext = false;


    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }


    public void setNextCursor(long next) {
        this.next = next;
    }

    public void setPreviousCursor(long next) {
        this.next = previous;
    }


    public PagableResponseListImpl() {
        mUsers = new LinkedList<User>();
    }

    public long getNextCursor() {
        return next;
    }

    public long getPreviousCursor() {
        return previous;
    }

    public boolean hasNext() {
        return hasNext;
    }

    public boolean hasPrevious() {
        return mUsers.listIterator().hasPrevious();
    }

    public RateLimitStatus getFeatureSpecificRateLimitStatus() {
        return null;
    }

    public RateLimitStatus getRateLimitStatus() {
        return null;
    }

    public boolean add(User arg0) {
        return mUsers.add(arg0);
    }

    public void add(int arg0, User arg1) {
        mUsers.add(arg0, arg1);
    }

    public boolean addAll(Collection<? extends User> arg0) {
        return mUsers.addAll(arg0);
    }

    public boolean addAll(int arg0, Collection<? extends User> arg1) {
        return mUsers.addAll(arg0, arg1);
    }

    public void clear() {
        mUsers.clear();
    }

    public boolean contains(Object arg0) {
        return mUsers.contains(arg0);
    }

    public boolean containsAll(Collection<?> arg0) {
        return mUsers.containsAll(arg0);
    }

    public User get(int arg0) {
        return mUsers.get(arg0);
    }

    public int indexOf(Object arg0) {
        return mUsers.indexOf(arg0);
    }

    public boolean isEmpty() {
        return mUsers.isEmpty();
    }

    public Iterator<User> iterator() {
        return mUsers.iterator();
    }

    public int lastIndexOf(Object arg0) {
        return mUsers.lastIndexOf(arg0);
    }

    public ListIterator<User> listIterator() {
        return mUsers.listIterator();
    }

    public ListIterator<User> listIterator(int arg0) {
        return mUsers.listIterator(arg0);
    }

    public User remove(int arg0) {
        return mUsers.remove(arg0);
    }

    public boolean remove(Object arg0) {
        return mUsers.remove(arg0);
    }

    public boolean removeAll(Collection<?> arg0) {
        return mUsers.removeAll(arg0);
    }

    public boolean retainAll(Collection<?> arg0) {
        return mUsers.retainAll(arg0);
    }

    public User set(int arg0, User arg1) {
        return mUsers.set(arg0, arg1);
    }

    public int size() {
        return mUsers.size();
    }

    public List<User> subList(int arg0, int arg1) {
        return mUsers.subList(arg0, arg1);
    }

    public Object[] toArray() {
        return mUsers.toArray();
    }

    public <K> K[] toArray(K[] arg0) {
        return mUsers.toArray(arg0);
    }
}
