//! @file ai.cpp
//! @brief AIcontrolNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2016, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "ai.h"

//! @brief RXgN^
AIcontrol::AIcontrol(class ObjectManager *in_ObjMgr, int in_ctrlid, class BlockDataInterface *in_blocks, class PointDataInterface *in_Points, class ParameterInfo *in_Param, class Collision *in_CollD, class SoundManager *in_GameSound)
{
	ObjMgr = in_ObjMgr;
	ctrlid = in_ctrlid;
	ctrlhuman = in_ObjMgr->GeHumanObject(in_ctrlid);
	blocks = in_blocks;
	Points = in_Points;
	Param = in_Param;
	CollD = in_CollD;
	GameSound = in_GameSound;

	battlemode = AI_NORMAL;
	movemode = AI_WAIT;
	addrx = 0.0f;
	addry = 0.0f;
	target_pointid = -1;
	target_posx = 0.0f;
	target_posz = 0.0f;
	target_rx = 0.0f;
	total_move = 0.0f;
	waitcnt = 0;
	movejumpcnt = 1*((int)GAMEFPS);
	gotocnt = 0;
	moveturn_mode = 0;
	longattack = false;
}

//! @brief fBXgN^
AIcontrol::~AIcontrol()
{}

//! @brief ΏۃNXݒ
//! @attention ̊֐ŐݒsȂƁANX̂@\܂B
void AIcontrol::SetClass(class ObjectManager *in_ObjMgr, int in_ctrlid, class BlockDataInterface *in_blocks, class PointDataInterface *in_Points, class ParameterInfo *in_Param, class Collision *in_CollD, class SoundManager *in_GameSound)
{
	ObjMgr = in_ObjMgr;
	ctrlid = in_ctrlid;
	ctrlhuman = in_ObjMgr->GeHumanObject(in_ctrlid);
	blocks = in_blocks;
	Points = in_Points;
	Param = in_Param;
	CollD = in_CollD;
	GameSound = in_GameSound;
}

//! @brief l
//! @param in_p4 l̑4p[^iFԍj
//! @param out_x XW󂯎|C^
//! @param out_z ZW󂯎|C^
//! @return F1@sF0
int AIcontrol::SearchHumanPos(signed char in_p4, float *out_x, float *out_z)
{
	float x, z;
	human* thuman;

	//lăNX擾
	thuman = ObjMgr->SearchHuman(in_p4);
	if( thuman == NULL ){ return 0; }

	//XEZW擾
	thuman->GetPosData(&x, NULL, &z, NULL);
	*out_x = x;
	*out_z = z;
	return 1;
}

//! @brief ڕWn_ɈړĂ邩mF
//! @return BFtrue@񓞒BFfalse
bool AIcontrol::CheckTargetPos()
{
	//Zo
	float x = posx - target_posx;
	float z = posz - target_posz;
	float r = x * x + z * z;

	if( movemode == AI_TRACKING ){	//ǔȂ
		if( r < AI_ARRIVALDIST_TRACKING * AI_ARRIVALDIST_TRACKING ){
			return true;
		}
	}
	else{							//ȊOȂ
		if( r < (AI_ARRIVALDIST_PATH * AI_ARRIVALDIST_PATH) ){
			return true;
		}
	}

	return false;
}

//! @brief ڕWn_
//! @param next 
//! @return Ftrue@sFfalse
bool AIcontrol::SearchTarget(bool next)
{
	//|Cg̏擾
	pointdata pdata;
	if( Points->Getdata(&pdata, target_pointid) != 0 ){
		movemode = AI_NULL;
		return false;
	}

	signed char nextpointp4;

	//̃|CgȂ
	if( next == true ){
		nextpointp4 = pdata.p3;

		//_pX
		if( pdata.p1 == 8 ){
			if( GetRand(2) == 0 ){
				nextpointp4 = pdata.p2;
			}
			else{
				nextpointp4 = pdata.p3;
			}
			movemode = AI_RANDOM;
		}

		//|Cg
		if( Points->SearchPointdata(&pdata, 0x08, 0, 0, 0, nextpointp4, 0) == 0 ){
			return false;
		}
	}

	//_pXȂ玟
	if( pdata.p1 == 8 ){
		target_pointid = pdata.id;
		movemode = AI_RANDOM;
		return false;
	}

	//lȂW擾
	if( (pdata.p1 == 1)||(pdata.p1 == 6) ){
		SearchHumanPos(pdata.p4, &target_posx, &target_posz);
		movemode = AI_TRACKING;
		return true;
	}

	//ړpXȂ`
	if( pdata.p1 == 3 ){
		//Kp
		target_pointid = pdata.id;
		target_posx = pdata.x;
		target_posz = pdata.z;
		target_rx = pdata.r;

		//ړXe[gݒ
		switch(pdata.p2){
			case 0: movemode = AI_WALK; break;
			case 1: movemode = AI_RUN; break;
			case 2: movemode = AI_WAIT; break;
			case 3:
				movemode = AI_TRACKING;
				if( next == true ){
					nextpointp4 = pdata.p3;

					//|Cgilj̏擾
					if( Points->SearchPointdata(&pdata, 0x08, 0, 0, 0, nextpointp4, 0) == 0 ){
						return false;
					}

					//ۑ
					target_pointid = pdata.id;
					target_posx = pdata.x;
					target_posz = pdata.z;
				}
				break;
			case 4: movemode = AI_WAIT; break;
			case 5: movemode = AI_STOP; break;
			case 6: movemode = AI_GRENADE; break;
			case 7: movemode = AI_RUN2; break;
			default: break;
		}
		return true;
	}
	
	movemode = AI_NULL;
	return false;
}

//! @brief ڕWn_Ɉړ
void AIcontrol::MoveTarget()
{
	float r, atan;
	int paramid;
	HumanParameter Paraminfo;
	bool zombie;

	//]rǂ
	ctrlhuman->GetParamData(&paramid, NULL, NULL, NULL);
	Param->GetHuman(paramid, &Paraminfo);
	if( Paraminfo.type == 2 ){
		zombie = true;
	}
	else{
		zombie = false;
	}

	//xSĂ̓~߂
	moveturn_mode = 0;

	//ڕWn_ւ̊px߂
	CheckTargetAngle(posx, 0.0f, posz, rx*-1 + (float)M_PI/2, 0.0f, target_posx, 0.0f, target_posz, 0.0f, &atan, NULL, &r);

	//
	if( atan > DegreeToRadian(0.5f) ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}
	if( atan < DegreeToRadian(-0.5f) ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}

	//Oi
	if( zombie == true ){
		if( fabs(atan) < DegreeToRadian(20) ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
		}
	}
	else if( battlemode == AI_CAUTION ){
		if( fabs(atan) < DegreeToRadian(50) ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
		}
	}
	else if( movemode == AI_WALK ){
		if( fabs(atan) < DegreeToRadian(6) ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
		}
	}
	else if( (movemode == AI_RUN)||(movemode == AI_RUN2) ){
		if( fabs(atan) < DegreeToRadian(50) ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
		}
	}
	else if( (movemode == AI_WAIT)||(movemode == AI_STOP) ){
		if( fabs(atan) < DegreeToRadian(6) ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
		}
	}
	else{	//movemode == AI_TRACKING
		if( fabs(atan) < DegreeToRadian(20) ){
			if( r < (AI_ARRIVALDIST_WALKTRACKING * AI_ARRIVALDIST_WALKTRACKING) ){
				SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
			}
			else{
				SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			}
		}
	}

	//Wv
	if( GetRand(16) == 0 ){
		MoveJump();
	}

	//|ĂAEւ̉]_ɍs
	if( GetRand(28) == 0 ){
		if( ctrlhuman->GetMovemode(true) != 0 ){
			if( ctrlhuman->GetTotalMove() - total_move < 0.1f ){
				if( GetRand(2) == 0 ){ SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT); }
				else{ SetFlag(moveturn_mode, AI_CTRL_TURNLEFT); }
			}
		}
	}
	total_move = ctrlhuman->GetTotalMove();
}

//! @brief ڕWn_ɈړiDIȑpj
void AIcontrol::MoveTarget2()
{
	float atan;

	//ڕWn_ւ̊px߂
	CheckTargetAngle(posx, 0.0f, posz, rx*-1 + (float)M_PI/2, 0.0f, target_posx, 0.0f, target_posz, 0.0f, &atan, NULL, NULL);

	//Oړ̏
	if( fabs(atan) < DegreeToRadian(56) ){
		SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
	}
	if( fabs(atan) > DegreeToRadian(123.5f) ){
		SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
	}

	//Eړ̏
	if( (DegreeToRadian(-146) < atan)&&(atan < DegreeToRadian(-33)) ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( (DegreeToRadian(33) < atan)&&(atan < DegreeToRadian(146)) ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}

	//Wv
	if( GetRand(16) == 0 ){
		MoveJump();
	}

	//|ĂAEւ̉]_ɍs
	if( GetRand(28) == 0 ){
		if( ctrlhuman->GetMovemode(true) != 0 ){
			if( ctrlhuman->GetTotalMove() - total_move < 0.1f ){
				if( GetRand(2) == 0 ){ SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT); }
				else{ SetFlag(moveturn_mode, AI_CTRL_TURNLEFT); }
			}
		}
	}
	total_move = ctrlhuman->GetTotalMove();
}

//! @brief O㍶E_ɈړiUpj
void AIcontrol::MoveRandom()
{
	int forwardstart, backstart, sidestart;

	if( longattack == false ){
		forwardstart = 80;
		backstart = 90;
		sidestart = 70;
	}
	else{
		forwardstart = 120;
		backstart = 150;
		sidestart = 130;
	}

	//_Ɉړn߂
	if( GetRand(forwardstart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
	}
	if( GetRand(backstart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
	}
	if( GetRand(sidestart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_MOVELEFT);
	}
	if( GetRand(sidestart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
	}

	//Ă炸AԂȂ
	if( ctrlhuman->GetMainWeaponTypeNO() == ID_WEAPON_NONE ){
		// 1/80̊mŉn߂
		if( GetRand(80) == 0 ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
		}
	}

	// 1/3̊mAړtOݒ肳Ă
	if( (GetRand(3) == 0)||(GetFlag(moveturn_mode, (AI_CTRL_MOVEFORWARD | AI_CTRL_MOVEBACKWARD | AI_CTRL_MOVELEFT | AI_CTRL_MOVERIGHT))) ){
		float vx, vz;
		float Dist;

		if( GetRand(2) == 0 ){
			//ÕxNgvZ
			vx = cos(rx*-1 + (float)M_PI/2);
			vz = sin(rx*-1 + (float)M_PI/2);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGTH, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 1.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//OitO폜AރtOݒ
				DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
				SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
			}

			//̃xNgvZ
			vx = cos(rx*-1 + (float)M_PI/2 + (float)M_PI);
			vz = sin(rx*-1 + (float)M_PI/2 + (float)M_PI);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGTH, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 1.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//ރtO폜AOitOݒ
				DelFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
				SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			}
		}
		else{
			//
			vx = cos(rx*-1);
			vz = sin(rx*-1);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGTH, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 1.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//EړtO폜AړtOݒ
				DelFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
				SetFlag(moveturn_mode, AI_CTRL_MOVELEFT);
			}

			vx = cos(rx*-1 + (float)M_PI);
			vz = sin(rx*-1 + (float)M_PI);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGTH, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 1.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//ړtO폜AEړtOݒ
				DelFlag(moveturn_mode, AI_CTRL_MOVELEFT);
				SetFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
			}
		}
	}

	//UΏۂȂ
	if( enemyhuman != NULL ){
		float tx, ty, tz;

		enemyhuman->GetPosData(&tx, &ty, &tz, NULL);

		float x = posx - tx;
		float y = posy - ty;
		float z = posz - tz;
		float r = x * x + y * y + z * z;

		//Gɋ߂ÂȂނ
		if( r < 20.0f * 20.0f ){
			DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			if( GetRand(70) == 0 ){
				SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
			}
		}
	}
}

//! @brief ̏܂킷
void AIcontrol::TurnSeen()
{
	int turnstart, turnstop;

	//]̊JnEImݒ
	if( battlemode == AI_ACTION ){
		return;
	}
	else if( battlemode == AI_CAUTION ){
		turnstart = 20;
		turnstop = 20;
	}
	else{
		if( movemode == AI_TRACKING ){ turnstart = 65; }
		else{ turnstart = 85; }
		turnstop = 18;
	}

	//_ɉ]n߂
	if( GetRand(turnstart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( GetRand(turnstart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}

	if( (battlemode == AI_NORMAL)&&(movemode == AI_WAIT) ){
		//_Ƀ|Cg̕Ƃ
		//u|Cg̕dv̍Č 
		if( GetRand(80) == 0 ){
			float tr;
			tr = target_rx - rx;
			for(; tr > (float)M_PI; tr -= (float)M_PI*2){}
			for(; tr < (float)M_PI*-1; tr += (float)M_PI*2){}

			if( tr > 0.0f ){
				SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
			}
			if( tr < 0.0f ){
				SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
			}
		}
	}

	//]_Ɏ~߂
	if( GetRand(turnstop) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( GetRand(turnstop) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}
}

//! @brief ̕
bool AIcontrol::StopSeen()
{
	float tr;
	bool returnflag = false;

	tr = target_rx - rx;
	for(; tr > (float)M_PI; tr -= (float)M_PI*2){}
	for(; tr < (float)M_PI*-1; tr += (float)M_PI*2){}

	DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);

	//
	if( tr > DegreeToRadian(2.5f) ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
		returnflag = false;
	}
	if( tr < DegreeToRadian(-2.5f) ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
		returnflag = false;
	}

	//ɌĂ邩
	if( fabs(tr) <= DegreeToRadian(2.5f) ){
		returnflag = true;
	}

	return returnflag;
}

//! @brief isɏQ΃Wv
bool AIcontrol::MoveJump()
{
	//~܂ĂΏȂ
	if( ctrlhuman->GetMovemode(false) == 0 ){ return false; }

	float dist_dummy;

	float new_posx, new_posy, new_posz;

	//t߂̂蔻
	new_posx = posx + cos(rx*-1 + (float)M_PI/2) * (AI_CHECKJUMP_DIST + HUMAN_MAPCOLLISION_R);
	new_posy = posy + HUMAN_MAPCOLLISION_HEIGTH;
	new_posz = posz + sin(rx*-1 + (float)M_PI/2) * (AI_CHECKJUMP_DIST + HUMAN_MAPCOLLISION_R);
	if( CollD->CheckALLBlockInside(new_posx, new_posy, new_posz) == true ){
		ObjMgr->MoveJump(ctrlid);
		return true;
	}

	//̑Ŝ̂蔻
	new_posx = posx + cos(rx*-1 + (float)M_PI/2) * AI_CHECKJUMP_DIST;
	new_posy = posy + AI_CHECKJUMP_HEIGHT;
	new_posz = posz + sin(rx*-1 + (float)M_PI/2) * AI_CHECKJUMP_DIST;
	if( CollD->CheckALLBlockInside(new_posx, new_posy, new_posz) == true ){
		ObjMgr->MoveJump(ctrlid);
		return true;
	}
	else if( CollD->CheckALLBlockIntersectRay(new_posx, new_posy, new_posz, 0.0f, 1.0f, 0.0f, NULL, NULL, &dist_dummy, HUMAN_HEIGTH - AI_CHECKJUMP_HEIGHT) == true ){
		ObjMgr->MoveJump(ctrlid);
		return true;
	}

	return false;
}

//! @brief U
//! @todo ]ȓ߂܂鏈
void AIcontrol::Action()
{
	human* EnemyHuman = NULL;
	int paramid;
	HumanParameter Paraminfo;
	bool zombie;
	float posy2;
	float tx, ty, tz;

	EnemyHuman = enemyhuman;

	//W擾
	EnemyHuman->GetPosData(&tx, &ty, &tz, NULL);
	posy2 = posy + VIEW_HEIGHT;
	ty += VIEW_HEIGHT;

	//]rǂ
	ctrlhuman->GetParamData(&paramid, NULL, NULL, NULL);
	Param->GetHuman(paramid, &Paraminfo);
	if( Paraminfo.type == 2 ){
		zombie = true;
	}
	else{
		zombie = false;
	}

	//Ă镐̎ނ擾
	int weaponid = ctrlhuman->GetMainWeaponTypeNO();

	float atanx, atany, r;

	//֒eĂ΁`
	if( weaponid == ID_WEAPON_GRENADE ){
		if( zombie == false ){
			float x = posx - tx;
			float z = posz - tz;
			float r = x * x + z * z;
			float scale;
			if( longattack == false ){ scale = 0.12f; }
			else{ scale = 0.4f; }

			//ɉčς
			ty += (sqrt(r) - 200.0f) * scale;
		}
	}
	else{
		float mx, mz;
		float scale;
		EnemyHuman->GetMovePos(&mx, NULL, &mz);
		if( longattack == false ){ scale = 1.5f; }
		else{
			float x = posx - tx;
			float z = posz - tz;
			float r = x * x + z * z;

			scale = sqrt(r) * 0.12f;
		}

		//G̈ړ
		tx += mx * scale;
		tz += mz * scale;
	}

	//ڕWn_ւ̊px߂
	CheckTargetAngle(posx, posy2, posz, rx*-1 + (float)M_PI/2, ry, tx, ty, tz, 0.0f, &atanx, &atany, &r);

	//ς^C~O
	int randr = LevelParam->aiming;
	if( longattack == false ){ randr += 1; }
	else{ randr += 2; }

	if( randr != 0 ){
		//
		if( atanx > 0.0f ){
			SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
			DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
		}
		if( atanx < 0.0f ){
			SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
			DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
		}

		//r̊px
		if( zombie == true ){
			//ry = 0.0f;

			//
			if( ry < 0.0f ){
				SetFlag(moveturn_mode, AI_CTRL_TURNUP);
				DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
			}
			if( ry > 0.0f ){
				SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
				DelFlag(moveturn_mode, AI_CTRL_TURNUP);
			}
		}
		else{
			//ԂȂ΁`
			if( weaponid == ID_WEAPON_NONE ){
				if( EnemyHuman->GetMainWeaponTypeNO() == ID_WEAPON_NONE ){	//GԂȂ΁`
					//Ɍ
					SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
					DelFlag(moveturn_mode, AI_CTRL_TURNUP);
				}
				else{														//GĂ΁`
					//Ɍ
					SetFlag(moveturn_mode, AI_CTRL_TURNUP);
					DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
				}
			}
			else{
				//
				if( atany > 0.0f ){
					SetFlag(moveturn_mode, AI_CTRL_TURNUP);
					DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
				}
				if( atany < 0.0f ){
					SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
					DelFlag(moveturn_mode, AI_CTRL_TURNUP);
				}
			}
		}
	}

	//]rȊOŎԂȂ
	if( zombie == false ){
		if( weaponid == ID_WEAPON_NONE ){
			//̊mŌނ
			if( GetRand(80) == 0 ){
				SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
			}
		}
	}

	
	if( zombie == true ){	//]r̍U
		float y = posy2 - ty;

		//Ă΁Axɐ؂ւ
		if( GetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD) ){
			DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
		}

		//GɌđOi
		if( fabs(atanx) <= DegreeToRadian(25) ){
			if( (fabs(atanx) <= DegreeToRadian(15)) && (r < 24.0f*24.0f) && (actioncnt%50 > 20) ){
				//A
				SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
				DelFlag(moveturn_mode, AI_CTRL_MOVEWALK);
			}
			else{
				SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
			}
		}

		/*
		//Wv
		if( GetRand(16) == 0 ){
			MoveJump();
		}
		*/

		if( (r < 9.0f*9.0f)&&( fabs(y) < 10.0f) ){
			float x = posx - tx;
			float z = posz - tz;

			//߂܂@iGtj
			EnemyHuman->AddPosOrder(atan2(z, x), 0.0f, 0.5f);

			//G̎__ɓ
			float erx, ery;
			EnemyHuman->GetRxRy(&erx, &ery);
			switch(GetRand(3)){
				case 0: erx -= DegreeToRadian(2); break;
				case 1: erx += DegreeToRadian(2); break;
				default: break;
			}
			switch(GetRand(3)){
				case 0: ery -= DegreeToRadian(2); break;
				case 1: ery += DegreeToRadian(2); break;
				default: break;
			}
			EnemyHuman->SetRxRy(erx, ery);
		}

		if( actioncnt%50 == 0){
			if( ObjMgr->CheckZombieAttack(ctrlhuman, EnemyHuman) == true ){
				ObjMgr->HitZombieAttack(EnemyHuman);
			}
		}
	}
	else{					//C
		float ShotAngle;
		if( longattack == false ){
			//G𑨂Ɣ肷Ae덷vZ
			ShotAngle = DegreeToRadian(8);
			if( weaponid != ID_WEAPON_NONE ){
				WeaponParameter wparam;
				Param->GetWeapon(weaponid, &wparam);
				if( wparam.scopemode == 1 ){
					ShotAngle = DegreeToRadian(6);
				}
				if( wparam.scopemode == 2 ){
					ShotAngle = DegreeToRadian(4);
				}
			}

			//AIxƂɒ
			ShotAngle += DegreeToRadian(0.5f) * LevelParam->limitserror;

			if( movemode == AI_RUN2 ){
				ShotAngle *= 1.5f;
			}
		}
		else{
			//G𑨂Ɣ肷Ae덷vZ
			ShotAngle = DegreeToRadian(4);
			if( weaponid != ID_WEAPON_NONE ){
				WeaponParameter wparam;
				Param->GetWeapon(weaponid, &wparam);
				if( wparam.scopemode == 1 ){
					ShotAngle = DegreeToRadian(3);
				}
				if( wparam.scopemode == 2 ){
					ShotAngle = DegreeToRadian(2);
				}
			}

			//AIxƂɒ
			ShotAngle += DegreeToRadian(0.2f) * LevelParam->limitserror;
		}

		//G𑨂Ă
		float atanxy = fabs(atanx) + fabs(atany);
		if( atanxy < ShotAngle ){
			int rand = LevelParam->attack;
			if( longattack == true ){ rand += 1; }

			//C
			if( GetRand(rand) == 0 ){
				ObjMgr->ShotWeapon(ctrlid);
			}
		}
	}

	//ɉċߋE؂ւ
	//@200.0fsb^Őݒlێ
	if( r < 200.0f * 200.0f ){
		longattack = false;
	}
	if( (r > 200.0f * 200.0f)&&(movemode != AI_RUN2) ){
		longattack = true;
	}

	if( zombie == false ){
		//_Ɉړ
		MoveRandom();
	}

	actioncnt += 1;
}

//! @brief ULZ
bool AIcontrol::ActionCancel()
{
	//퓬tOLȂI
	if( NoFight == true ){
		return true;
	}

	//GSI
	if( enemyhuman->GetDeadFlag() == true ){
		return true;
	}

	//擾
	float tx, ty, tz;
	enemyhuman->GetPosData(&tx, &ty, &tz, NULL);
	float x = posx - tx;
	float y = posy - ty;
	float z = posz - tz;
	float r = x*x + y*y + z*z;

	//߂ĂI
	if( r > 620.0f*620.0f ){
		return true;
	}

	if( longattack == false ){
		//Kȃ^C~OœG邩mF
		if( GetRand(40) == 0 ){
			//ubNՂĂiȂjȂΏI
			if( CheckLookEnemy(enemyhuman, AI_SEARCH_RX, AI_SEARCH_RY, 620.0f, NULL) == false ){
				return true;
			}
		}

		//IɏI
		if( GetRand(550) == 0 ){
			return true;
		}
	}
	else{
		//Kȃ^C~OœG邩mF
		if( GetRand(30) == 0 ){
			//ubNՂĂiȂjȂΏI
			if( CheckLookEnemy(enemyhuman, AI_SEARCH_RX, AI_SEARCH_RY, 620.0f, NULL) == false ){
				return true;
			}
		}

		//IɏI
		if( GetRand(450) == 0 ){
			return true;
		}
	}

	return false;
}

//! @brief 
int AIcontrol::HaveWeapon()
{
	int selectweapon;
	class weapon *weapon[TOTAL_HAVEWEAPON];
	int nbs;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}

	//̏擾
	ctrlhuman->GetWeapon(&selectweapon, weapon);

	//Ă΁Ave擾
	if( weapon[selectweapon] != NULL ){
		weapon[selectweapon]->GetParamData(NULL, NULL, &nbs);
	}

	//ĂȂAe0Ȃ
	if( (weapon[selectweapon] == NULL)||(nbs == 0) ){
		//̕w
		int notselectweapon = selectweapon + 1;
		if( notselectweapon == TOTAL_HAVEWEAPON ){ notselectweapon = 0; }

		//̕Ă
		if( weapon[notselectweapon] != NULL ){
			//̒̕e0łȂ
			weapon[notselectweapon]->GetParamData(NULL, NULL, &nbs);
			if( nbs > 0 ){
				//ւ
				ObjMgr->ChangeWeapon(ctrlid);
				return 1;
			}
		}
	}

	return 0;
}

//! @brief ړ]_ɏI
void AIcontrol::CancelMoveTurn()
{
	int forward, back, side, updown, rightleft;

	if( battlemode == AI_ACTION ){			//U
		if( movemode == AI_RUN2 ){				//DIȑ
			DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			DelFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
			DelFlag(moveturn_mode, AI_CTRL_MOVELEFT);
			DelFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
			DelFlag(moveturn_mode, AI_CTRL_TURNUP);
			DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
			DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
			DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
			if( GetRand(3) == 0 ){
				DelFlag(moveturn_mode, AI_CTRL_MOVEWALK);
			}
			return;
		}
		else{									//DIȑ ȊO
			if( longattack == false ){
				forward = 6;
				back = 6;
				side = 7;
				updown = 5;
				rightleft = 6;
			}
			else{
				forward = 5;
				back = 4;
				side = 5;
				updown = 3;
				rightleft = 3;
			}
		}
	}
	else if( battlemode == AI_CAUTION ){	//x
		forward = 10;
		back = 10;
		side = 10;
		updown = 14;
		rightleft = 20;
	}
	else{
		forward = 12;
		back = 12;
		side = 12;
		updown = 15;
		rightleft = 18;
	}

	//ړ_Ɏ~߂
	if( GetRand(forward) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
	}
	if( GetRand(back) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
	}
	if( GetRand(side) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVELEFT);
	}
	if( GetRand(side) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
	}
	if( GetRand(3) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVEWALK);
	}

	//]_Ɏ~߂
	if( GetRand(updown) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNUP);
	}
	if( GetRand(updown) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
	}
	if( GetRand(rightleft) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}
	if( GetRand(rightleft) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
}

//! @brief ړ]s
void AIcontrol::ControlMoveTurn()
{
	//ړ̎s
	if( GetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD) ){
		ObjMgr->MoveForward(ctrlid);
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD) ){
		ObjMgr->MoveBack(ctrlid);
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVELEFT) ){
		ObjMgr->MoveLeft(ctrlid);
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVERIGHT) ){
		ObjMgr->MoveRight(ctrlid);
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVEWALK) ){
		ObjMgr->MoveWalk(ctrlid);
	}

	//]̎si]x̉Zj
	if( GetFlag(moveturn_mode, AI_CTRL_TURNUP) ){
		addry += AI_ADDTURNRAD;
	}
	if( GetFlag(moveturn_mode, AI_CTRL_TURNDOWN) ){
		addry -= AI_ADDTURNRAD;
	}
	if( GetFlag(moveturn_mode, AI_CTRL_TURNLEFT) ){
		addrx -= AI_ADDTURNRAD;
	}
	if( GetFlag(moveturn_mode, AI_CTRL_TURNRIGHT) ){
		addrx += AI_ADDTURNRAD;
	}

	//pxɉZ
	rx += addrx;
	ry += addry;

	//]x̌
	addrx *= 0.8f;
	addry *= 0.8f;

	//0.0f֕␳
	if( fabs(addrx) < DegreeToRadian(0.2f) ){ addrx = 0.0f; }
	if( fabs(addry) < DegreeToRadian(0.2f) ){ addry = 0.0f; }

	//c̉]͈͂߂
	if( ry > DegreeToRadian(70) ){ ry = DegreeToRadian(70); }
	if( ry < DegreeToRadian(-70) ){ ry = DegreeToRadian(-70); }
}

//! @brief [hÊĂ
//! @return ̂ĂF1@[hF2@ւF3@FULL/SEMI؂ւF4@ȂF0
int AIcontrol::ControlWeapon()
{
	int selectweapon;
	class weapon *weapon[TOTAL_HAVEWEAPON];
	int weaponid, lnbs, nbs;
	WeaponParameter paramdata;
	bool blazingmodeS, blazingmodeN;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}

	//̏擾
	ctrlhuman->GetWeapon(&selectweapon, weapon);
	if( weapon[selectweapon] == NULL ){ return 0; }
	weapon[selectweapon]->GetParamData(&weaponid, &lnbs, &nbs);

	//̐\擾
	if( Param->GetWeapon(weaponid, &paramdata) == 1 ){ return 0; }

	//XR[v
	ctrlhuman->SetDisableScope();

	//uP[XvȂ牽Ȃ
	if( weaponid == ID_WEAPON_CASE ){ return 0; }

	//퓬ɃOl[hĂ
	if( battlemode == AI_ACTION ){
		if( weaponid == ID_WEAPON_GRENADE ){
			int nextselectweapon, nextnds;

			//̒̕e擾
			nextselectweapon = selectweapon + 1;
			nextnds = 0;
			if( nextselectweapon == TOTAL_HAVEWEAPON ){
				nextselectweapon = 0;
			}
			if( weapon[nextselectweapon] != NULL ){
				weapon[nextselectweapon]->GetParamData(NULL, NULL, &nextnds);
			}

			if( longattack == false ){
				// 1/100̊mŎւ
				if( (GetRand(100) == 0)&&(nextnds > 0) ){
					ObjMgr->ChangeWeapon(ctrlid);
					return 3;
				}
			}
			else{
				// 1/66̊mŎւ
				if( (GetRand(66) == 0)&&(nextnds > 0) ){
					ObjMgr->ChangeWeapon(ctrlid);
					return 3;
				}
			}
		}
	}

	//ce
	if( lnbs == 0 ){
		int ways;

		//m
		if( battlemode == AI_NORMAL ){ ways = 1; }
		else if( battlemode == AI_CAUTION ){ ways = 10; }
		else{ ways = 8; }

		// 1/ways̊mŏ
		if( GetRand(ways) == 0 ){
			int under;

			//[hm
			if( battlemode == AI_NORMAL ){
				ways = 1;
				under = 0;
			}
			else if( battlemode == AI_CAUTION ){
				ways = 5;
				under = 3;
			}
			else{
				if( longattack == false ){
					// ḿ@3/4
					ways = 4;
					under = 2;
				}
				else{
					// ḿ@2/3
					ways = 3;
					under = 1;
				}
			}

			//eΎ̂Ă
			if( nbs == 0 ){
				ObjMgr->DumpWeapon(ctrlid);
				return 1;
			}

			//_ [hs or 
			if( GetRand(ways) <= under ){
				ObjMgr->ReloadWeapon(ctrlid);
				return 2;
			}
			//else{
				ObjMgr->ChangeWeapon(ctrlid);
				return 3;
			//}
		}
	}

	//Aː؂ւ\ȕȂ
	if( paramdata.ChangeWeapon != -1 ){
		//݂̘̕Aːݒ擾
		blazingmodeS = paramdata.blazingmode;

		//Vȕ̘Aːݒ擾
		if( Param->GetWeapon(paramdata.ChangeWeapon, &paramdata) == 1 ){ return 0; }
		blazingmodeN = paramdata.blazingmode;

		if( longattack == false ){
			//ߋUŁASEMIE؂ւFULLɂȂȂ
			if( (blazingmodeS == false)||(blazingmodeN == true) ){
				ObjMgr->ChangeShotMode(ctrlid);	//؂ւ
				return 4;
			}
		}
		else{
			//UŁAFULLE؂ւSEMIɂȂȂ
			if( (blazingmodeS == true)||(blazingmodeN == false) ){
				ObjMgr->ChangeShotMode(ctrlid);	//؂ւ
				return 4;
			}
		}
	}

	return 0;
}

//! @brief ֒e𓊂
//! @return F0@IF1@֒eĂȂF2
//! @attention ֒e𓊂pXɉłBG̍UAction()֐QƂĂB
int AIcontrol::ThrowGrenade()
{
	int selectweapon;
	class weapon *weapon[TOTAL_HAVEWEAPON];
	int weaponid, nbs, i;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}

	//֒eĂ邩mF
	ctrlhuman->GetWeapon(&selectweapon, weapon);
	for(i=0; i<TOTAL_HAVEWEAPON; i++){
		if( weapon[i] != NULL ){
			weapon[i]->GetParamData(&weaponid, NULL, &nbs);
			if( weaponid == ID_WEAPON_GRENADE ){
				break;
			}
		}
	}
	if( i == TOTAL_HAVEWEAPON ){
		return 2;
	}

	//֒eĂȂ΁A؂ւ
	if( i != selectweapon ){
		ObjMgr->ChangeWeapon(ctrlid, i);
	}

	pointdata pdata;
	float posy2;
	float atan_rx, atan_ry;

	//pXƐl̍擾
	Points->Getdata(&pdata, target_pointid);
	posy2 = posy + VIEW_HEIGHT;

	//xSĂ̓~߂
	moveturn_mode = 0;

	//ڕWn_ւ̊px߂
	CheckTargetAngle(posx, posy2, posz, rx*-1 + (float)M_PI/2, ry, pdata.x, pdata.y, pdata.z, 0.0f, &atan_rx, &atan_ry, NULL);

	//
	if( atan_rx > 0.0f ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}
	if( atan_rx < 0.0f ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( atan_ry > 0.0f ){
		SetFlag(moveturn_mode, AI_CTRL_TURNUP);
	}
	if( atan_ry < 0.0f ){
		SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
	}

	//
	if( (fabs(atan_rx) < DegreeToRadian(1.5f))&&(fabs(atan_ry) < DegreeToRadian(1.5f)) ){
		//pxݒ
		ctrlhuman->SetRxRy(rx, ry);

		if( ObjMgr->ShotWeapon(ctrlid) != 0 ){
			return 1;
		}
	}

	return 0;
}

//! @brief r̊pxݒ
void AIcontrol::ArmAngle()
{
	DelFlag(moveturn_mode, AI_CTRL_TURNUP);
	DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);

	if( ctrlhuman->GetMainWeaponTypeNO() == ID_WEAPON_NONE ){	//Ԃ
		//Ɍ
		SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
	}
	else if( (battlemode == AI_CAUTION)&&(cautioncnt > 0) ){	//x
		float addry2 = 0.0f - ry;

		//
		if( addry2 > DegreeToRadian(1.0f) ){
			SetFlag(moveturn_mode, AI_CTRL_TURNUP);
		}
		if( addry2 < DegreeToRadian(-1.0f) ){
			SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
		}
	}
	else{									//펞ŕ폊L
		//
		if( ry < DegreeToRadian(-32) ){
			SetFlag(moveturn_mode, AI_CTRL_TURNUP);
		}
		if( ry > DegreeToRadian(-28) ){
			SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
		}
	}
}

//! @brief GT
int AIcontrol::SearchEnemy()
{
	//퓬tOLȂGȂ
	if( NoFight == true ){
		return 0;
	}

	if( battlemode == AI_ACTION ){ return 0; }

	int weaponid = ctrlhuman->GetMainWeaponTypeNO();
	int weaponscope = 0;
	int searchloops;
	float maxDist;
	float A_rx, A_ry, B_rx, B_ry;

	//Ă΁AXR[v[h擾
	if( weaponid != ID_WEAPON_NONE ){
		WeaponParameter Wparam;

		Param->GetWeapon(weaponid, &Wparam);
		weaponscope = Wparam.scopemode;
	}

	//G̒T񐔂ƒT͈́iƊpxjݒ
	if( battlemode == AI_NORMAL ){
		searchloops = (LevelParam->search) * AI_TOTALHUMAN_SCALE;

		if( weaponscope == 2 ){ maxDist = 50.0f; }
		if( weaponscope == 1 ){ maxDist = 25.0f; }
		else{ maxDist = 0.0f; }
		maxDist += 12.0f*((LevelParam->search)-2) + 350.0f;
		A_rx = DegreeToRadian(60);
		A_ry = DegreeToRadian(110);
		B_rx = DegreeToRadian(40);
		B_ry = DegreeToRadian(60);
	}
	else {	//battlemode == AI_CAUTION
		searchloops = (LevelParam->search) * AI_TOTALHUMAN_SCALE + 4;

		if( weaponscope == 2 ){ maxDist = 80.0f; }
		if( weaponscope == 1 ){ maxDist = 40.0f; }
		else{ maxDist = 0.0f; }
		maxDist += 15.0f*((LevelParam->search)-2) + 420.0f;
		A_rx = DegreeToRadian(80);
		A_ry = DegreeToRadian(130);
		B_rx = DegreeToRadian(50);
		B_ry = DegreeToRadian(80);
	}

	//w񐔁AGT
	for(int i=0; i<searchloops; i++){
		int targetid = GetRand(MAX_HUMAN);

		if( CheckLookEnemy(targetid, A_rx, A_ry, 200.0f, NULL) == true ){
			longattack = false;
			return 1;
		}

		if( CheckLookEnemy(targetid, B_rx, B_ry, maxDist, NULL) == true ){
			if( GetRand(4) == 0 ){
				if( movemode == AI_RUN2 ){ longattack = false; }
				else{ longattack = true; }
				return 2;
			}
		}
	}
	return 0;
}

//! @brief GTiUɋߋTj
int AIcontrol::SearchShortEnemy()
{
	float A_rx, A_ry;
	A_rx = DegreeToRadian(100);
	A_ry = DegreeToRadian(52);

	for(int i=0; i<3; i++){
		int targetid = GetRand(MAX_HUMAN);

		if( CheckLookEnemy(targetid, A_rx, A_ry, 200.0f, NULL) == true ){
			longattack = false;
			return 1;
		}
	}
	return 0;
}

//! @brief G邩
bool AIcontrol::CheckLookEnemy(int id, float search_rx, float search_ry, float maxDist, float *out_minDist)
{
	if( ObjMgr == NULL ){ return false; }

	//l̃IuWFNg擾
	class human* thuman;
	thuman = ObjMgr->GeHumanObject(id);
	if( thuman == NULL ){ return false; }

	//֐I[o[[h
	return CheckLookEnemy(thuman, search_rx, search_ry, maxDist, out_minDist);
}

//! @brief G邩
bool AIcontrol::CheckLookEnemy(class human* thuman, float search_rx, float search_ry, float maxDist, float *out_minDist)
{
	//return false;

	//ȃf[^ȂI
	if( ctrlhuman == NULL ){ return false; }
	if( thuman == NULL ){ return false; }
	if( thuman->GetEnableFlag() == false ){ return false; }
	if( thuman->GetDeadFlag() == true ){ return false; }

	//ƓG̍W擾
	int ctrlteam, targetteam;
	float tx, ty, tz;
	ctrlhuman->GetParamData(NULL, NULL, NULL, &ctrlteam);
	thuman->GetParamData(NULL, NULL, NULL, &targetteam);
	thuman->GetPosData(&tx, &ty, &tz, NULL);

	//ƓGlłȂ
	if( ctrlteam != targetteam ){
		float mrx, mry;
		float Dist2 , Dist;
		float Dist_dummy; 

		//𔻒肵Apx擾
		if( CheckTargetAngle(posx, posy, posz, rx*-1 + (float)M_PI/2, 0.0f, tx, ty, tz, maxDist, &mrx, &mry, &Dist2) == true ){
			//pxAEɓĂ
			if( (fabs(mrx) < search_rx/2)&&(fabs(mry) < search_ry/2) ){
				float vx, vy, vz;

				Dist = sqrt(Dist2);

				//xNg擾
				vx = (tx - posx)/Dist;
				vy = (ty - posy)/Dist;
				vz = (tz - posz)/Dist;

				//ubNՂĂȂ΁@iCœ蔻sAĂȂ΁j
				if( CollD->CheckALLBlockIntersectRay(posx, posy + VIEW_HEIGHT, posz, vx, vy, vz, NULL, NULL, &Dist_dummy, Dist) == false ){
					if( out_minDist != NULL ){ *out_minDist = Dist; }
					enemyhuman = thuman;
					return true;
				}
			}
		}
	}
	return false;
}

//! @brief ̂邩mF
bool AIcontrol::CheckCorpse(int id)
{
	//NXݒ肪ΏȂ
	if( ObjMgr == NULL ){ return false; }
	if( ctrlhuman == NULL ){ return false; }

	//^[Qbg̃NX擾
	class human* thuman;
	thuman = ObjMgr->GeHumanObject(id);
	if( thuman == NULL ){ return false; }
	if( thuman->GetEnableFlag() == false ){ return false; }

	//SĂ
	if( thuman->GetDeadFlag() == true ){

		//`[ԍ擾
		int ctrlteam, targetteam;
		ctrlhuman->GetParamData(NULL, NULL, NULL, &ctrlteam);
		thuman->GetParamData(NULL, NULL, NULL, &targetteam);

		//Ȃ
		if( ctrlteam == targetteam ){
			float tposx, tposy, tposz;
			float atan;

			//W狗擾
			thuman->GetPosData(&tposx, &tposy, &tposz, NULL);

			//ƊpxvZ
			if( CheckTargetAngle(posx, posy, posz, rx*-1 + (float)M_PI/2, 0.0f, tposx, tposy, tposz, 22.0f, &atan, NULL, NULL) == true ){
				if( fabs(atan) < DegreeToRadian(40) ){
					return true;
				}
			}
		}
	}
	return false;
}

//! @brief pXɂړ
void AIcontrol::MovePath()
{
	if( movemode == AI_NULL ){			//ُȃpX
		//
	}
	else if( movemode == AI_GRENADE ){	//֒epX
		if( ThrowGrenade() != 0 ){
			SearchTarget(true);
		}
	}
	else{								//̑pX
		if( CheckTargetPos() == false ){
			MoveTarget();
		}
		else if( (movemode == AI_WAIT)||(movemode == AI_TRACKING) ){
			TurnSeen();
		}
		else if( (movemode == AI_STOP)&&(waitcnt < ((int)GAMEFPS)*5) ){
			if( StopSeen() == true ){
				waitcnt += 1;
			}
		}
		else{
			waitcnt = 0;
			SearchTarget(true);
		}
	}
}

//! @brief UC
//! @return sρFfalse@ύXFtrue
bool AIcontrol::ActionMain()
{
	int newbattlemode = AI_ACTION;

	//U
	Action();

	if( movemode == AI_RUN2 ){				//DIȑ
		//ڕWn_ֈړ
		if( CheckTargetPos() == true ){
			newbattlemode = AI_NORMAL;
			SearchTarget(true);
		}
		else{
			MoveTarget2();
		}
	}
	else{									//DIȑ ȊO
		//UȂA߂̓GT
		if( longattack == true ){
			SearchShortEnemy();
		}
	}

	//UI
	if( ActionCancel() == true ){
		enemyhuman = NULL;

		if( movemode == AI_RUN2 ){
			newbattlemode = AI_NORMAL;
		}
		else{
			newbattlemode = AI_CAUTION;
			cautioncnt = 160;
		}
	}

	//ݒ𔻒
	if( battlemode != newbattlemode ){
		battlemode = newbattlemode;
		return true;
	}
	return false;
}

//! @brief xC
//! @return sρFfalse@ύXFtrue
bool AIcontrol::CautionMain()
{
	int newbattlemode = AI_CAUTION;

	//Wƃ`[ԍ擾
	int teamid;
	ctrlhuman->GetParamData(NULL, NULL, NULL, &teamid);

	//eƉ̏󋵂擾
	bool HitFlag = ctrlhuman->CheckHit();
	soundlist soundlist[MAX_SOUNDMGR_LIST];
	int soundlists = GameSound->GetWorldSound(posx, posy + VIEW_HEIGHT, posz, teamid, soundlist);

	//퓬tOLȂA͕ȂƂɂ
	if( NoFight == true ){
		soundlists = 0;
	}

	//]Ƙr̊px
	TurnSeen();
	ArmAngle();

	//C
	if( enemyhuman != NULL ){		//ɓGĂ
		newbattlemode = AI_ACTION;
		actioncnt = 0;
	}
	else if( SearchEnemy() != 0 ){		//G
		newbattlemode = AI_ACTION;
		actioncnt = 0;
	}
	else if( (HitFlag == true)||(soundlists > 0) ){	//e
		cautioncnt = 160;			//xĊJ
	}
	else if( cautioncnt == 0 ){		//xIȂ
		if( CheckTargetPos() == false ){				//xJnn_藣Ă邩
			MoveTarget();				//xJnn_ɋ߂Â
		}
		else{
			newbattlemode = AI_NORMAL;

			//x҂pXȂ玟֐i߂
			pointdata pdata;
			Points->Getdata(&pdata, target_pointid);
			if( (pdata.p1 == 3)&&(pdata.p2 == 4) ){
				SearchTarget(true);
			}
		}
	}
	else if( cautioncnt < 100 ){	//100t[؂A_ɌxIiJEgF0Ɂj
		if( GetRand(50) == 0 ){ cautioncnt = 0; }
	}
	else{ cautioncnt -= 1; }

	//ǔőΏۂ痣ꂷA_ɌxI
	if( (movemode == AI_TRACKING)&&(GetRand(3) == 0) ){
		pointdata pdata;
		float x, z;
		float tx, tz;
		Points->Getdata(&pdata, target_pointid);
		SearchHumanPos(pdata.p4, &tx, &tz);
		x = posx - tx;
		z = posz - tz;
		if( (x*x + z*z) > 25.0f*25.0f ){
			cautioncnt = 0;
		}
	}

	//ݒ𔻒
	if( battlemode != newbattlemode ){
		battlemode = newbattlemode;
		return true;
	}
	return false;
}

//! @brief ʏ탁C
//! @return sρFfalse@ύXFtrue
bool AIcontrol::NormalMain()
{
	int newbattlemode = AI_NORMAL;

	if( hold == false ){
		SearchTarget(false);
	}
	enemyhuman = NULL;

	//Wƃ`[ԍ擾
	int teamid;
	ctrlhuman->GetParamData(NULL, NULL, NULL, &teamid);

	//eƉ̏󋵂擾
	bool HitFlag = ctrlhuman->CheckHit();
	soundlist soundlist[MAX_SOUNDMGR_LIST];
	int soundlists = GameSound->GetWorldSound(posx, posy + VIEW_HEIGHT, posz, teamid, soundlist);

	//퓬tOLȂA͕ȂƂɂ
	if( NoFight == true ){
		soundlists = 0;
	}

	//_pXȂ珈s
	if( movemode == AI_RANDOM ){
		SearchTarget(true);
	}

	if( movemode == AI_RUN2 ){		//DIȑ̏
		//GUɓ
		if( SearchEnemy() != 0 ){
			newbattlemode = AI_ACTION;
		}
		else{
			MovePath();		//ړs
		}
	}
	else{							//DIȑȊȌ
		//xɓ鏈
		if(
			(SearchEnemy() != 0)||							//G
			(HitFlag == true)||(soundlists > 0)||	//e
			(CheckCorpse( GetRand(MAX_HUMAN) ) == true)	//̂
		){
			newbattlemode = AI_CAUTION;
			cautioncnt = 160;
			target_posx = posx;
			target_posz = posz;
		}
		else{
			MovePath();		//ړs
		}
	}

	//r̊pxݒ
	if( movemode != AI_GRENADE ){
		ArmAngle();
	}

	//ݒ𔻒
	if( battlemode != newbattlemode ){
		battlemode = newbattlemode;
		return true;
	}
	return false;
}

//! @brief n֐
void AIcontrol::Init()
{
	//NXݒ肪ΏȂ
	if( ctrlhuman == NULL ){ return; }
	if( blocks == NULL ){ return; }
	if( Points == NULL ){ return; }
	if( CollD == NULL ){ return; }

	//gpĂȂlȂ珈Ȃ
	if( ctrlhuman->GetEnableFlag() == false ){ return; }

	//Xe[g
	hold = false;
	NoFight = false;
	battlemode = AI_NORMAL;
	movemode = AI_NULL;
	enemyhuman = NULL;
	addrx = 0.0f;
	addry = 0.0f;
	waitcnt = 0;
	gotocnt = 0;
	moveturn_mode = 0x00;
	cautioncnt = 0;
	actioncnt = 0;
	longattack = false;

	//AIxƐݒl擾
	int paramid;
	HumanParameter paramdata;
	//target_pointid = in_target_pointid;
	ctrlhuman->GetParamData(&paramid, &target_pointid, NULL, NULL);
	Param->GetHuman(paramid, &paramdata);
	AIlevel = paramdata.AIlevel;
	Param->GetAIlevel(AIlevel, &LevelParam);

	//̃|Cg
	SearchTarget(true);
}

//! @brief w肵ꏊ֑ҋ@
//! @param px XW
//! @param pz ZW
//! @param rx d
//! @attention ړpXɊւ炸Aw肵Wւ̑ҋ@܂BInit()֐ēxs܂Ōɖ߂܂B
void AIcontrol::SetHoldWait(float px, float pz, float rx)
{
	movemode = AI_WAIT;
	hold = true;
	target_posx = px;
	target_posz = pz;
	target_rx = rx;
}

//! @brief w肵lǔ
//! @param id l̃f[^ԍ
//! @attention ړpXɊւ炸Aw肵lւ̒ǔ܂BInit()֐ēxs܂Ōɖ߂܂B
void AIcontrol::SetHoldTracking(int id)
{
	movemode = AI_TRACKING;
	hold = false;
	target_pointid = id;
}

//! @brief IɌx
//! @warning DIȑ s̏ꍇÅ֐͉܂B
void AIcontrol::SetCautionMode()
{
	//DIȑȂΉȂ
	if( movemode == AI_RUN2 ){ return; }

	if( battlemode == AI_NORMAL ){
		target_posx = posx;
		target_posz = posz;
	}
	battlemode = AI_CAUTION;
	cautioncnt = 160;
}

//! @brief 퓬tOݒ
//! @param flag trueF퓬sȂi퓬j@falseF퓬siʏj
//! @attention tOLɂƓGFȂȂ܂B
void AIcontrol::SetNoFightFlag(bool flag)
{
	NoFight = flag;
}

//! @brief n֐
void AIcontrol::Process()
{
	//NXݒ肪ΏȂ
	if( ctrlhuman == NULL ){ return; }
	if( blocks == NULL ){ return; }
	if( Points == NULL ){ return; }
	if( CollD == NULL ){ return; }

	//ȐlNXȂ珈Ȃ
	if( ctrlhuman->GetEnableFlag() == false ){ return; }

	//S
	if( ctrlhuman->GetHP() <= 0 ){
		battlemode = AI_DEAD;
		movemode = AI_DEAD;
		return;
	}

	//HP0łȂ̂ SƂɂȂĂ@EEEԂH
	if( battlemode == AI_DEAD ){
		battlemode = AI_NORMAL;
		SearchTarget(false);
	}

	//WƊpx擾
	ctrlhuman->GetPosData(&posx, &posy, &posz, NULL);
	ctrlhuman->GetRxRy(&rx, &ry);

	//_ɓ~߂
	CancelMoveTurn();

	//UxȂ
	if( (battlemode == AI_ACTION)||(battlemode == AI_CAUTION) ){
		//
		HaveWeapon();
	}

	//vZs
	if( battlemode == AI_ACTION ){			//U
		ActionMain();
	}
	else if( battlemode == AI_CAUTION ){	//x
		CautionMain();
	}
	else{									//펞
		NormalMain();
	}

	//ړE]
	ControlMoveTurn();

	//舵
	ControlWeapon();

	//pxKp
	ctrlhuman->SetRxRy(rx, ry);
}