//! @file config.cpp
//! @brief configNX̒` 

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2016, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "config.h"

//! @brief RXgN^
Config::Config()
{
	//e탁o[ϐ
	for(int i=0; i<TOTAL_ControlKey; i++){
		Keycode[i] = 0;
	}
	MouseSensitivity = 0;
	FullscreenFlag = false;
	SoundFlag = false;
	BloodFlag = false;
	Brightness = 0;
	InvertMouseFlag = false;
	FrameskipFlag = false;
	AnotherGunsightFlag = false;
	strcpy(PlayerName, "");
}

//! @brief fBXgN^
Config::~Config()
{}

//! @brief ݒt@Cǂݍ
//! @param fname t@C
//! @return F0@sF1
int Config::LoadFile(char *fname)
{
	FILE *fp;
	char buf;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "ݒt@C", fname);
#endif

#ifdef PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

	//t@CJ
	fp = fopen(fname, "rb");
	if( fp == NULL ){
		return 1;
	}

	//L[R[h擾
	for(int i=0; i<TOTAL_ControlKey; i++){
		fread(&buf, 1, 1, fp);
		Keycode[i] = buf;
	}

	//}EXx
	fread(&buf, 1, 1, fp);
	MouseSensitivity = buf;

	//tXN[L
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ FullscreenFlag = false; }
	else{ FullscreenFlag = true; }

	//ʉL
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ SoundFlag = false; }
	else{ SoundFlag = true; }

	//oL
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ BloodFlag = false; }
	else{ BloodFlag = true; }

	//ʂ̖邳
	fread(&buf, 1, 1, fp);
	Brightness = buf;

	//}EX]
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ InvertMouseFlag = false; }
	else{ InvertMouseFlag = true; }

	//t[XLbv
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ FrameskipFlag = false; }
	else{ FrameskipFlag = true; }

	//ʂ̏Əgp
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ AnotherGunsightFlag = false; }
	else{ AnotherGunsightFlag = true; }

	//vC[
	fread(PlayerName, 1, MAX_PLAYERNAME, fp);

	//t@Cnh
	fclose(fp);

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif
	return 0;
}

//! @brief IWiL[R[h擾
//! @param id 萔
//! @return IWiL[R[h
int Config::GetKeycode(int id)
{
	if( (id < 0)||((TOTAL_ControlKey -1) < id) ){ return 0; }

	return Keycode[id];
}

//! @brief }EXx擾
//! @return ̒l
int Config::GetMouseSensitivity()
{
	return MouseSensitivity;
}

//! @brief ʕ\[h擾
//! @return EBhEFfalse@tXN[Ftrue
bool Config::GetFullscreenFlag()
{
	return FullscreenFlag;
}

//! @brief ʉݒ擾
//! @return Ffalse@LFtrue
bool Config::GetSoundFlag()
{
	return SoundFlag;
}

//! @brief oݒ擾
//! @return Ffalse@LFtrue
bool Config::GetBloodFlag()
{
	return BloodFlag;
}

//! @brief ʂ̖邳ݒ擾
//! @return ̒l
int Config::GetBrightness()
{
	return Brightness;
}

//! @brief }EX]ݒ擾
//! @return Ffalse@LFtrue
bool Config::GetInvertMouseFlag()
{
	return InvertMouseFlag;
}

//! @brief t[XLbvݒ擾
//! @return Ffalse@LFtrue
bool Config::GetFrameskipFlag()
{
	return FrameskipFlag;
}

//! @brief ʂ̏Əgpݒ擾
//! @return Ffalse@LFtrue
bool Config::GetAnotherGunsightFlag()
{
	return AnotherGunsightFlag;
}

//! @brief vC[擾
//! @param out_str 󂯎镶^|C^
//! @return vC[
int Config::GetPlayerName(char *out_str)
{
	if( out_str == NULL ){ return 0; }

	//|C^ɃRs[
	strcpy(out_str, PlayerName);

	//Ԃ
	return strlen(PlayerName);
}
