#ifndef SSD1322_H_INCLUDE
#define SSD1322_H_INCLUDE
#define	SSD_G4ON		0x00	/* Enable Glay Scale Table */
#define	SSD_CASET		0x15	// Set Column Start End Address (CASET) 2
#define	SSD_RAMWR		0x5C	// Memory Write (RAMWR) Any length
#define	SSD_RAMRD		0x5D	// Memory Read (RAMRD) Any length
#define	SSD_RASET		0x75	// Set Row Start End Address (RASET) 2
#define	SSD_MAPSET	0xA0	// Set Re-map and Dual COM Line mode 2
#define	SSD_SLSET		0xA1	// Set Display Start Line 1
#define	SSD_OFSET		0xA2	// Set Display Offset 1
#define	SSD_DMEOFF	0xA4	// Set Display Mode (Entire Display OFF, all pixels turns OFF in GS level 0)
#define	SSD_DMEON		0xA5	// Set Display Mode (Entire Display ON, all pixels turns ON in GS level 15)
#define	SSD_DMNORM	0xA6	// Set Display Mode (Normal Display)
#define	SSD_DMINVRT	0xA7	// Set Display Mode (Inverse Display (GS0 -> GS15, GS1 -> GS14, GS2 -> GS13, c))
#define	SSD_PARTON	0xA8	// Enable Partial Display 2
#define	SSD_PARTOFF	0xA9	// Exit Partial Display 0
#define	SSD_FUNCSEL	0xAB	// Function Selection 1
#define	SSD_DSPON		0xAE	// Sleep mode ON (Display OFF)
#define	SSD_DSPOFF	0xAF	// Sleep mode OFF (Display ON)
#define	SSD_PLSET		0xB1	// Set Phase Length 1
#define	SSD_CLKSET	0xB3	// Set Front Clock Divider / Oscillator Frequency
#define	SSD_DEASET	0xB4	// Display Enhancement A 2
#define	SSD_GPIOSET	0xB5	// Set GPIO 1
#define	SSD_SPPSET	0xB6	// Set Second Precharge Period 1
#define	SSD_G4TBSET	0xB8	// Set Gray Scale Table 15
#define	SSD_G4TBRESET	0xB9	// Select Default Linear Gray Scale table 0
#define	SSD_PCVSET	0xBB	// Set Pre-charge voltage 1
#define	SSD_VCOMSET	0xBE	// Set VCOMH 1
#define	SSD_CONTSET	0xC1	// Set Contrast Current 1
#define	SSD_MCONSET	0xC7	// Master Contrast Current Control
#define	SSD_MUXSET	0xCA	// Set MUX Ratio
#define	SSD_DEBSET	0xD1	// Display Enhancement B 2
#define	SSD_COMLCK	0xFD	// Command Lock (COMLCK) 1

void ssd_sendcmd(char c);

#endif // SSD1322_H_INCLUDE
