/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.SessionInterface;
import org.h2.message.Message;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class UpdatableRow {
    private SessionInterface session;
    private Connection conn;
    private DatabaseMetaData meta;
    private ResultInterface result;
    private int columnCount;
    private String schemaName;
    private String tableName;
    private ObjectArray key;
    private boolean isUpdatable;

    public UpdatableRow(Connection conn, ResultInterface result, SessionInterface session) throws SQLException {
        this.conn = conn;
        this.meta = conn.getMetaData();
        this.result = result;
        this.session = session;
        this.columnCount = result.getVisibleColumnCount();
        for (int i = 0; i < this.columnCount; ++i) {
            String t = result.getTableName(i);
            String s = result.getSchemaName(i);
            if (t == null || s == null) {
                return;
            }
            if (this.tableName == null) {
                this.tableName = t;
            } else if (!this.tableName.equals(t)) {
                return;
            }
            if (this.schemaName == null) {
                this.schemaName = s;
                continue;
            }
            if (this.schemaName.equals(s)) continue;
            return;
        }
        ResultSet rs = this.meta.getTables(null, this.schemaName, this.tableName, new String[]{"TABLE"});
        if (!rs.next()) {
            return;
        }
        if (rs.getString("SQL") == null) {
            return;
        }
        this.key = new ObjectArray();
        rs = this.meta.getPrimaryKeys(null, this.schemaName, this.tableName);
        while (rs.next()) {
            this.key.add(rs.getString("COLUMN_NAME"));
        }
        if (this.key.size() == 0) {
            return;
        }
        this.isUpdatable = true;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    private int getColumnIndex(String columnName) throws SQLException {
        for (int i = 0; i < this.columnCount; ++i) {
            String col = this.result.getColumnName(i);
            if (!col.equals(columnName)) continue;
            return i;
        }
        throw Message.getSQLException(42122, columnName);
    }

    private void appendColumnList(StringBuffer buff, boolean set) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (i > 0) {
                buff.append(',');
            }
            String col = this.result.getColumnName(i);
            buff.append(StringUtils.quoteIdentifier(col));
            if (!set) continue;
            buff.append("=? ");
        }
    }

    private void appendKeyCondition(StringBuffer buff) {
        buff.append(" WHERE ");
        for (int i = 0; i < this.key.size(); ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            buff.append(StringUtils.quoteIdentifier((String)this.key.get(i)));
            buff.append("=?");
        }
    }

    private void setKey(PreparedStatement prep, int start, Value[] current) throws SQLException {
        for (int i = 0; i < this.key.size(); ++i) {
            String col = (String)this.key.get(i);
            int idx = this.getColumnIndex(col);
            Value v = current[idx];
            if (v == null || v == ValueNull.INSTANCE) {
                throw Message.getSQLException(2000);
            }
            v.set(prep, start + i);
        }
    }

    public void refreshRow(Value[] row) throws SQLException {
        Value[] newRow = this.readRow(row);
        for (int i = 0; i < this.columnCount; ++i) {
            row[i] = newRow[i];
        }
    }

    private void appendTableName(StringBuffer buff) {
        if (this.schemaName != null && this.schemaName.length() > 0) {
            buff.append(StringUtils.quoteIdentifier(this.schemaName));
            buff.append('.');
        }
        buff.append(StringUtils.quoteIdentifier(this.tableName));
    }

    private Value[] readRow(Value[] row) throws SQLException {
        StringBuffer buff = new StringBuffer();
        buff.append("SELECT ");
        this.appendColumnList(buff, false);
        buff.append(" FROM ");
        this.appendTableName(buff);
        this.appendKeyCondition(buff);
        PreparedStatement prep = this.conn.prepareStatement(buff.toString());
        this.setKey(prep, 1, row);
        ResultSet rs = prep.executeQuery();
        if (!rs.next()) {
            throw Message.getSQLException(2000);
        }
        Value[] newRow = new Value[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.result.getColumnType(i);
            newRow[i] = DataType.readValue(this.session, rs, i + 1, type);
        }
        return newRow;
    }

    public void deleteRow(Value[] current) throws SQLException {
        StringBuffer buff = new StringBuffer();
        buff.append("DELETE FROM ");
        this.appendTableName(buff);
        this.appendKeyCondition(buff);
        PreparedStatement prep = this.conn.prepareStatement(buff.toString());
        this.setKey(prep, 1, current);
        int count = prep.executeUpdate();
        if (count != 1) {
            throw Message.getSQLException(2000);
        }
    }

    public void updateRow(Value[] current, Value[] updateRow) throws SQLException {
        StringBuffer buff = new StringBuffer();
        buff.append("UPDATE ");
        this.appendTableName(buff);
        buff.append(" SET ");
        this.appendColumnList(buff, true);
        this.appendKeyCondition(buff);
        PreparedStatement prep = this.conn.prepareStatement(buff.toString());
        int j = 1;
        for (int i = 0; i < this.columnCount; ++i) {
            Value v = updateRow[i];
            if (v == null) {
                v = current[i];
            }
            v.set(prep, j++);
        }
        this.setKey(prep, j, current);
        int count = prep.executeUpdate();
        if (count != 1) {
            throw Message.getSQLException(2000);
        }
    }

    public void insertRow(Value[] row) throws SQLException {
        StringBuffer buff = new StringBuffer();
        buff.append("INSERT INTO ");
        this.appendTableName(buff);
        buff.append('(');
        this.appendColumnList(buff, false);
        buff.append(")VALUES(");
        for (int i = 0; i < this.columnCount; ++i) {
            if (i > 0) {
                buff.append(',');
            }
            buff.append('?');
        }
        buff.append(')');
        PreparedStatement prep = this.conn.prepareStatement(buff.toString());
        for (int i = 0; i < this.columnCount; ++i) {
            Value v = row[i];
            if (v == null) {
                v = ValueNull.INSTANCE;
            }
            v.set(prep, i + 1);
        }
        int count = prep.executeUpdate();
        if (count != 1) {
            throw Message.getSQLException(2000);
        }
    }
}

