/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.EntityMetaFactory;
import org.seasar.extension.jdbc.JoinColumnMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.TableMeta;
import org.seasar.extension.jdbc.annotation.ReferentialConstraint;
import org.seasar.extension.jdbc.gen.desc.ForeignKeyDesc;
import org.seasar.extension.jdbc.gen.desc.ForeignKeyDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.util.AnnotationUtil;

public class ForeignKeyDescFactoryImpl
implements ForeignKeyDescFactory {
    protected GenDialect dialect;
    protected EntityMetaFactory entityMetaFactory;
    protected boolean regardRelationshipAsFk;

    public ForeignKeyDescFactoryImpl(GenDialect dialect, EntityMetaFactory entityMetaFactory, boolean regardRelationshipAsFk) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (entityMetaFactory == null) {
            throw new NullPointerException("entityMetaFactory");
        }
        this.dialect = dialect;
        this.entityMetaFactory = entityMetaFactory;
        this.regardRelationshipAsFk = regardRelationshipAsFk;
    }

    public ForeignKeyDesc getForeignKeyDesc(EntityMeta entityMeta, PropertyMeta propertyMeta) {
        if (!propertyMeta.isRelationship() || propertyMeta.getMappedBy() != null) {
            return null;
        }
        ReferentialConstraint referentialConstraint = propertyMeta.getField().getAnnotation(ReferentialConstraint.class);
        if (referentialConstraint == null ? !this.regardRelationshipAsFk : !referentialConstraint.enable()) {
            return null;
        }
        ForeignKeyDesc foreignKeyDesc = new ForeignKeyDesc();
        this.doColumn(entityMeta, propertyMeta, foreignKeyDesc);
        this.doTable(entityMeta, propertyMeta, foreignKeyDesc);
        this.doReferetialAction(entityMeta, propertyMeta, foreignKeyDesc);
        return foreignKeyDesc;
    }

    protected void doColumn(EntityMeta entityMeta, PropertyMeta propertyMeta, ForeignKeyDesc foreignKeyDesc) {
        for (JoinColumnMeta jcm : propertyMeta.getJoinColumnMetaList()) {
            foreignKeyDesc.addColumnName(jcm.getName());
            foreignKeyDesc.addReferencedColumnName(jcm.getReferencedColumnName());
        }
    }

    protected void doTable(EntityMeta entityMeta, PropertyMeta propertyMeta, ForeignKeyDesc foreignKeyDesc) {
        EntityMeta inverseEntityMeta = this.entityMetaFactory.getEntityMeta(propertyMeta.getRelationshipClass());
        TableMeta tableMeta = inverseEntityMeta.getTableMeta();
        foreignKeyDesc.setReferencedCatalogName(tableMeta.getCatalog());
        foreignKeyDesc.setReferencedSchemaName(tableMeta.getSchema());
        foreignKeyDesc.setReferencedTableName(tableMeta.getName());
        foreignKeyDesc.setReferencedFullTableName(tableMeta.getFullName());
    }

    protected void doReferetialAction(EntityMeta entityMeta, PropertyMeta propertyMeta, ForeignKeyDesc foreignKeyDesc) {
        ReferentialConstraint referentialConstraint = this.getReferentialConstraint(propertyMeta);
        if (this.dialect.supportsReferentialDeleteRule()) {
            foreignKeyDesc.setOnDelete(referentialConstraint.onDelete());
        }
        if (this.dialect.supportsReferentialUpdateRule()) {
            foreignKeyDesc.setOnUpdate(referentialConstraint.onUpdate());
        }
    }

    protected ReferentialConstraint getReferentialConstraint(PropertyMeta propertyMeta) {
        ReferentialConstraint referentialConstraint = propertyMeta.getField().getAnnotation(ReferentialConstraint.class);
        return referentialConstraint != null ? referentialConstraint : AnnotationUtil.getDefaultReferentialConstraint();
    }
}

