/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import java.lang.reflect.Field;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.desc.ColumnDesc;
import org.seasar.extension.jdbc.gen.desc.IdTableDescFactory;
import org.seasar.extension.jdbc.gen.desc.PrimaryKeyDesc;
import org.seasar.extension.jdbc.gen.desc.TableDesc;
import org.seasar.extension.jdbc.gen.desc.UniqueKeyDesc;
import org.seasar.extension.jdbc.gen.desc.UniqueKeyDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.util.AnnotationUtil;
import org.seasar.extension.jdbc.gen.internal.util.TableUtil;
import org.seasar.extension.jdbc.gen.sqltype.SqlType;
import org.seasar.framework.util.StringUtil;

public class IdTableDescFactoryImpl
implements IdTableDescFactory {
    protected GenDialect dialect;
    protected UniqueKeyDescFactory uniqueKeyDescFactory;

    public IdTableDescFactoryImpl(GenDialect dialect, UniqueKeyDescFactory uniqueKeyDescFactory) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (uniqueKeyDescFactory == null) {
            throw new NullPointerException("uniqueKeyDescFactory");
        }
        this.dialect = dialect;
        this.uniqueKeyDescFactory = uniqueKeyDescFactory;
    }

    public TableDesc getTableDesc(EntityMeta entityMeta, PropertyMeta propertyMeta) {
        GenerationType generationType = propertyMeta.getGenerationType();
        if (generationType == GenerationType.AUTO) {
            generationType = this.dialect.getDefaultGenerationType();
        }
        if (generationType == GenerationType.TABLE) {
            TableGenerator generator = this.getTableGenerator(entityMeta, propertyMeta);
            TableDesc tableDesc = new TableDesc();
            this.doName(entityMeta, tableDesc, generator);
            this.doPrimaryKeyColumn(entityMeta, tableDesc, generator);
            this.doValueColumn(entityMeta, tableDesc, generator);
            this.doUniqueConstraints(entityMeta, tableDesc, generator);
            return tableDesc;
        }
        return null;
    }

    protected void doName(EntityMeta entityMeta, TableDesc tableDesc, TableGenerator generator) {
        String name;
        String schema;
        String catalog = generator.catalog();
        if (StringUtil.isEmpty((String)catalog)) {
            catalog = entityMeta.getTableMeta().getCatalog();
        }
        if (StringUtil.isEmpty((String)(schema = generator.schema()))) {
            schema = entityMeta.getTableMeta().getSchema();
        }
        if (StringUtil.isEmpty((String)(name = generator.table()))) {
            name = "ID_GENERATOR";
        }
        tableDesc.setCatalogName(catalog);
        tableDesc.setSchemaName(schema);
        tableDesc.setName(name);
        tableDesc.setCanonicalName(this.buildCanonicalName(catalog, schema, name));
    }

    protected String buildCanonicalName(String catalog, String schema, String name) {
        return TableUtil.buildCanonicalTableName(this.dialect, catalog, schema, name);
    }

    protected void doPrimaryKeyColumn(EntityMeta entityMeta, TableDesc tableDesc, TableGenerator generator) {
        String pkColumnName = generator.pkColumnName();
        if (StringUtil.isEmpty((String)pkColumnName)) {
            pkColumnName = "PK";
        }
        PrimaryKeyDesc primaryKeyDesc = new PrimaryKeyDesc();
        primaryKeyDesc.addColumnName(pkColumnName);
        tableDesc.setPrimaryKeyDesc(primaryKeyDesc);
        ColumnDesc columnDesc = new ColumnDesc();
        columnDesc.setName(pkColumnName);
        SqlType sqlType = this.dialect.getSqlType(12);
        columnDesc.setSqlType(sqlType);
        Column column = AnnotationUtil.getDefaultColumn();
        columnDesc.setDefinition(sqlType.getDataType(column.length(), 0, 0, false));
        tableDesc.addColumnDesc(columnDesc);
    }

    protected void doValueColumn(EntityMeta entityMeta, TableDesc tableDesc, TableGenerator generator) {
        String valueColumnName = generator.valueColumnName();
        if (StringUtil.isEmpty((String)valueColumnName)) {
            valueColumnName = "VALUE";
        }
        ColumnDesc columnDesc = new ColumnDesc();
        columnDesc.setName(valueColumnName);
        SqlType sqlType = this.dialect.getSqlType(-5);
        columnDesc.setSqlType(sqlType);
        Column column = AnnotationUtil.getDefaultColumn();
        columnDesc.setDefinition(sqlType.getDataType(0, column.precision(), 0, false));
        columnDesc.setNullable(false);
        tableDesc.addColumnDesc(columnDesc);
    }

    protected void doUniqueConstraints(EntityMeta entityMeta, TableDesc tableDesc, TableGenerator generator) {
        for (UniqueConstraint uc : generator.uniqueConstraints()) {
            UniqueKeyDesc uniqueKeyDesc = this.uniqueKeyDescFactory.getCompositeUniqueKeyDesc(uc);
            if (uniqueKeyDesc == null) continue;
            tableDesc.addUniqueKeyDesc(uniqueKeyDesc);
        }
    }

    protected TableGenerator getTableGenerator(EntityMeta entityMeta, PropertyMeta propertyMeta) {
        Field field = propertyMeta.getField();
        GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            throw new IllegalStateException("@GeneratedValue not found.");
        }
        String name = generatedValue.generator();
        if (StringUtil.isEmpty((String)name)) {
            return AnnotationUtil.getDefaultTableGenerator();
        }
        TableGenerator tableGenerator = field.getAnnotation(TableGenerator.class);
        if (tableGenerator != null && name.equals(tableGenerator.name())) {
            return tableGenerator;
        }
        tableGenerator = entityMeta.getEntityClass().getAnnotation(TableGenerator.class);
        if (tableGenerator != null && name.equals(tableGenerator.name())) {
            return tableGenerator;
        }
        throw new IllegalStateException("@TableGenerator not found.");
    }
}

