/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.lang.reflect.Field;
import java.util.List;
import org.seasar.extension.jdbc.AutoBatchDelete;
import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.WhereClause;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractAutoBatchUpdate;
import org.seasar.framework.util.FieldUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoBatchDeleteImpl<T>
extends AbstractAutoBatchUpdate<T, AutoBatchDelete<T>>
implements AutoBatchDelete<T> {
    protected static final String DELETE_STATEMENT = "delete from ";
    protected boolean ignoreVersion;
    protected final WhereClause whereClause = new WhereClause();

    public AutoBatchDeleteImpl(JdbcManagerImplementor jdbcManager, List<T> entities) {
        super(jdbcManager, entities);
    }

    @Override
    public AutoBatchDelete<T> ignoreVersion() {
        this.ignoreVersion = true;
        return this;
    }

    @Override
    public AutoBatchDelete<T> suppresOptimisticLockException() {
        this.suppresOptimisticLockException = true;
        return this;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareWhereClause();
        this.prepareSql();
    }

    protected void prepareWhereClause() {
        for (PropertyMeta propertyMeta : this.entityMeta.getIdPropertyMetaList()) {
            this.whereClause.addAndSql(ConditionType.EQ.getCondition(propertyMeta.getColumnMeta().getName(), null));
        }
        if (!this.ignoreVersion && this.entityMeta.hasVersionPropertyMeta()) {
            PropertyMeta propertyMeta = this.entityMeta.getVersionPropertyMeta();
            this.whereClause.addAndSql(ConditionType.EQ.getCondition(propertyMeta.getColumnMeta().getName(), null));
        }
    }

    @Override
    protected void prepareParams(T entity) {
        for (PropertyMeta propertyMeta : this.entityMeta.getIdPropertyMetaList()) {
            Object value = FieldUtil.get((Field)propertyMeta.getField(), entity);
            this.addParam(value, propertyMeta);
        }
        if (!this.ignoreVersion && this.entityMeta.hasVersionPropertyMeta()) {
            PropertyMeta propertyMeta = this.entityMeta.getVersionPropertyMeta();
            Object value = FieldUtil.get((Field)propertyMeta.getField(), entity);
            this.addParam(value, propertyMeta);
        }
    }

    @Override
    protected String toSql() {
        String tableName = this.entityMeta.getTableMeta().getFullName();
        StringBuilder buf = new StringBuilder(DELETE_STATEMENT.length() + tableName.length() + this.whereClause.getLength());
        return new String(buf.append(DELETE_STATEMENT).append(tableName).append(this.whereClause.toSql()));
    }

    @Override
    protected boolean isOptimisticLock() {
        return !this.ignoreVersion && this.entityMeta.hasVersionPropertyMeta();
    }
}

