/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.unit.impl.SimpleDataAccessor;
import org.seasar.framework.util.TransactionManagerUtil;

public class DataAccessorImpl
extends SimpleDataAccessor {
    protected TransactionManager tm;
    protected EntityManager em;

    @Binding(bindingType=BindingType.SHOULD)
    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    public void writeDb(DataSet dataSet) {
        this.flushIfNecessary();
        super.writeDb(dataSet);
    }

    public DataSet readDb(DataSet dataSet) {
        this.flushIfNecessary();
        return super.readDb(dataSet);
    }

    public DataTable readDbByTable(String table) {
        this.flushIfNecessary();
        return super.readDbByTable(table);
    }

    public DataTable readDbByTable(String table, String condition) {
        this.flushIfNecessary();
        return super.readDbByTable(table, condition);
    }

    public DataTable readDbBySql(String sql, String tableName) {
        this.flushIfNecessary();
        return super.readDbBySql(sql, tableName);
    }

    public void readXlsWriteDb(String path, boolean trimString) {
        this.flushIfNecessary();
        super.readXlsWriteDb(path, trimString);
    }

    public void readXlsReplaceDb(String path, boolean trimString) {
        this.flushIfNecessary();
        super.readXlsReplaceDb(path, trimString);
    }

    public void readXlsAllReplaceDb(String path, boolean trimString) {
        this.flushIfNecessary();
        super.readXlsAllReplaceDb(path, trimString);
    }

    public DataSet reload(DataSet dataSet) {
        this.flushIfNecessary();
        return super.reload(dataSet);
    }

    public DataTable reload(DataTable table) {
        this.flushIfNecessary();
        return super.reload(table);
    }

    public DataSet reloadOrReadDb(DataSet dataSet) {
        this.flushIfNecessary();
        return super.reloadOrReadDb(dataSet);
    }

    public void deleteDb(DataSet dataSet) {
        this.flushIfNecessary();
        super.deleteDb(dataSet);
    }

    public void deleteTable(String tableName) {
        this.flushIfNecessary();
        super.deleteTable(tableName);
    }

    protected void flushIfNecessary() {
        if (this.em != null && TransactionManagerUtil.isActive((TransactionManager)this.tm)) {
            this.em.flush();
        }
    }
}

