package net.waltzstudio.montecarlo.dao.project;

import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.List;
import net.waltzstudio.base.framework.dao.AuditDao;
import net.waltzstudio.base.framework.types.DeleteFlg;
import net.waltzstudio.montecarlo.entity.project.Project;
import net.waltzstudio.montecarlo.entity.project.ProjectName;

/**
 * プロジェクトDaoBase
 */
public abstract class ProjectDaoBase extends AuditDao<Project> implements ProjectName {

	public Project findById(Long id) {
		return select().id(id).where(eq($DELETE_FLG, DeleteFlg.NORMAL)).getSingleResult();
	}

	public List<Project> findAllOrderById() {
		return select().where(eq($DELETE_FLG, DeleteFlg.NORMAL)).orderBy(asc($ID)).getResultList();
	}

}
