package net.waltzstudio.montecarlo.entity.account;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import net.waltzstudio.base.framework.entity.AuditEntity;
import net.waltzstudio.montecarlo.types.AdminFlg;

/**
 * アカウントEntity
 */
@Entity
public class Account extends AuditEntity implements AccountName {

	/** ID */
	@Id
	@GeneratedValue
	public Long id;

	/** 名前 */
	public String name;

	/** Email */
	public String email;

	/** ログイン */
	public String login;

	/** パスワード */
	public String password;

	/** 管理者フラグ */
	@Enumerated(EnumType.STRING)
	public AdminFlg adminFlg;

}
