package net.waltzstudio.montecarlo.entity.ticket;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import net.waltzstudio.base.framework.entity.AuditEntity;
import net.waltzstudio.montecarlo.types.TicketStatus;

/**
 * チケットEntity
 */
@Entity
public class Ticket extends AuditEntity implements TicketName {

	/** ID */
	@Id
	@GeneratedValue
	public Long id;

	/** プロジェクトID */
	public Long projectId;

	/** パス */
	public String path;

	/** ステータス */
	@Enumerated(EnumType.STRING)
	public TicketStatus status;

	/** 開始日 */
	@Temporal(TemporalType.DATE)
	public Date fromDate;

	/** 終了日 */
	@Temporal(TemporalType.DATE)
	public Date toDate;

	/** タイトル */
	public String title;

	/** 内容 */
	public String description;

	/** 登録者ID */
	public Long registerId;

	/** 担当者ID */
	public Long assignedId;

	/** 更新日時 */
	@Temporal(TemporalType.TIMESTAMP)
	public Date modifyDatetime;

}
