CREATE TABLE `account` (
	`id`				BIGINT AUTO_INCREMENT	NOT NULL	COMMENT 'ID',
	`name`				VARCHAR(255)			NOT NULL	COMMENT '名前',
	`email`				VARCHAR(255)			NOT NULL	COMMENT 'Email',
	`login`				VARCHAR(255)			NOT NULL	COMMENT 'ログイン',
	`password`			VARCHAR(255)			NOT NULL	COMMENT 'パスワード',
	`admin_flg`			CHAR(1)					NOT NULL	COMMENT '管理者フラグ',
	`delete_flg`		CHAR(1)					NOT NULL	COMMENT '削除フラグ',
	`create_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：作成日時',
	`create_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：作成者ID',
	`update_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：更新日時',
	`update_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：更新者ID',
	PRIMARY KEY (`id`)
) COMMENT='アカウント' ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `project` (
	`id`				BIGINT AUTO_INCREMENT	NOT NULL	COMMENT 'ID',
	`code`				VARCHAR(255)			NOT NULL	COMMENT '識別子',
	`name`				VARCHAR(255)			NOT NULL	COMMENT '名称',
	`delete_flg`		CHAR(1)					NOT NULL	COMMENT '削除フラグ',
	`create_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：作成日時',
	`create_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：作成者ID',
	`update_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：更新日時',
	`update_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：更新者ID',
	PRIMARY KEY (`id`)
) COMMENT='プロジェクト' ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `account_project` (
	`id`				BIGINT AUTO_INCREMENT	NOT NULL	COMMENT 'ID',
	`account_id`		BIGINT					NOT NULL	COMMENT 'アカウントID',
	`project_id`		BIGINT					NOT NULL	COMMENT 'プロジェクトID',
	`delete_flg`		CHAR(1)					NOT NULL	COMMENT '削除フラグ',
	`create_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：作成日時',
	`create_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：作成者ID',
	`update_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：更新日時',
	`update_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：更新者ID',
	PRIMARY KEY (`id`)
) COMMENT='アカウント・プロジェクト紐付け' ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `ticket` (
	`id`				BIGINT AUTO_INCREMENT	NOT NULL	COMMENT 'ID',
	`project_id`		BIGINT					NOT NULL	COMMENT 'プロジェクトID',
	`path`				TEXT					NOT NULL	COMMENT 'パス',
	`status`			VARCHAR(255)			NOT NULL	COMMENT 'ステータス',
	`from_date`			DATE	 							COMMENT '開始日',
	`to_date`			DATE	 							COMMENT '終了日',
	`title`				VARCHAR(255)			NOT NULL	COMMENT 'タイトル',
	`description`		TEXT								COMMENT '内容',
	`register_id`		BIGINT					NOT NULL	COMMENT '登録者ID',
	`assigned_id`		BIGINT								COMMENT '担当者ID',
	`modify_datetime`	DATETIME				NOT NULL	COMMENT '更新日時',
	`delete_flg`		CHAR(1)					NOT NULL	COMMENT '削除フラグ',
	`create_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：作成日時',
	`create_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：作成者ID',
	`update_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：更新日時',
	`update_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：更新者ID',
	PRIMARY KEY (`id`)
) COMMENT='チケット' ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `label` (
	`id`				BIGINT AUTO_INCREMENT	NOT NULL	COMMENT 'ID',
	`account_id`		BIGINT					NOT NULL	COMMENT 'アカウントID',
	`label`				VARCHAR(255)			NOT NULL	COMMENT 'ラベル',
	`color`				VARCHAR(255)			NOT NULL	COMMENT '文字色',
	`background_color`	VARCHAR(255)			NOT NULL	COMMENT '背景色',
	`delete_flg`		CHAR(1)					NOT NULL	COMMENT '削除フラグ',
	`create_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：作成日時',
	`create_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：作成者ID',
	`update_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：更新日時',
	`update_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：更新者ID',
	PRIMARY KEY (`id`)
) COMMENT='ラベル' ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `ticket_label` (
	`id`				BIGINT AUTO_INCREMENT	NOT NULL	COMMENT 'ID',
	`ticket_id`			BIGINT					NOT NULL	COMMENT 'チケットID',
	`label_id`			BIGINT					NOT NULL	COMMENT 'ラベルID',
	`delete_flg`		CHAR(1)					NOT NULL	COMMENT '削除フラグ',
	`create_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：作成日時',
	`create_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：作成者ID',
	`update_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：更新日時',
	`update_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：更新者ID',
	PRIMARY KEY (`id`)
) COMMENT='チケット・ラベル紐付け' ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `ticket_inbox` (
	`id`				BIGINT AUTO_INCREMENT	NOT NULL	COMMENT 'ID',
	`account_id`		BIGINT					NOT NULL	COMMENT 'アカウントID',
	`ticket_id`			BIGINT					NOT NULL	COMMENT 'チケットID',
	`delete_flg`		CHAR(1)					NOT NULL	COMMENT '削除フラグ',
	`create_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：作成日時',
	`create_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：作成者ID',
	`update_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：更新日時',
	`update_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：更新者ID',
	PRIMARY KEY (`id`)
) COMMENT='チケットトレイ' ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `ticket_unread` (
	`id`				BIGINT AUTO_INCREMENT	NOT NULL	COMMENT 'ID',
	`account_id`		BIGINT					NOT NULL	COMMENT 'アカウントID',
	`ticket_id`			BIGINT					NOT NULL	COMMENT 'チケットID',
	`delete_flg`		CHAR(1)					NOT NULL	COMMENT '削除フラグ',
	`create_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：作成日時',
	`create_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：作成者ID',
	`update_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：更新日時',
	`update_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：更新者ID',
	PRIMARY KEY (`id`)
) COMMENT='チケット未読' ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `activity` (
	`id`				BIGINT AUTO_INCREMENT	NOT NULL	COMMENT 'ID',
	`project_id`		BIGINT					NOT NULL	COMMENT 'プロジェクトID',
	`path`				TEXT					NOT NULL	COMMENT 'パス',
	`activity`			TEXT					NOT NULL	COMMENT 'アクティビティ',
	`register_id`		BIGINT					NOT NULL	COMMENT '登録者ID',
	`delete_flg`		CHAR(1)					NOT NULL	COMMENT '削除フラグ',
	`create_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：作成日時',
	`create_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：作成者ID',
	`update_datetime`	DATETIME 				NOT NULL	COMMENT '共通監査項目：更新日時',
	`update_id`			BIGINT 					NOT NULL	COMMENT '共通監査項目：更新者ID',
	PRIMARY KEY (`id`)
) COMMENT='アクティビティ' ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
