package net.waltzstudio.base.framework.entity;

import java.util.Date;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import net.waltzstudio.base.framework.types.DeleteFlg;

@MappedSuperclass
public abstract class AuditEntity extends Entity implements AuditEntityName {

	/** 削除フラグ */
	@Enumerated(EnumType.STRING)
	public DeleteFlg deleteFlg;

	/** 作成日時 */
	@Temporal(TemporalType.TIMESTAMP)
	public Date createDatetime;

	/** 作成者ID */
	public Long createId;

	/** 更新日時 */
	@Temporal(TemporalType.TIMESTAMP)
	public Date updateDatetime;

	/** 更新者ID */
	public Long updateId;

}
