package net.waltzstudio.base.framework.util;

import java.security.MessageDigest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.framework.util.MessageDigestUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.util.ActionMessagesUtil;
import org.seasar.struts.util.RequestUtil;
import org.seasar.struts.util.ResponseUtil;

/**
 * ベースUtil
 */
public class BaseUtil {

	/**
	 * キャスト
	 *
	 * @param src 元オブジェクト
	 * @return 変換結果（失敗時null）
	 */
	public static <T> T cast(Object src) {
		return cast(src, null);
	}

	/**
	 * キャスト
	 *
	 * @param src 元オブジェクト
	 * @param def 変換失敗時のデフォルト
	 * @return 変換結果
	 */
	@SuppressWarnings("unchecked")
	public static <T> T cast(Object src, T def) {
		try {
			return (T) src;
		} catch (Exception e) {
			return def;
		}
	}

	public static class Cast {
		public static Long toLong(Object src) {
			return toLong(src, null);
		}
		public static Long toLong(Object src, Long def) {
			if (src == null) {
				return def;
			}
			try {
				return Long.parseLong(src.toString());
			} catch (Exception e) {
				return def;
			}
		}
	}

	/**
	 * HTTPエラー
	 *
	 * @param statusCode HTTPステータスコード
	 */
	public static void sendError(int statusCode) {
		sendError(statusCode, null);
	}

	/**
	 * HTTPエラー
	 *
	 * @param statusCode HTTPステータスコード
	 * @param message メッセージ
	 */
	public static void sendError(int statusCode, String message) {
		try {
			if (StringUtil.isEmpty(message)) {
				ResponseUtil.getResponse().sendError(statusCode);
			} else {
				ResponseUtil.getResponse().sendError(statusCode, message);
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * ActionMessage登録
	 *
	 * @param session セッション
	 * @param key ActionMessageキー
	 * @param values ActionMessageキー引数
	 */
	public static void addMessage(String key, Object... values) {
		HttpSession session = RequestUtil.getRequest().getSession(true);
		ActionMessages am = new ActionMessages();
		if (values == null || values.length == 0) {
			am.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(key));
		} else {
			am.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(key, values));
		}
		ActionMessagesUtil.addMessages(session, am);
	}

	/**
	 * ActionMessage（エラー）登録
	 *
	 * @param session セッション
	 * @param key ActionMessageキー
	 * @param values ActionMessageキー引数
	 */
	public static void addError(String key, Object... values) {
		HttpSession session = RequestUtil.getRequest().getSession(true);
		ActionMessages am = new ActionMessages();
		if (values == null || values.length == 0) {
			am.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(key));
		} else {
			am.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(key, values));
		}
		ActionMessagesUtil.addErrors(session, am);
	}

	/**
	 * MessageDigest取得
	 *
	 * @param target 対象文字列
	 * @return MessageDigest（16進文字列）
	 */
	public static String getDigest(String target, String algorithm) {
		MessageDigest md = MessageDigestUtil.getInstance(algorithm);
		byte[] bytes = target.getBytes();
		md.update(bytes);
		return StringUtil.toHex(md.digest());
	}

}
