package net.waltzstudio.montecarlo.dao.label;

import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.List;
import net.waltzstudio.base.framework.types.DeleteFlg;
import net.waltzstudio.montecarlo.entity.label.Label;

/**
 * ラベルDao
 */
public abstract class LabelDao extends LabelDaoBase {

	public List<Label> findByAccountId(Long accountId) {
		return select().where(eq($ACCOUNT_ID, accountId), eq($DELETE_FLG, DeleteFlg.NORMAL)).orderBy(asc($LABEL)).getResultList();
	}

}
