package net.waltzstudio.montecarlo.dao.project;

//import static org.seasar.extension.jdbc.operation.Operations.*;
import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import java.util.List;
import net.waltzstudio.montecarlo.entity.project.Project;

/**
 * プロジェクトDao
 */
public abstract class ProjectDao extends ProjectDaoBase {

	/**
	 * アカウントIDから検索
	 *
	 * @param accountId アカウントID
	 * @return プロジェクト
	 */
	public List<Project> findByAccountId(Long accountId) {
		String sql = SB(true, " ", //
				"  SELECT *                            ", //
				"    FROM project p                    ", //
				"   WHERE p.delete_flg = '0'           ", //
				"     AND EXISTS (                     ", //
				"          SELECT 1                    ", //
				"            FROM account_project ap   ", //
				"           WHERE ap.project_id = p.id ", //
				"             AND ap.account_id = ?    ", //
				"             AND ap.delete_flg = '0'  ", //
				"        )                             ", //
				"ORDER BY id                           ");
		return jdbcManager.selectBySql(Project.class, sql, accountId).getResultList();
	}

	public Project findByCodeAndAccountId(String code, Long accountId) {
		String sql = SB(true, " ", //
				"  SELECT *                            ", //
				"    FROM project p                    ", //
				"   WHERE p.code = ?                   ", //
				"     AND p.delete_flg = '0'           ", //
				"     AND EXISTS (                     ", //
				"          SELECT 1                    ", //
				"            FROM account_project ap   ", //
				"           WHERE ap.project_id = p.id ", //
				"             AND ap.account_id = ?    ", //
				"             AND ap.delete_flg = '0'  ", //
				"        )                             ");
		return jdbcManager.selectBySql(Project.class, sql, code, accountId).getSingleResult();
	}

}
