package net.waltzstudio.montecarlo.dao.ticketLabel;

// import static org.seasar.extension.jdbc.operation.Operations.*;
import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import java.util.List;
import net.waltzstudio.montecarlo.entity.ticketLabel.TicketLabel;

/**
 * チケット・ラベル紐付けDao
 */
public abstract class TicketLabelDao extends TicketLabelDaoBase {

	public List<TicketLabel> findByAccountId(Long accountId) {
		String sql = SB(true, " ", //
				"  SELECT *                            ", //
				"    FROM ticket_label tl              ", //
				"   WHERE tl.delete_flg = '0'          ", //
				"     AND EXISTS (                     ", //
				"          SELECT 1                    ", //
				"            FROM label l              ", //
				"           WHERE l.account_id = ?     ", //
				"             AND l.delete_flg = '0'   ", //
				"        )                             ");
		return jdbcManager.selectBySql(TicketLabel.class, sql, accountId).getResultList();
	}

}
