package net.waltzstudio.montecarlo.interceptor;

import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.StringUtil;
import net.waltzstudio.base.framework.util.BaseUtil;
import net.waltzstudio.montecarlo.dto.SessionInfoDto;
import net.waltzstudio.montecarlo.object.Global;
import net.waltzstudio.montecarlo.service.LoginService;

/**
 * 管理者ログインInterceptor
 */
public class AdminLoginInterceptor extends AbstractInterceptor {
	private static final long serialVersionUID = 1L;

	/** リクエスト */
	@Resource
	protected Map<String, Object> requestScope;
	/** セッション */
	@Resource
	protected Map<String, Object> sessionScope;
	/** セッション情報 */
	@Resource
	protected SessionInfoDto sessionInfoDto;
	/** ログインService */
	@Resource
	protected LoginService loginService;

	/** HTTPセッション */
	@Resource
	protected HttpSession session;

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		if (loginService.isAdminLoggedIn(invocation)) {
			return invocation.proceed();
		} else {
			String redirectUrl = S(requestScope.get(Global.RequestInfo.SERVLET_PATH));
			if (!StringUtil.isEmpty(S(requestScope.get(Global.RequestInfo.QUERY_STRING)))) {
				redirectUrl = S(redirectUrl, "?", requestScope.get(Global.RequestInfo.QUERY_STRING));
			}
			sessionScope.put(Global.SessionInfo.REDIRECT_URL, redirectUrl);
			BaseUtil.addError("errors.login.admin");
			return "/secure?redirect=true";
		}
	}

}
