package net.waltzstudio.montecarlo.interceptor;

import javax.annotation.Resource;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import net.waltzstudio.base.framework.util.BaseUtil;
import net.waltzstudio.montecarlo.dto.SessionInfoDto;
import net.waltzstudio.montecarlo.service.LoginService;

/**
 * ログインInterceptor
 */
public class ApiInterceptor extends AbstractInterceptor {
	private static final long serialVersionUID = 1L;

	/** セッション情報 */
	@Resource
	protected SessionInfoDto sessionInfoDto;
	/** ログインService */
	@Resource
	protected LoginService loginService;

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		if (loginService.isLoggedIn(invocation)) {
			return invocation.proceed();
		} else {
			BaseUtil.sendError(403);
			return null;
		}
	}

}
