package net.waltzstudio.montecarlo.object;

import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.container.annotation.tiger.InstanceType;

/**
 * グローバル領域
 */
@Component(instance = InstanceType.SINGLETON)
public class Global {
	/** プロジェクトルーティング変更除外パス */
	public static final String[] PROJECT_ROUTING_IGNORE_PATH = { "secure", "admin", "api", "my" };
	/** リクエスト情報定数 */
	public static class RequestInfo {
		/** サーブレットパス */
		public static final String SERVLET_PATH = "javax.servlet.forward.servlet_path";
		/** Query String */
		public static final String QUERY_STRING = "javax.servlet.forward.query_string";
		/** プロジェクト識別子 */
		public static final String PROJECT_CODE = "montecarlo.project.code";
		/** プロジェクトリスト */
		public static final String PROJECT_LIST = "montecarlo.project.list";
	}
	/** セッション情報定数 */
	public static class SessionInfo {
		/** リダイレクトURL */
		public static final String REDIRECT_URL = "montecarlo.redirect.url";
	}
	/** バッチ情報定数 */
	public static class BatchInfo {
		public static final String SENDMAIL_DAEMON = "montecarlo.batch.sendmail.daemon";
		public static final String SENDMAIL_BATCH = "montecarlo.batch.sendmail.batch";
	}
	/** バッチインスタンス格納Map */
	public Map<String, Batch> batches = new HashMap<String, Batch>();
}
