package net.waltzstudio.montecarlo.service;

import javax.annotation.Resource;
import net.waltzstudio.base.framework.object.ObjectCache;
import net.waltzstudio.montecarlo.dao.account.AccountDao;
import net.waltzstudio.montecarlo.dao.ticket.TicketDao;
import net.waltzstudio.montecarlo.entity.account.Account;
import net.waltzstudio.montecarlo.entity.ticket.Ticket;

public class ObjectCacheService extends ObjectCache {
	/** アカウントDao */
	@Resource
	protected AccountDao accountDao;
	/** チケットDao */
	@Resource
	protected TicketDao ticketDao;

	public Account getAccountById(final Long groupId, final Long id) {
		return getValueByKey(groupId, "Account=>id", id, new LoadFunctor<Account>() {
			@Override
			public Account loadEntity() {
				return accountDao.findById(id);
			}
		});
	}

	public Ticket getTicketById(final Long groupId, final Long id) {
		return getValueByKey(groupId, "Ticket=>id", id, new LoadFunctor<Ticket>() {
			@Override
			public Ticket loadEntity() {
				return ticketDao.findById(id);
			}
		});
	}

}
