package net.waltzstudio.montecarlo.service.batch;

import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import java.util.Calendar;
import org.seasar.framework.log.Logger;
import org.seasar.struts.util.MessageResourcesUtil;
import net.waltzstudio.montecarlo.object.Batch;
import net.waltzstudio.montecarlo.object.Global;

/**
 * メール送信デーモンService
 */
public class SendmailDaemonService extends Batch {
	public SendmailDaemonService() {
		logger = Logger.getLogger(SendmailDaemonService.class);
	}

	@Override
	public String getBatchId() {
		return Global.BatchInfo.SENDMAIL_DAEMON;
	}

	@Override
	public String getBatchName() {
		return MessageResourcesUtil.getMessage("montecarlo.batch.sendmail.daemon");
	}

	@Override
	public void main() throws Exception {
		while (true) {
			sleep(1000);
			Calendar now = C();
			if (now.get(Calendar.SECOND) == 0 && now.get(Calendar.MINUTE) % 1 == 0) {
				batchControlService.start(Global.BatchInfo.SENDMAIL_BATCH);
			}
		}
	}

}
