/**
 * jQuery Checkbox Plugin
 * v1.0
 *
 * The MIT License
 *
 * Copyright (c) 2012 ykojima
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function($) {
	jQuery.fn.wsCheckbox = function(config) {
		config = jQuery.extend({
			all: 'all',
			chk: 'chk',
			row: '',
			rowSelected: 'selected',
		}, config);

		$(this).each(function() {
			var that = $(this);
			var allState = function() {
				var all = that.find('.' + config.all);
				var cntAll = that.find('.' + config.chk).size();
				var cntChk = that.find('.' + config.chk + ':checked').size();
				if (cntChk == 0) {
					all.removeAttr('checked').css({ opacity: 1.0 });
				} else if (cntAll == cntChk) {
					all.attr('checked', 'checked').css({ opacity: 1.0 });
				} else {
					all.attr('checked', 'checked').css({ opacity: 0.7 });
				}
			};
			/* init */
			if (config.row) {
				that.find('.' + config.chk + ':checked').each(function() {
					$(this).parents('.' + config.row).addClass(config.rowSelected);
				});
			}
			/* all checkbox event */
			that.find('.' + config.all).click(function(e) {
				e.stopPropagation();
				var checked = that.find('.' + config.chk + ':checked').size();
				if (checked > 0) {
					that.find('.' + config.chk).removeAttr('checked');
					if (config.row) {
						that.find('.' + config.row).removeClass(config.rowSelected);
					}
				} else {
					that.find('.' + config.chk).attr('checked', 'checked');
					if (config.row) {
						that.find('.' + config.row).addClass(config.rowSelected);
					}
				}
				allState();
			});
			/* each checkbox event */
			that.find('.' + config.chk).click(function(e) {
				e.stopPropagation();
				if (config.row) {
					var tr = $(this).parents('.' + config.row);
					if ($(this).attr('checked')) {
						tr.addClass(config.rowSelected);
					} else {
						tr.removeClass(config.rowSelected);
					}
				}
				allState();
			});
			/* each row event */
			if (config.row) {
				that.find('.' + config.row).click(function(e) {
					e.stopPropagation();
					var chk = $(this).find('.' + config.chk);
					if (chk.attr('checked')) {
						chk.removeAttr('checked');
						$(this).removeClass(config.rowSelected);
					} else {
						chk.attr('checked', 'checked');
						$(this).addClass(config.rowSelected);
					}
					allState();
				});
			}
			allState();
		});
	};
})(jQuery);
