<?php 
/**
 * CoppermineFetch :: cfimageget
 * 
 * This is a support library to help grab an image from a coppermine database and display them on normal 
 * HTML page by coming back as an image
 * 
 * Usage:  Call this file from an img tag and it will return graphic data to you
 *
 * cfimageget.php - will return random from anywhere in the gallery
 * cfimageget.php?category=1 - will return random image from category 1
 * cfimageget.php?album=1 - will return a random image from album 1
 *
 * Other options to add on
 * size=[thumb|int|large]
 *
 * @version $Revision: 1.1 $
 * The presedence is album over category, so if you add in both - you get whatever album is looking for
 */
 
// ***************************************************************** //
// ATTENTION :: You must change these to reflect your specific       //
// installation of coppermine.  If things don't work, please         //
// check to make sure you have these correct                         //
// ***************************************************************** //

include "coppermine_dao.php";
include "../../photos/include/config.inc.php";

// This is the path (NOT URL) from where your cfimageget.php file is to your coppermine directory
$pathtocpm = "../photos/";

// This is the partial url (part AFTER your domain name, to get to the coppermine directory
$urltocpm = "/photos/";

// This is the prefix your Coppermine databse uses for thumbnails  (default shown)
$thumbnailprefix='thumb_';

// This is the prefix coppermine uses for intermediate sizes (default shown)
$intermedprefix='normal_';

// This is the prefix coppermine uses for normal photos (default shown)
$fullsizeprefix='';

// This is the default size it will use if you dont specify a size= on the command line
// ONLY UNCOMMENT ONE OF THE FOLLOWING or leave it alone.

$defaultsize = $thumbnailprefix;
//$defaultsize = $intermedprefix;
//$defaultsize = $fullsizeprefix;


// If set to true, it will create a file in the current directory containing
// information on the last file displayed.  Only turn on for testing
$DEBUG = false;


// **************************************************************** //
// END OF CHANGES YOU NEED TO MAKE - DO NOT TAMPER WITH BELOW CODE  //
// **************************************************************** //

$cpm = new cpm_dao($CONFIG['dbname'], $CONFIG['dbserver'], $CONFIG['dbuser'],$CONFIG['dbpass'], 
$CONFIG['TABLE_PREFIX'],$urltocpm);
$cpm->setPhotoPrefix($thumbnailprefix, $intermedprefix, $fullsizeprefix);

if (array_key_exists('album',$_GET)) {
	global $cpm;
	$albumid = $_GET['album'];
	$size=getSizeOption();
	$results=$cpm->getRandomImageFromAlbum ($albumid, 1);
	returnImageToBrowser($results,$size);


}
elseif (array_key_exists('category',$_GET)) {
	global $cpm;
	$catid = $_GET['category'];
	$size=getSizeOption();
	$results=$cpm->getRandomImageFromCategory ($catid, 1);
	returnImageToBrowser($results,$size);
	
}
else {
	global $cpm;
	$size=getSizeOption();
	$results=$cpm->getRandomImage (1);
	returnImageToBrowser($results,$size);
}

function getSizeOption() {
	global $thumbnailprefix, $intermedprefix, $fullsizeprefix, $defaultsize;
	$size = $defaultsize	;

	if (array_key_exists('size',$_GET)) {
		$size=$_GET['size'];
		if ($size == 'thumb') {
			$size = $thumbnailprefix; 
		} elseif ($size=='int') {
			$size = $intermedprefix;		
		} elseif ($size=='large') {
			$size=$fullsizeprefix;	
		} else {
			$size=$defaultsize;	
		}
	}
	return ($size);
}

function returnImageToBrowser( $resultset, $size ) {
		global $DEBUG, $pathtocpm, $cpm;
		
		$row = mysql_fetch_row($resultset);	
   	
		$extension = strtolower(substr($row[1],strrpos($row[1],'.')));
		
		//$filetoget = $pathtocpm . '/albums/' .$row[0] . $size . $row[1];
		
		switch ($extension) {
			case '.jpeg':
			case '.jpg':
			case '.jpe':
				$contenttype = 'image/jpeg';
				break;
			case '.gif':
				$contenttype = 'image/gif';
				break;
			case '.png':
				$contenttype = 'image/png';
				break;
			case '.tiff';
				$contenttype = 'image/tiff';
				break;
			default:
				$contenttype = 'image/jpeg';
			}
		
		$filetoget = $_SERVER['DOCUMENT_ROOT'] . $cpm->getImageToUse($row[0],$row[1],$size);
				
		if ($DEBUG) {
			$handle = fopen("./cfimageget.last", "w");
			fwrite ($handle,$extension . ":" . $filetoget);
			fclose($handle);
		}
			
		header ("Cache-Control: must-revalidate, post-check=0, pre-check=0");
      header ("Content-Type: $contenttype");
		//header ("Content-Length: " . filesize($filetoget));
  		
		if ($file = fopen($filetoget, 'rb')) {
   		while(!feof($file) and (connection_status()==0)) {
     		print(fread($file, 1024*8));
     		flush();
   	}
   	$status = (connection_status()==0);
   	fclose($file);
  		
  } 
		//readfile('file://' . $filetoget);
}

?>









