<?php 
/**
 * cfrssget.php
 * 
 * @version $Revision: 1.6 $
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 * 
 */

error_reporting(E_ALL);
ini_set('display_errors',1);  // 0 is off, 1 is on 
 
include "cpmfetch_dao.php";
include "libs/feedcreator.class.php";

$ENABLED = false;			//Set to false if you will be creating standalone feed modules

if ($ENABLED) {
	
		$partialurltocpm = "/photos/";		//Part of the URL to CPG without the host and domain
		$default_command = "last";				//What to do if no cmd is specified
		// THESE SPECIFY THE INFORMATION USED IN YOUR FEED
	  // You only need to use this if you will be using this file as a feed
		
		$rssFeedTitle = "FistFullOfCode Photo Gallery";
		$rssFeedDescription = "The last 25 photos added to Fist Full Of Code.";
		$rssFeedSiteUrl = "http://www.xfistfullofcode.com";
		$rssFeedProviderUrl = "http://www.xfistfullofcode.com/cftest/rss_lastadded.php";
		$rssFeedImageTitle = "FFOC Logo";
		$rssFeedImageURL = 'http://www.xfistfullofcode.com/images/ffoc_logo.gif';
		$rssFeedImageLink = "http://www.xfistfullofcode.com";
		$rssFeedImageAlt = "logo";
		
		$rssItemTitle = "%a :: %t";
		$rssItemAlternateTitle = "%a :: %f";
		
		$rssItemDescription = "%f from album %a<br/>Filesize %S kb<br/>%c<br/>Rated %V / 5 stars (%v votes total)";
		$rssItemAlternateDescription = "%f from %a<br/>Filesize %S kb<br/>%a: %d<br/>Rated %V / 5 stars (%v votes total)";
		$totalToShow = 5;

		///// END OF USER SETTINGS /////////
	
		$cmd_parameter = "last";


		if (array_key_exists("cmd",$_GET)) {
			switch ($_GET['cmd']) {
				case ('mostviewed'):
				case ('toprated'):
				case ('last'):
				case ('random'):
				$cmd_parameter = $_GET['cmd'];
				break;
				
			default:
				$cmd_parameter = $default_command;
				break;
			}		
		} else {
			$cmd_parameter = $default_command;
		}
	
		$cfrss = new cfrss($partialurltocpm);
		$cfrss->startFeed($rssFeedTitle, $rssFeedDescription, $rssFeedSiteUrl, $rssFeedProviderUrl);
		$cfrss->setFeedImage($rssFeedImageTitle,$rssFeedImageURL,$rssFeedImageLink,$rssFeedImageAlt);
		$cfrss->setItemTitle($rssItemTitle,$rssItemAlternateTitle);
		$cfrss->setItemDescription($rssItemDescription,$rssItemAlternateDescription);

		switch ($cmd_parameter) {
				case ('mostviewed'):
						$cfrss->addMostViewedMedia($totalToShow);
						break;
				case ('toprated'):
						$cfrss->addTopRatedMedia($totalToShow); 
						break;		
				case ('last'):
						$cfrss->addLastAddedMedia($totalToShow);
						break;
				case ('random'):
						$cfrss->addRandomMedia($totalToShow);
						break;
				default:
						break;	
			}				

			$cfrss->endFeed();
}


////////// The cfrss object itself ///////////////////

class cfrss {
	
	var $cpm = "";
	var $rss = "";
	var $urltocpm = "";       //from a web client point of view without domain name /photos
	var $fullUrlToCpm = "";
	var $filepathtocpm = "";  //server path to cpm directory  /home/vuud/cpm

	
	var $thumbnailprefix = "thumb_"; 
	var $intermedprefix = "normal_";		
	var $fullsizeprefix = '';	
	var $defaultimagesize = "thumb_";
	
	var $itemTitle = "";
	var $itemAltTitle = "";
	var $itemDescription = "";
	var $itemAltDescription = "";
	
	function cfrss ($urltocpm_ = "") {
		if ($urltocpm_ != "") {

	   if (substr($urltocpm_,-1) != '/') $urltocpm_ .= '/';	

			$this->urltocpm = $urltocpm_;
			$this->filepathtocpm = $_SERVER['DOCUMENT_ROOT'] . $urltocpm_;
				
			if (file_exists($this->filepathtocpm . '/include/config.inc.php')) {
				include $this->filepathtocpm . '/include/config.inc.php';
					
				$this->cpm = new cpm_dao($CONFIG['dbname'], $CONFIG['dbserver'], 
									$CONFIG['dbuser'], $CONFIG['dbpass'], $CONFIG['TABLE_PREFIX'], $this->urltocpm);
			
				$this->fullUrlToCpm = "http://" . $_SERVER['HTTP_HOST'];
																		
				$this->cpm->setPhotoPrefix($this->thumbnailprefix, $this->intermedprefix, $this->fullsizeprefix);
					
				$this->rss = new UniversalFeedCreator();

			}
			else {
				print "ERROR: Path to Coppermine incorrect. (" . $this->filepathtocpm . ")";	
				$this = "";
			}
		}
	}
	
	function startFeed($title,$description,$link,$syndicationUrl) {
		$this->rss->title = $title;
		$this->rss->description = $description;
		$this->rss->link = $link;
		$this->rss->syndicationURL = $syndicationUrl;

	}
	
	function setFeedImage($imgTitle,$imgUrl,$imglink,$imgDescription) {
		$image = new FeedImage();
		$image->title = $imgTitle;
		$image->url = $imgUrl;
		$image->link = $imglink;
		$image->description = $imgDescription;
		$this->rss->image = $image; 
	}
	
	
	function setItemTitle ($pattern,$altpattern="") {
		$this->itemTitle = $pattern;
		
		if($altpattern == "") { 
			$this->itemAltTitle = $pattern; 
		} else {
			$this->itemAltTitle = $altpattern; 
		}
	}
	
	function setItemDescription ($pattern,$altpattern="") {
		$this->itemDescription = $pattern;
		
		if($altpattern == "") { 
			$this->itemAltDescription = $pattern; 
		} else {
			$this->itemAltDescription = $altpattern;
		}
	}
	
	function endFeed( ) {
		$this->rss->saveFeed("RSS1.0", "./tmp/feed.xml"); 
		$this->cpm->destroy();
	}
				
	function addLastAddedMedia($count,$source="") {
		$results = $this->cpm->getLastAddedMediaFrom($source,$count);
		$this->generateFeedFromResults($results);
  	}

	function addTopRatedMedia($count,$source="") {
		$results = $this->cpm->getTopRatedMediaFrom($source,$count);
		$this->generateFeedFromResults($results);
	}

	function addMostViewedMedia ($count,$source="") {
		$results = $this->cpm->getMostVotedMediaFrom($source,$count);
		$this->generateFeedFromResults($results);
	}

	function addRandomMedia ($count,$source="") {
		$results = $this->cpm->getRandomImageFrom($source,$count);
		$this->generateFeedFromResults($results);
	}

function generateFeedFromResults($results) {

		//while ($data = mysql_fetch_assoc($results)) { 
   	foreach ($results as $data) { 	

		$item = new FeedItem(); 
    		
  			$item->link = $this->fullUrlToCpm . $this->cpm->createLink($data['pFilepath'], rawurlencode($data['pFilename']), $data['pAid'], $data['pPid']);
						
			$titleToUse = "";
			$descriptionToUse="";
						
			if (($titleToUse = $this->cpm->createDescription($this->itemTitle,$data,true)) == false) {
				$titleToUse = $this->cpm->createDescription($this->itemAltTitle,$data);
			}
			
			if (($descriptionToUse = $this->cpm->createDescription($this->itemDescription,$data,true)) == false) {
					$descriptionToUse = $this->cpm->createDescription($this->itemAltDescription,$data);	
			}
			
			$imagetag = '<a href="' . $item->link . '"><img src="' .  $this->fullUrlToCpm  
							. $this->cpm->urlEncodeImagePath($this->cpm->getImageToUse($data['pFilepath'],$data['pFilename'], $this->thumbnailprefix)) . '" align="right" /></a>';

			$descriptionToUse = $imagetag . $descriptionToUse;
		
			$item->title = $titleToUse;
			
			$item->description = $descriptionToUse;
    
    		$item->date = date("r",$data['pCtime']);
    		$item->source = $this->fullUrlToCpm; 
    		$item->author = $data['pOwner_name']; 
 			
			$this->rss->addItem($item); 
		}

	}	

} // end of class


?>
