<?php
	// You need to change this variable to the directory that the Coppermine photo gallery is installed in.
	// If you installed CPG to the root of your website, just use a /
	// IMPORTANT:  Change the part below in quotes, NOT the $ChangeThis... part
	$ChangeThisToYourPartialUrlToCPG = "/changethishere";	
	
$CPMFETCHVERSION = "1.4";
	error_reporting(E_ALL);
	ini_set('display_errors',1);  // 0 is off, 1 is on

if (array_key_exists("showmephp",$_REQUEST ) && $_REQUEST["showmephp"] == "yes") {
		phpinfo();
		exit;
	}

?>

<html>
<head>
<title>CpmFetch Install Test page - version <?php print $CPMFETCHVERSION; ?></TITLE>

<STYLE type="text/css">
body {
	font-family : Arial, Helvetica, sans-serif;
	font-size : 13px;
	font-weight : normal;
	color : #4A4A82;
}

TD {
	font-family : Arial, Helvetica, sans-serif;
	font-size : 12px;
	font-weight : normal;
	color : #4A4A82;
}

A {
	font-family : Arial, Helvetica, sans-serif;
	font-size : 12px;
	font-weight : bold;
	text-decoration : underline;
	color : #4A4A82;
}

A:HOVER {
	font-family : Arial, Helvetica, sans-serif;
	font-size : 12px;
	font-weight : bold;
	text-decoration : none;
	color : #4A4A82;
}

.title {
	font-family : Arial, Helvetica, sans-serif;
	font-size : 16px;
	font-weight : bold;
	color : #4A4A82;
}

.subtitle {
	font-family : Arial, Helvetica, sans-serif;
	font-size : 14px;
	font-weight : bold;
	color : #4A4A82;
}

img.photoclip { 
          border-style:solid;
          border-width:5px;
          border-color: #000000;
          margin: 2px; }

img.photoclip:hover {
          border-style:solid;
          border-width:5px;
          border-color: #cccccc;
          margin: 2px; }

	.photoclip {  
		text-align:center; 
	}

</STYLE>




</head>
<body>

<p><span class="title">CpmFetch Install test page</span><br>
<span class="subtitle">Thank you for using CpmFetch <?php print $CPMFETCHVERSION; ?></span></p>

<hr>

<p>A series of checks is displayed below...  These will help you determine where a problem is if one occurs.  Mostly they will help me when you ask for help... but I strongly encourage you to try to fix it yourself - that leaves me more time for improvements.  Some of them are purely informational.</p>


<p><span class="subtitle">Tests:</span></p>
<table width="100%" cellpadding="10" border="1"><TR><TD>
<table width="100%">

<?php

$GOODTOTRY = true;
$TESTS_PREVENTING = "";

$testnumber = 5;
if ($ChangeThisToYourPartialUrlToCPG == "/changethishere") {
	OutputTestRow($testnumber,"You forgot to edit line 5 of cftest.php","FAIL");
	$GOODTOTRY = false;
	$TESTS_PREVENTING .= "$testnumber ";
}
else
{
	OutputTestRow($testnumber,"You set your partial URL to $ChangeThisToYourPartialUrlToCPG","PASS");
};

$testnumber = 10;
if (strpos($ChangeThisToYourPartialUrlToCPG,"..")) {
	OutputTestRow($testnumber, "Parent directory dots found in partial url","FAIL");
	$GOODTOTRY = false;
	$TESTS_PREVENTING .= "$testnumber ";
} else {
	OutputTestRow($testnumber, "No dots in partial url","PASS");
}

$testnumber = 15;
if (file_exists("coppermine.php")) {
	OutputTestRow($testnumber, "coppermine.php was found - should be removed","BAD");
} else {
	OutputTestRow($testnumber, "coppermine.php found","PASS");
}

$testnumber = 20;
if (file_exists("coppermine_dao.php")) {
	OutputTestRow($testnumber, "coppermine_dao.php was found - should be removed","BAD");
} else {
	OutputTestRow($testnumber, "coppermine_dao.php has been removed","PASS");
}

$testnumber = 25;
if (! file_exists("cpmfetch.php")) {
	OutputTestRow($testnumber, "cpmfetch.php not found in same directory","FAIL");
	$GOODTOTRY = false;
	$TESTS_PREVENTING .= "$testnumber ";
} else {
	OutputTestRow($testnumber, "cpmfetch.php found","PASS");
}

$testnumber = 30;
if (! file_exists("cpmfetch_dao.php")) {
	OutputTestRow($testnumber, "cpmfetch_dao.php not found in same directory","FAIL");
	$GOODTOTRY = false;
	$TESTS_PREVENTING .= "$testnumber ";
} else {
	OutputTestRow($testnumber, "cpmfetch_dao.php found","PASS");
}

$testnumber = 35;
OutputTestRow($testnumber,"Server OS = " . php_uname() ,"INFO");

$testnumber = 40;
OutputTestRow($testnumber,"WebServer = " . $_SERVER['SERVER_SOFTWARE'] ,"INFO");

$testnumber = 45;
OutputTestRow($testnumber,"PHP Version = " .  phpversion( ) ,"INFO");

$testnumber = 50;
OutputTestRow($testnumber,"PHP Version = "  ,"INFO");

$testnumber = 55;
 if (array_key_exists("DOCUMENT_ROOT",$_SERVER )) {
	OutputTestRow($testnumber, "DOCUMENT_ROOT: " . $_SERVER['DOCUMENT_ROOT'], "INFO");
}
else {
	OutputTestRow($testnumber, "DOCUMENT_ROOT: Not found","BAD");
}

$testnumber = 60;
 if (array_key_exists("C_DOCUMENT_ROOT",$_SERVER )) {
	OutputTestRow($testnumber, "C_DOCUMENT_ROOT: " . $_SERVER['C_DOCUMENT_ROOT'], "INFO");
}
else {
	OutputTestRow($testnumber, "C_DOCUMENT_ROOT: Not found","INFO");
}

$testnumber = 65;
 if (ini_get('doc_root') != "") {
	OutputTestRow($testnumber, "doc_root: " . ini_get('doc_root'), "INFO");
}
else {
	OutputTestRow($testnumber, "doc_root: Not found (IIS Servers only)","INFO");
}

$testnumber = 70;
 if (array_key_exists("SCRIPT_FILENAME",$_SERVER )) {
	OutputTestRow($testnumber, "SCRIPT_FILENAME: " . $_SERVER['SCRIPT_FILENAME'], "INFO");
}
else {
	OutputTestRow($testnumber, "SCRIPT_FILENAME: Not found","BAD");
}

// Check doc_root against script path
$testnumber = 75;
$len_documentroot = strlen($_SERVER['DOCUMENT_ROOT']);
if (strncmp($_SERVER['DOCUMENT_ROOT'],$_SERVER['SCRIPT_FILENAME'],$len_documentroot) == 0) {
	OutputTestRow($testnumber, "DOCUMENT_ROOT is a good match","PASS");
} else {
	OutputTestRow($testnumber, "DOCUMENT_ROOT is not a good match","BAD");
}

$testnumber = 80;
$cpgconfigfile = $_SERVER['DOCUMENT_ROOT'] . $ChangeThisToYourPartialUrlToCPG . '/include/config.inc.php';
 if (file_exists($cpgconfigfile)) {
	OutputTestRow($testnumber, "Found CPG config file", "PASS");
}
else {
	OutputTestRow($testnumber, "CPG Config file not found: $cpgconfigfile","FAIL");
	$GOODTOTRY = false;
	$TESTS_PREVENTING .= "$testnumber ";
}

?>
</table></TD></TR></table>
<?php 

	if ($GOODTOTRY) {

		print "<p><span class='subtitle'>Trying to display some images:</span></p>\n";

		testDisplay($ChangeThisToYourPartialUrlToCPG);

	   printHelpLink();

	} else {

	print "<p><span class='subtitle'>WARNING: Some tests failed...</span></p>\n";	
	print "<p>Some of the tests above are crucial to this test running.  Since some of them failed, we will not be trying to 
start the cpmfetch display.  You need to correct the above - although in some cases, you will not be able to get this test 
to run correctly at all (strange configurations).</p> \n";

		print "<p>Please try to resolve the failures on test(s): <strong>$TESTS_PREVENTING</strong></p>\n";

		printHelpLink();

	}

?>
		
</body>
</html>

<!-- end of html -->

<?php

 function printHelpLink( ) {
	 	print "For further help and in general more information, please see the <a href=\"http://cpmfetch.fistfullofcode.com\">help pages for CoppermineFetch.</a>";
	 	 
	 }


function OutputTestRow ($number,$text,$status) {
	print "<TR><TD><strong>$number</strong></TD><TD>$text</TD><TD><strong>";
	
	switch ($status) {
		case ("PASS"):
			print "<font color='green'>";
			print $status;
			print "</font>";
			break;

		case ("INFO"):
			print "<font color='black'>";
			print $status;
			print "</font>";
			break;
		case ("BAD"):
			print "<font color='red'>";
			print $status;
			print "</font>";
			break;
		case ("FAIL"):
			print "<font color='red'>";
			print "<blink>";
			print $status;
			print "</blink></font>";
			break;

		default:
			print $status;
	}
	
	print "</strong></TD></TR>\n";
}


function testDisplay ($PartialUrlToCPG) {

		include "./cpmfetch.php";
		$objCpm = "";
		$objCpm = new cpm($PartialUrlToCPG);
	
		$styleguide = array(
			//"TABLESTYLE" => "photoclip",
			//"rowstyle" => "photoclip",
			"cellstyle" => "photoclip",
			"linkstyle" => "photoclip",
			"alttag" => "One of the last photos submitted",
			"subtitle" => "%o<br>%V views",
			"imagestyle" => "photoclip",
			"imagesize" => 'thumb',
			"imagewidth" => '150');		

 		print "<p>Your installation seems correct so far, you should see a small grid of thumbnails from your gallery</p>";
		$objCpm->cpm_viewRandomMedia(2,3,$styleguide); 
		print "<p>&nbsp;</p>";
		$objCpm->cpm_close(); 

		print "<p>If you do not see thumbnails, or get more warnings then something is pretty wrong.  As long as you are using standard prefixes in Coppermine, you should see everything.  If you are not using standard prefixes, then you need to adjust them by editing the first three variables in the cpmfetch.php file.</p>
		<p>If everything looks good, and you get everything else working, I'd recomment removing this file, or making it non-executable.  No need to allow access into a phpinfo tag if you dont have to. </p>";
}

?>
