<?php
/**
 * CoppermineFetch
 *
 * This is a support library to help grab images from a coppermine database and display them on normal php
 * pages outside the coppermine program.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * Runs on: Tested on coppermine 1.3.2,
 * HTML: Generates XHTML (as far as I can tell)
 * PHP: Tested on version 4
 * @package coppermine
 * @version $Revision: 1.17 $
 *
 */

/**
 * This includes the object for data access
 *
 */
require_once "cpmfetch/coppermine_dao.php";

/**
 * main interface object to extract thumbnails
 *
 * @package coppermine
 *
 */
class cpm {

        //The following 3 entries can be adjusted if you are using non-standard prefixes in CPG
        var $thumbnailprefix = "t_";
        var $intermedprefix = "n_";
        var $fullsizeprefix = '';

        var $defaultimagesize = "t_";

        // //////////////////// NO USER SERVICEABLE PARTS BEYOND THIS POINT ////////////////////////





        //  ... really







        // //////////////////// NO USER SERVICEABLE PARTS BEYOND THIS POINT ////////////////////////

        var $VERSION = "1.3.4";

        var $cpm = "";
        var $urltocpm = "";       //from a web client point of view without domain name /photos
        var $filepathtocpm = "";  //server path to cpm directory  /home/vuud/cpm

        var $optionHash = array();        //Contains the options submitted by the user
        var $styleHash = array();

        var $returntype = "print";                // print, html, resultset
        var $debugMode = false;

  /**
        * Initializes the coppermine data access object
        *
        * This does NOT create a database connection.  It simply creates the underlying object - and this
        * is the only thing it does.  Pass it the url the coppermine directory without the domain name, etc...
        *
        * @param string $urltocpm_ from a web client point of view without domain name /photos
        */
        function cpm ($urltocpm_ = "") {

                if ($urltocpm_ != "") {

                if (substr($urltocpm_,-1) != '/') $urltocpm_ .= '/';

                        $this->urltocpm = $urltocpm_;

                   if (array_key_exists("DOCUMENT_ROOT",$_SERVER )) {
                                        $this->filepathtocpm = $_SERVER['DOCUMENT_ROOT'] . $urltocpm_;
                        } elseif (ini_get("doc_root") != "") {
                                $this->filepathtocpm = ini_get('doc_root') . $urltocpm_;
                   } else {
                                        $this->filepathtocpm = $urltocpm_;
                        }


                        if (file_exists($this->filepathtocpm . '/include/config.inc.php')) {
                                include $this->filepathtocpm . '/include/config.inc.php';

                                $this->cpm = new cpm_dao($CONFIG['dbname'], $CONFIG['dbserver'],
                                                                        $CONFIG['dbuser'], $CONFIG['dbpass'], $CONFIG['TABLE_PREFIX'], $this->urltocpm);

                                $this->cpm->setPhotoPrefix($this->thumbnailprefix, $this->intermedprefix, $this->fullsizeprefix);

                        }
                        else {
                                print "ERROR: Path to Coppermine incorrect. (" . $this->filepathtocpm .'/include/config.inc.php'  .  ")";
                                // $this = "";   //Removed to support php5
                        }
                }
        }

        /**
        * Initializes the coppermine data access object
        *
        * This does NOT create a database connection.  It simply creates the underlying object - and this
        * is the only thing it does.  It is highly recommened you use the alternative function instead of this one.
        * If you have to use this, please get the values from your includes/config.inc.php file.
        *
        * @param string $mysql_dbname The Mysql database name
        * @param string $mysql_host  The host the database resides on
        * @param string $mysql_username The username for the database
        * @param string $mysql_password The password for the username for the database
        * @param string $cpm_mysql_tableprefix The table prefix used for Coppermine tables
        * @param string $urltocpm_ from a web client point of view without domain name /photos
        */
        function cpm_init ($mysql_dbname, $mysql_host, $mysql_username, $mysql_password, $cpm_mysql_tableprefix, $urltocpm_) {

                if (substr($urltocpm_,-1) != '/') $urltocpm_ .= '/';
                $this->urltocpm = $urltocpm_;

       if (array_key_exists("DOCUMENT_ROOT",$_SERVER )) {
                                        $this->filepathtocpm = $_SERVER['DOCUMENT_ROOT'] . $urltocpm_;
                } else {
                                        $this->filepathtocpm = $urltocpm_;
                }

                if (file_exists($this->filepathtocpm . '/include/config.inc.php')) {
                        $this->cpm = new cpm_dao($mysql_dbname, $mysql_host, $mysql_username, $mysql_password, $cpm_mysql_tableprefix, $this->urltocpm);
                        $this->cpm->setPhotoPrefix($this->thumbnailprefix, $this->intermedprefix, $this->fullsizeprefix);
                }
                else {
                        print "ERROR: Path to Coppermine incorrect. (" . $this->filepathtocpm . ")";
                        //$this = "";    // Removed to support php5
                }
        }

        /**
        * Ends use of the library.
        *
        * This will insure that any open database connections are closed.
        */
        function cpm_close () {
                $this->cpm->destroy();
        }


        function cpm_getVersion() {
                return ($this->VERSION);
        }



        /**
        * Adds a way to override the path to the coppermine directory
        *
        *
        */
        function cpm_OverridePathToCoppermine($newpath_) {
                $this->filepathtocpm = $newpath_;
                $this->cpm->OverridePathToCoppermine($newpath_);
        }

        /**
        *
        *
        *
        */
        function cpm_OverrideUrlToCoppermine($newpath_) {
                $this->urltocpm = $newpath_;
                $this->cpm->OverrideUrlToCoppermine($newpath_);
        }

        /**
        * Toggles access to non-public photos (default: false)
        *
        * Allows images not publically available to be selected and displayed until it is
        * turned off, or the object is recreated.  This program makes no distinction beyond if
        * a media item is public or not.
        *
        * @param $bool true or fale.  True unlocks access to private media
        * @since Version 0.7
        */
        function cpm_unlock_private ($bool) {
                if ($bool) {
                        $this->cpm->setPrivateLockOn(false);
                } else {
                        $this->cpm->setPrivateLockOn(true);
                }

                if ($this->debugMode) { print "cpm_unlock_private " . $bool; }

        }

        /**
        * Toggles cpmFetch into a debug mode (default: false)
        *
        * Actives some extra output for troubleshooting.  Probably will wreak havoc on your web page, but
        * it will help me help you when / if the time comes.
        *
        * @param $bool true or false.  Do not enclose in quotes.
        * @since 1.1.1
        */
        function cpm_setDebugMode($bool) {
                if ($bool) {
                        $this->debugMode = true;
                        $this->cpm->setDebugMode(true);
                } else {
                        $this->debugMode = false;
                        $this->cpm->setDebugMode(false);
                }
        }



        /**
        * Limits what types of media can be selected by this program
        *
        * Allows you to specify a list of extensions that are allowable for displaying.  Types not
        * explicity identified are omitted from results.  The format for submitting file types is an array
        * of extensions.  such as array(".jpg",".avi").  There is a limit as matches will be made against
        * the lower case and upper case versions of the types.  If you have only one type, you may specifiy
        * it as a string instead of an array.
        *
        * @param mixed $filter - either a string of one extension or an array of several extensions
        *
        */
        function cpm_setFilter($filter) {
                if (is_array($filter)) {
                        $this->cpm->setFilter($filter);
                }
                elseif ($filter != "") {
                        $this->cpm->setFilter(array($filter));
                }
                else {
                        $this->cpm->setFilter("");
                }
        }


        /**
        * Sets the return action of many functions to select from printing html, returning html or returning resultsets.
        *
        * This sets the output from any calls made after this.  Output can be selected by setting
        * this function with print (default - outputs html to the screen), html - returns all the html code as a returned string
        * or resultset.  Returns a mysql resultset
        *
        * @param string $_type - set to "html", "print", or "resultset"
        */
        function cpm_setReturnType($_type="") {
                $_type = strtolower($_type);

                switch ($_type) {
                                case('resultset'):
                                $this->returntype = "resultset";
                                break;
                        case('html'):
                                $this->returntype = "html";
                                break;
                        case('print'):
                                $this->returntype = "print";
                                break;
                        default:
                                if ($this->debugMode) { print "setReturnType defulted"; }
                                $this->returntype = "print";
                                break;
                }
        }

        /**
        * Sets the format as seen in the php DATE function to be used in rendering dates
        *
        * Sets the format as seen in the php DATE function to be used in rendering dates.  For more information on the kinds of
        * date strings you can use see: http://us2.php.net/manual/en/function.date.php
        *
        * @param string $_format - set to a valid date format string
        */
        function cpm_setDateFormat ($_format = "") {
                $this->cpm->setDateFormatString( $_format);
        }


        /**
        * Gets the number of items in the gallery, including private entries.
        *
        * Prints the value directly to output, but now Supports returnType for print and html
        *
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_listMediaCount ( ) {
                $output = $this->cpm->getMediaCount( );

                $retval = "";

                switch ($this->returntype) {
                        case ('resultset'):
                                break;
                        case ('html'):
                                $retval = $output;
                                break;
                        case ('print'):
                        default:
                                print $output;
                }
                return ($retval);
        }

        /**
        * Returns number of items in the gallery, including private entries
        *
        * Returns value of items in the gallery
        *
        * @return number Shows the number of items in the gallert
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_getMediaCount ( ) {
                $output = $this->cpm->getMediaCount( );
                return ($output);
        }



        /**
        * Returns number of items in the gallery, including private entries, as defined by source or source = "" for everything
        *
        * Returns value of items in the gallery
        * By Default prints the number directly to output.  Supports returnType for print and html
        *
        * @return number Shows the number of items in the gallert
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_listMediaCountFrom ($source ) {
                $output = $this->cpm->getMediaCountFrom($source );

                $retval = "";

                switch ($this->returntype) {
                        case ('resultset'):
                                break;
                        case ('html'):
                                $retval = $output;
                                break;
                        case ('print'):
                        default:
                                print $output;
                }

                return ($retval);
        }


        /**
        * Displays number representing the number of items in an album, including private entries.
        *
        * By Default prints the number directly to output.  Supports returnType for print and html
        *
        * @param int $albumid Number representing the album number
        * @since Version 0.5
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_listMediaCountForAlbum ($albumid) {
                $output = $this->cpm->getMediaCountForAlbum($albumid);
                $retval = "";

                switch ($this->returntype) {
                        case ('resultset'):
                                break;
                        case ('html'):
                                $retval = $output;
                                break;
                        case ('print'):
                        default:
                                print $output;
                }

                return ($retval);
        }

        /**
        * Returns number representing the number of items in an album, including private entries
        *
        * Does not Supports returnType,
        *
        * @param int $albumid Number representing the album number
        * @return number Representing the count for a specific album
        * @since Version 0.5
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_getMediaCountForAlbum ($albumid) {
                $output = $this->cpm->getMediaCountForAlbum($albumid);
                return ($output);
        }

        /**
        * Outputs stats based on a format submitted
        *
        * The format is specified by placeholders indicated by percent signs '%'.  If you actually want a percent sign
        * you will need to put two percent signs in a row '%%'.  The most up to date list for supported placeholders
        * can be found in the coppermine_dao formatStats function.  But the main ones are:
        * <ul><li>%f - file count</li>
        * <li>%a - album count</li>
        * <li>%c - category count</li>
        * <li>%v - view count</li>
        * <li>%n - comment count (note count)</li></ul>
        * For example: "There are %f files in %c categories containing %a albums, having served %v views and getting %n comments"
        * This supports the returnType setting except for type resultset.  Returns nothing in that case.
        *
        * @param string $format The format template to output in
        * @since Version 0.7
        */
        function cpm_formatStats($format) {

                $output =  $this->cpm->formatStats($format);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                break;
                        case ('html'):
                                $retval = $output;
                                break;
                        case ('print'):
                        default:
                                print $output;
                }

                return ($retval);
        }

        /**
        * Displays images of last added media
        *
        * This will generate a table and populate it with the last added media and style
        * it based on entries in the style hash. The number of photos returned matches the number
        * of rows multiplied by the number of columns.    Supports the setReturnType option.
        *
        * @param int $rows The number of rows desired in the output
        * @param int $columns The number of columns desired in the output
        * @param array $options Optional, Configuration options
        * @return string XHTML code
        * @since Version 0.5
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_viewLastAddedMedia($rows, $columns, $options="") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getLastAddedMedia($rows*$columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);
        }

        /**
        * Displays images of last added media for a specific album
        *
        * This will generate a table and populate it with the last added media and style
        * it based on entries in the style hash. The number of photos returned matches the number
        * of rows multiplied by the number of columns.  Supports the setReturnType option.
        * @param int $rows The number of rows desired in the output
        * @param int $columns The number of columns desired in the output
        * @param int $albumid The album id of the album you want to display
        * @param array $options Optional, Configuration options
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_viewLastAddedMediaFromAlbum($rows, $columns, $albumid, $options="") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getLastAddedMediaFromAlbum($albumid, $rows*$columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);
        }

        /**
        * Displays images of last added media for a specific category
        *
        * This will generate a table and populate it with the last added media and style
        * it based on entries in the style hash. The number of photos returned matches the number
        * of rows multiplied by the number of columns.  Supports the setReturnType option.
        *
        * @param int $rows The number of rows desired in the output
        * @param int $columns The number of columns desired in the output
        * @param int $catid The category id of the album you want to display
        * @param array $options Optional, Configuration options
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_viewLastAddedMediaFromCategory($rows, $columns, $catid, $options="") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getLastAddedMediaFromCategory($catid,$rows*$columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);
        }

        /**
        * Displays images of last added media for a specific category
        *
        * This will generate a table and populate it with the last added media and style
        * it based on entries in the style hash. The number of photos returned matches the number
        * of rows multiplied by the number of columns.  Supports the setReturnType option.
        *
        * @param int $rows The number of rows desired in the output
        * @param int $columns The number of columns desired in the output
        * @param int $catid The category id of the album you want to display
        * @param array $options Optional, Configuration options
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_viewLastAddedMediaFrom($rows, $columns, $source, $options="") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getLastAddedMediaFrom($source,$rows*$columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);
        }

        /**
        * Displays random images from specific album or category
        *
        * This will generate a table and populate it with random media from the combination of
        * categories and albums specified and style it based on entries in the style hash.
        * The number of photos returned matches the number of rows multiplied by the number of columns.
        * Supports the setReturnType option.
        *
        * @param int $rows The number of rows desired in the output
        * @param int $columns The number of columns desired in the output
        * @param int $sources The sources you want to draw from ("cat=1,4,5:album=6,7,8")
        * @param array $options Optional, Configuration options
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_viewRandomMediaFrom($rows, $columns, $source, $options="") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getRandomImageFrom ($source, $rows*$columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);
        }

        /**
        * Displays random images from specific album
        *
        * This will generate a table and populate it with random media from one album and style
        * it based on entries in the style hash.  The number of photos returned matches the number
        * of rows multiplied by the number of columns.  Supports the setReturnType option.
        *
        * @param int $rows The number of rows desired in the output
        * @param int $columns The number of columns desired in the output
        * @param int $albumid The album id of the album you want to display
        * @param array $options Optional, Configuration options
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_viewRandomMediaFromAlbum ($rows, $columns, $albumid, $options="") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getRandomImageFromAlbum ($albumid, $rows*$columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);
        }

        /**
        * Displays random images from specific category
        *
        * This will generate a table and populate it with random media from one category and style
        * it based on entries in the style hash.  The number of photos returned matches the number
        * of rows multiplied by the number of columns.  Supports the setReturnType option.
        *
        * @param int $rows The number of rows desired in the output
        * @param int $columns The number of columns desired in the output
        * @param int $catid The category id of the album you want to display
        * @param array $options Optional, Configuration options
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_viewRandomMediaFromCategory ($rows, $columns, $catid, $options="") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getRandomImageFromCategory ($catid, $rows*$columns);
                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);
        }

        /**
        * Displays random images from database
        *
        * This will generate a table and populate it with the random media and style
        * it based on entries in the style hash.  The number of photos returned matches the number
        * of rows multiplied by the number of columns.  Supports the setReturnType option.
        *
        * @param int $rows The number of rows desired in the output
        * @param int $columns The number of columns desired in the output
        * @param array $options Optional, Configuration options
        * @since Version 0.5
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_viewRandomMedia($rows, $columns, $options="") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getRandomImage($rows*$columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);
        }

function cpm_viewMediaByPid($pid, $options="") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getMediaByPid($pid);
                $rows = 1;
                $columns = 1;

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);
        }




        /**
        * Displays last comments with images
        *
        * This will generate a table and populate it with the last commented images
        * The number of photos returned matches the number of rows multiplied by the number of columns.
        * Supports the setReturnType option.  This acts like many others excet you now have two new subtitle
        * and title options %C - Which is the comment itself, and %a - which is the author of the comment.
        *
        * @param int $rows The number of rows desired in the output
        * @param int $columns The number of columns desired in the output
        * @param array $options Optional, Configuration options
        * @since Version 1.1.3
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_viewLastCommentedImages($rows, $columns, $options = "") {
                $this->loadOptions($options);
                $resultset = $this->cpm->getLastImagesWithComments($rows*$columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }
                $this->clearOptions();
                return ($retval);
        }


        function cpm_viewTopRatedMediaFrom ($source, $rows, $columns, $options) {
                $this->loadOptions($options);

                $resultset = $this->cpm->getTopRatedMediaFrom ($source, $rows * $columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);

        }



        function cpm_viewMostVotedMediaFrom ($source,  $rows, $columns, $options) {

                $this->loadOptions($options);
                $resultset = $this->cpm->getMostVotedMediaFrom ($source, $rows * $columns);

                $retval = "";
                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $this->createTable($resultset,$rows,$columns);
                                break;
                        case ('print'):
                        default:
                                print $this->createTable($resultset,$rows,$columns);
                }

                $this->clearOptions();
                return ($retval);

        }

   /**
        * Displays a list of albums with icons and count over past days
        *
        * This function does not currently use the stylehash functionality.   Supports the setReturnType option.
        *
        * @param int $numberOfDays The number of days going back to be included.
        * @param array $options Optional, Configuration options
        * @todo add style has functionality
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_showCategoriesUpdatedOverLastDays($numberOfDays,$options="") {

                $this->loadOptions($options);

                $htmlOut = "";
                $retval = "";

                $lwd = getdate(strtotime("-" . $numberOfDays . " day"));
                //$timestamp = date("Ymdhis",strtotime("-" . $numberOfDays . " day"));
                $verbosedate = date("l, F j Y",strtotime("-" . $numberOfDays . " day"));
                $timestamp = $lwd[0];

                $mediacount = $this->cpm->getMediaCountAddedSince($timestamp);

                if ($mediacount == 0) {
                                $htmlOut .= "No categories have been updated since {$verbosedate}";
                        //print "No images have been added since " . $verbosedate;
                }
                else {

                        $resultset = $this->cpm->getMediaAddedToCategoriesSince($timestamp);

                        if ($this->returntype != 'resultset') {
                                $htmlOut .= "\n" . $this->htmlTagTABLE() . "\n";

                                //$HtmlOut .= "<table width=\"80%\" cellpadding=\"5\" cellspacing=\"0\"{$tableStyle}>\n";
                                $htmlOut .= $this->htmlTagTR() . "\n" .
                                                                $this->htmlTagTH("<strong>Since {$verbosedate} we've added {$mediacount} images</strong>",'colspan="2"');
                                $htmlOut .= $this->htmlTagTR_END();

                                while ($row = mysql_fetch_assoc($resultset)) {

                                        $htmlOut .= $this->htmlTagTR();

                                        if (array_key_exists('alttag',$this->optionHash)) {
                                                $alttag = $this->cpm->createDescription($this->optionHash['alttag'],$row);
                                        }else{
                                                $alttag = $this->cpm->createDescription("%f",$row);
                                        }

                                        $attributes = 'alt="' . $alttag . '" title="' . $alttag . '"';
                                        $imgfile = $this->cpm->getImageToUse($row['pFilepath'],$row['pFilename'], $this->getPrefixToUse());
                                        $link = $this->cpm->createlink($row['pFilepath'],$row['pFilename'],$row['pAid'],$row['pPid'],$this->getoption('imagelink'));

                                        if ($link != "") {
                                                $htmlOut .= $this->htmlTagTD($this->htmlTagAHREF($link,$this->htmlTagIMG($imgfile,$attributes)));
                                        } else {
                                                $htmlOut .= $this->htmlTagTD($this->htmlTagIMG($imgfile,$attributes));
                                        }

                                        $htmlOut .= $this->htmlTagTD("<strong>{$row['count']} new in " .
                                                $this->htmlTagAHREF("{$this->urltocpm}index.php?cat={$row['cCid']}",$row['cName']) . "</strong><br>{$row['count']}",'valign="top"');

                                        $htmlOut .= "\n" . $this->htmlTagTR_END() . "\n";
                                }

                                $htmlOut .= "\n" . $this->htmlTagTABLE_END() . "\n";
                        }

                }

                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $htmlOut;
                                break;
                        case ('print'):
                        default:
                                print $htmlOut;
                }

                $this->clearOptions();
                return ($retval);
        }


        /**
        * Displays a list of albums with thumbnails and count over past days
        *
        * Supports the setReturnType option.
        *
        * @param int $numberOfDays The number of days going back to be included.
        * @param array $options Optional, Configuration options
        * @todo add style has functionality
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_showAlbumsUpdatedOverLastDays($numberOfDays,$options="") {

                $this->loadOptions($options);

                $htmlOut = "";
                $retval = "";

                $lwd = getdate(strtotime("-" . $numberOfDays . " day"));
                //$timestamp = date("Ymdhis",strtotime("-" . $numberOfDays . " day"));
                $verbosedate = date("l, F j Y",strtotime("-" . $numberOfDays . " day"));
                $timestamp = $lwd[0];

                $mediacount = $this->cpm->getMediaCountAddedSince($timestamp);

                if ($mediacount == 0) {
                                $htmlOut .= "No albums have been updated since {$verbosedate}";
                        //print "No images have been added since " . $verbosedate;
                }
                else {

                        $resultset = $this->cpm->getMediaAddedSince($timestamp);

                        if ($this->returntype != 'resultset') {
                                $htmlOut .= "\n" . $this->htmlTagTABLE() . "\n";

                                //$HtmlOut .= "<table width=\"80%\" cellpadding=\"5\" cellspacing=\"0\"{$tableStyle}>\n";
                                $htmlOut .= $this->htmlTagTR() . "\n" .
                                                                $this->htmlTagTH("<strong>Since {$verbosedate} we've added {$mediacount} images</strong>",'colspan="2"');
                                $htmlOut .= $this->htmlTagTR_END();

                                while ($row = mysql_fetch_assoc($resultset)) {

                                        $htmlOut .= $this->htmlTagTR();

                                        if (array_key_exists('alttag',$this->optionHash)) {
                                                $alttag = $this->cpm->createDescription($this->optionHash['alttag'],$row);
                                        }else{
                                                $alttag = $this->cpm->createDescription("%f",$row);
                                        }

                                        $attributes = 'alt="' . $alttag . '" title="' . $alttag . '"';
                                        $imgfile = $this->cpm->getImageToUse($row['pFilepath'],$row['pFilename'], $this->getPrefixToUse());
                                        $link = $this->cpm->createlink($row['pFilepath'],$row['pFilename'],$row['pAid'],$row['pPid'],$this->getoption('imagelink'));

                                        if ($link != "") {
                                                $htmlOut .= $this->htmlTagTD($this->htmlTagAHREF($link,$this->htmlTagIMG($imgfile,$attributes)));
                                        } else {
                                                $htmlOut .= $this->htmlTagTD($this->htmlTagIMG($imgfile,$attributes));
                                        }

                                        $htmlOut .= $this->htmlTagTD("<strong>{$row['count']} new in " .
                                                $this->htmlTagAHREF("{$this->urltocpm}thumbnails.php?album={$row['pAid']}",$row['aTitle']) .
                                                " of {$row['cName']}</strong><br>{$row['count']}",'valign="top"');

                                        $htmlOut .= "\n" . $this->htmlTagTR_END() . "\n";
                                }

                                $htmlOut .= "\n" . $this->htmlTagTABLE_END() . "\n";
                        }

                }

                switch ($this->returntype) {
                        case ('resultset'):
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $htmlOut;
                                break;
                        case ('print'):
                        default:
                                print $htmlOut;
                }

                $this->clearOptions();
                return ($retval);
        }


        /**
        * Displays a list of category, album and count over past days.    Supports the setReturnType option.
        *
        * @param int $numberOfDays The number of days going back to be included.
        * @param array $options Optional, Configuration options
        * @todo add style has functionality
        * @todo allow for media to be specified / filtered - jpg, mp3, etc
        */
        function cpm_listMediaAddedOverLastDays($numberOfDays,$options="") {

                $this->loadOptions($options);
                $htmlOut = "";
                $retval = "";

                $lwd = getdate(strtotime("-" . $numberOfDays . " day"));
                $verbosedate = date("l, F j Y",strtotime("-" . $numberOfDays . " day"));
                $timestamp = $lwd[0];

                $mediacount = $this->cpm->getMediaCountAddedSince($timestamp);

                if ($mediacount == 0) {
                        $htmlOut .= "No images have been added since {$verbosedate}";
                }
                else {

                        $resultset = $this->cpm->getMediaAddedSince($timestamp);

                        if ($this->returntype != 'resultset') {
                                if ($this->debugMode) { print "point A"; }
                                $htmlOut .= $this->htmlTagTABLE('width="80%');

                                $htmlOut .= $this->htmlTagTR() . "\n" .
                                                                $this->htmlTagTH("<strong>Since {$verbosedate} we've added {$mediacount} images</strong>", 'colspan="3" align="left"');
                                $htmlOut .= $this->htmlTagTR_END();


                                $htmlOut .= $this->htmlTagTR() . "\n" .
                                                                $this->htmlTagTH("<strong>Category name</strong>",'align="left"') .
                                                                $this->htmlTagTH("<strong>Album name</strong>",'align="left"') .
                                                                $this->htmlTagTH("<strong>New Count</strong>",'align="left"');

                                $htmlOut .= $this->htmlTagTR_END();


                                $lastcname="";
                                while ($row = mysql_fetch_assoc($resultset)) {

                                        $htmlOut .= $this->htmlTagTR() . "\n";

                                        if ($row['cName'] == $lastcname) {
                                                $htmlOut .= $this->htmlTagTD("&nbsp;");
                                        }
                                        else {
                                                $htmlOut .= $this->htmlTagTD("<strong>{$row['cName']}</strong>");
                                                $lastcname = $row['cName'];
                                        }

                                        $htmlOut.=$this->htmlTagTD($this->htmlTagAHREF("{$this->urltocpm}thumbnails.php?album={$row['pAid']}",$row['aTitle']),'align="left"');

                                        $htmlOut .= $this->htmlTagTD("{$row['count']} new",'align="left"');

                                        $htmlOut .= "\n" . $this->htmlTagTR_END() . "\n";

                                }

                                $htmlOut .= "\n" . $this->htmlTagTABLE_END() . "\n";
                        }

                }


                switch ($this->returntype) {
                        case ('resultset'):
                                if ($this->debugMode) { print "returning resultset"; }
                                $retval = $resultset;
                                break;
                        case ('html'):
                                $retval = $htmlOut;
                                break;
                        case ('print'):
                        default:
                                print $htmlOut;
                }


                $this->clearOptions();
                return ($retval);
        }        // END OF FUNCTION cpm_viewMediaAddedOverLastDays


        /**
        * Creates a table to display images
        *
        * This is an internal helper function to construct tables to hold the images.
        *
        * @returns string (XHTML code)
        */
        function createTable ($resultset,$rows,$columns) {

        $optionshash = $this->optionHash;
        $htmlOut = "";
        $alttag = "";
        $subtitle = "";

        $fileprefix=$this->defaultimagesize;


        $maximages = $rows * $columns;
        $numimages = mysql_num_rows($resultset);

        if ($numimages < $maximages) {
                $gap = $maximages - $numimages;

                if ($rows > $columns) {
                        $numofrowstolose = floor($gap / $columns);
                        $rows = $rows - $numofrowstolose;
                }
                elseif ($columns > $rows) {
                        $numofcolstolose = floor($gap / $rows);
                        $columns = $columns - $numofcolstolose;
                }
                else {
                        $totalloss = floor($gap / $rows);
                        $first = floor($totalloss / 2);
                        $columns = $columns - $first;
                        $rows = $rows - ($totalloss-$first);
                }
        }

        $htmlOut .= $this->htmlTagTABLE() . "\n";

        for($rw=0; $rw < $rows ; $rw++) {
        $htmlOut .= $this->htmlTagTR() . "\n";

                for ($cl=0; $cl < $columns; $cl++) {
                        $row = mysql_fetch_assoc($resultset);

                        if ($row) {
                                if (array_key_exists('alttag',$this->optionHash)) {
                                        $alttag = $this->cpm->createDescription($this->optionHash['alttag'],$row);
                                }else{
                                        $alttag = $this->cpm->createDescription("%f",$row);
                                }

                                $attributes = 'alt="' . $alttag . '" title="' . $alttag . '"';

                                if (array_key_exists('imagewidth',$this->optionHash)) {
                                        $attributes .= ' width=        "' .         $this->optionHash['imagewidth'] . '"';
                                }

                                if (array_key_exists('imageheight',$this->optionHash)) {
                                        $attributes .= ' height=        "' .         $this->optionHash['imageheight'] . '"';
                                }

                                $imgfile = $this->cpm->getImageToUse($row['pFilepath'],$row['pFilename'], $this->getPrefixToUse());
                                $link = $this->cpm->createlink($row['pFilepath'],$row['pFilename'],$row['pAid'],$row['pPid'],$this->getoption('imagelink'));

                                if (array_key_exists('subtitle',$this->optionHash)) {
                                        $subtitle = "<br />" . $this->cpm->createDescription($this->optionHash['subtitle'],$row);
                                } else {
                                        $subtitle = "";
                                }

                                if ($link != "") {
                                        $htmlOut .= $this->htmlTagTD($this->htmlTagAHREF($link,$this->htmlTagIMG($imgfile,$attributes)) . $subtitle);
                                } else {
                                        $htmlOut .= $this->htmlTagTD($this->htmlTagIMG($imgfile,$attributes) . $subtitle);
                                }
                        }
                        else
                        {
                        $htmlOut .= $this->htmlTagTD('&nbsp;');
                        }
                } // end column for
        $htmlOut .= "\n" . $this->htmlTagTR_END() . "\n";

        } // end row for

        $htmlOut .= "\n" . $this->htmlTagTABLE_END() . "\n";

        return $htmlOut;

        } // end function


        function htmlTagTABLE($extraAttributes="") {

                $htmlOut = '<table ';
                if (array_key_exists('tablestyle',$this->styleHash)) $htmlOut .= " {$this->styleHash['tablestyle']}";
                if ($extraAttributes != "") $htmlOut .= " $extraAttributes";
                $htmlOut .= '>';
                return $htmlOut;
        }

        function htmlTagTABLE_END() { return "</table>"; }

        function htmlTagTR($extraAttributes="") {
                $htmlOut = '<tr';
                if (array_key_exists('rowstyle',$this->styleHash)) $htmlOut .= " {$this->styleHash['rowstyle']}";
                if ($extraAttributes != "") $htmlOut .= " $extraAttributes";
                $htmlOut .= '>';
                return $htmlOut;
        }

        function htmlTagTR_END() { return "</tr>"; }

        function htmlTagTH($contents,$extraAttributes="") {
                $htmlOut = '<th';
                if (array_key_exists('tableheadstyle',$this->styleHash)) $htmlOut .= " {$this->styleHash['tableheadstyle']}";
                if ($extraAttributes != "") $htmlOut .= " $extraAttributes";
                $htmlOut .= '>' . $contents . '</th>';
                return $htmlOut;
        }

        function htmlTagTD($contents, $extraAttributes="") {
                $htmlOut = '<td';
                if (array_key_exists('cellstyle',$this->styleHash)) $htmlOut .= " {$this->styleHash['cellstyle']}";
                if ($extraAttributes != "") $htmlOut .= " " . $extraAttributes;
                $htmlOut .= '>' . $contents . '</td>';

                return $htmlOut;
        }

        function htmlTagAHREF($target, $contents, $extraAttributes="") {

                $htmlOut = '<a';

                if ( ( (array_key_exists('imagelink',$this->optionHash))
                                                && $this->optionHash['imagelink'] == 'large')
                                                && array_key_exists('windowtarget',$this->optionHash ) )
                {

                                if ($this->optionHash['windowtarget'] == '_blank-js' ) {
                                        $htmlOut .= " href=\"javascript:cmfshowpic('$target','')\" ";

                                } elseif ($this->optionHash['windowtarget'] == '_blank-cfshow') {
                                //        $htmlOut .= " href=\"\" onclick=         \"javascript:window.open('cfshow.php?pic=$target','cpmFetch','width=825,height=625,toolbars=0,scrollbars=1,resizable=1');\"";

                                        $htmlOut .= " href=\"javascript:void(window.open('cfshow.php?pic=$target','cpmFetch','width=825,height=625,toolbars=0,scrollbars=1,resizable=1'));\"";


                                } elseif ($this->optionHash['windowtarget'] == '_blank') {
                                        $htmlOut .= " href=\"$target\" target=\"_blank\" ";

                                } else {
                                        $htmlOut .= " href=\"$target\" target=\"{$this->optionHash['windowtarget']}\"  ";
                                }

                } // handling less than full size photos
                else {

                        if (array_key_exists('windowtarget',$this->optionHash)) $htmlOut .= ' target="' . $this->optionHash['windowtarget'] . '"';
                        $htmlOut .= " href=\"$target\" ";

                }

                if (array_key_exists('linkstyle',$this->styleHash)) $htmlOut .= " {$this->styleHash['linkstyle']}";
                if ($extraAttributes != "") $htmlOut .= " " . $extraAttributes;

                $htmlOut .= " >$contents</a>";

                return $htmlOut;
        }

        function htmlTagIMG($imagefile,$extraAttributes) {
                $htmlOut = '<img';
                if (array_key_exists('imagestyle',$this->styleHash)) $htmlOut .= " {$this->styleHash['imagestyle']}";
                if ($extraAttributes != "") $htmlOut .= " " . $extraAttributes;
                $htmlOut .= " src=\"$imagefile\"" . '/>';
                return ($htmlOut);
        }

        function getPrefixToUse() {

                $fileprefix=$this->defaultimagesize;

                if (array_key_exists('imagesize',$this->optionHash)) {
                        if ($this->optionHash['imagesize'] == 'thumb') {
                                $fileprefix = $this->thumbnailprefix;
                        } elseif ($this->optionHash['imagesize'] =='int') {
                                $fileprefix = $this->intermedprefix;
                        } elseif ($this->optionHash['imagesize'] == 'large') {
                                $fileprefix=$this->fullsizeprefix;
                        }
                }

                return $fileprefix;

        }

        // Sets the member $optionHash with user submission
        function loadOptions($options="") {

                $this->optionHash = array();
                $this->styleHash = array();

                if (is_array($options)) {

                        $tmparray = array();
                        foreach(array_keys($options) as $optionkey)
                        {
                                        $tmparray[strtolower($optionkey)] = $options[$optionkey];
                        }

                        $options = $tmparray;

                        if (array_key_exists('tablestyle',$options)) $this->styleHash['tablestyle'] = 'class="' . $options['tablestyle'] . '"';
                        if (array_key_exists('tableheadstyle',$options)) $this->styleHash['tableheadstyle'] = 'class="' . $options['tableheadstyle'].'"';
                        if (array_key_exists('rowstyle',$options)) $this->styleHash['rowstyle'] = 'class="' . $options['rowstyle'] . '"';
                        if (array_key_exists('cellstyle',$options)) $this->styleHash['cellstyle'] = 'class="' . $options['cellstyle'] . '"';
                        if (array_key_exists('imagestyle',$options)) $this->styleHash['imagestyle'] = 'class="' . $options['imagestyle'] . '"';
                        if (array_key_exists('linkstyle',$options)) $this->styleHash['linkstyle'] = 'class="' . $options['linkstyle'] . '"';

                   $this->optionHash = $options;
                }

        } // end function loadOptions


        function getOption($optionname) {
                if (array_key_exists($optionname,$this->optionHash)) {
                        return $this->optionHash[$optionname];
                } else {
                        return "";
                }
        }

        // Cleans up options
        function clearOptions( ) {
                $this->optionHash = array();
                $this->styleHash = array();
        }

} // end class

?>