# price table
 
CREATE TABLE IF NOT EXISTS `CPG_cpgmart_price` (
  `pid` INT(11) NOT NULL auto_increment,
  `title` VARCHAR(255) NOT NULL default '',
  `value` DECIMAL(12,2) NOT NULL default '0.00',
  `currency` CHAR(3) NOT NULL default 'USD',
  PRIMARY KEY  (`pid`)
) TYPE=MyISAM COMMENT = 'Price element' ;

# price set table 

CREATE TABLE IF NOT EXISTS `CPG_cpgmart_priceset` (
	`pid` INT(11) NOT NULL auto_increment,
	`title` VARCHAR(255) NOT NULL DEFAULT '',
	`price_array` TEXT NOT NULL DEFAULT '',
	PRIMARY KEY (`pid`)
) TYPE=MyISAM COMMENT = 'Price set element' ; 

# option element table

CREATE TABLE IF NOT EXISTS `CPG_cpgmart_option` (
  `oid` INT(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `title_array` TEXT NOT NULL DEFAULT '',
  `value_array` TEXT NOT NULL DEFAULT '',
  `currency` VARCHAR(4) NOT NULL default 'USD',
  `hasprice` ENUM('Y','N') NOT NULL default 'N',
  PRIMARY KEY (`oid`)
) TYPE=MyISAM COMMENT = 'Option element' ;

# option set table 

CREATE TABLE IF NOT EXISTS `CPG_cpgmart_optionset` (
	`oid` INT(11) NOT NULL auto_increment,
	`title` VARCHAR(255) NOT NULL DEFAULT '',
	`option_array` TEXT NOT NULL DEFAULT '',
	PRIMARY KEY (`oid`)
) TYPE=MyISAM COMMENT = 'Option set element' ;

# order table

CREATE TABLE IF NOT EXISTS `CPG_cpgmart_order` (
  `oid` int(11) NOT NULL auto_increment,
  `txnid` varchar(255) NOT NULL default '',
  `user_id` int(11) NOT NULL default '0',
  `user_name` varchar(255) NOT NULL default '',
  `cart` TEXT NOT NULL,
  `profile` TEXT NOT NULL,
  `time` int(11) NOT NULL default '0',
  `status` char(10) NOT NULL default '',
  `method` varchar(64) NOT NULL default '',
  `log` TEXT NOT NULL,
  `note` TEXT NOT NULL,
  PRIMARY KEY  (`oid`),
  KEY `user_id` (`user_id`)
) TYPE=MyISAM COMMENT = 'Order element' ;

# store data each pictures

ALTER TABLE `CPG_pictures` ADD `price` text NOT NULL;
ALTER TABLE `CPG_pictures` ADD `option` text NOT NULL;

# config to go

INSERT INTO `CPG_config` VALUES ('cpgmart_enable', '1');
INSERT INTO `CPG_config` VALUES ('cpgmart_currency', 'USD');
INSERT INTO `CPG_config` VALUES ('cpgmart_pp_account', 'kak@amfcvn.net');
INSERT INTO `CPG_config` VALUES ('cpgmart_test_mode', '0');
INSERT INTO `CPG_config` VALUES ('cpgmart_notify_email', 'kak@amfcvn.net)');
INSERT INTO `CPG_config` VALUES ('cpgmart_shipping_fee_type', '0');
INSERT INTO `CPG_config` VALUES ('cpgmart_shipping_fee', '0');
INSERT INTO `CPG_config` VALUES ('cpgmart_tax_fee_type', '0');
INSERT INTO `CPG_config` VALUES ('cpgmart_tax_fee', '0');