/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;

public class TextField {
    public static final float BORDER_WIDTH_THIN = 1.0f;
    public static final float BORDER_WIDTH_MEDIUM = 2.0f;
    public static final float BORDER_WIDTH_THICK = 3.0f;
    public static final int VISIBLE = 0;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int READ_ONLY = 1;
    public static final int REQUIRED = 2;
    public static final int MULTILINE = 4;
    public static final int DO_NOT_SCROLL = 8;
    public static final int PASSWORD = 16;
    public static final int FILE_SELECTION = 32;
    public static final int DO_NOT_SPELL_CHECK = 64;
    public static final int EDIT = 128;
    protected float borderWidth = 1.0f;
    protected int borderStyle = 0;
    protected Color borderColor;
    protected Color backgroundColor;
    protected Color textColor;
    protected BaseFont font;
    protected float fontSize = 0.0f;
    protected int alignment = 0;
    protected PdfWriter writer;
    protected String text;
    protected Rectangle box;
    protected int rotation = 0;
    private int visibility;
    private String fieldName;
    private String defaultText;
    private int options;
    private int maxCharacterLength;
    private String[] choices;
    private String[] choiceExports;
    private int choiceSelection;
    private int topFirst;

    public TextField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        this.writer = pdfWriter;
        this.box = rectangle;
        this.fieldName = string;
    }

    protected BaseFont getRealFont() throws IOException, DocumentException {
        if (this.font == null) {
            return BaseFont.createFont("Helvetica", "Cp1252", false);
        }
        return this.font;
    }

    protected PdfAppearance getBorderAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.writer.getDirectContent().createAppearance(this.box.width(), this.box.height());
        switch (this.rotation) {
            case 90: {
                pdfAppearance.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, this.box.height(), 0.0f);
                break;
            }
            case 180: {
                pdfAppearance.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, this.box.width(), this.box.height());
                break;
            }
            case 270: {
                pdfAppearance.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.box.width());
            }
        }
        if (this.backgroundColor != null) {
            pdfAppearance.setColorFill(this.backgroundColor);
            pdfAppearance.rectangle(0.0f, 0.0f, this.box.width(), this.box.height());
            pdfAppearance.fill();
        }
        if (this.borderStyle == 1) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setLineDash(3.0f, 0.0f);
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                pdfAppearance.stroke();
            }
        } else if (this.borderStyle == 4) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.moveTo(0.0f, this.borderWidth / 2.0f);
                pdfAppearance.lineTo(this.box.width(), this.borderWidth / 2.0f);
                pdfAppearance.stroke();
            }
        } else if (this.borderStyle == 2) {
            Color color;
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                pdfAppearance.stroke();
            }
            if ((color = this.backgroundColor) == null) {
                color = Color.white;
            }
            pdfAppearance.setGrayFill(1.0f);
            this.drawTopFrame(pdfAppearance);
            pdfAppearance.setColorFill(color.darker());
            this.drawBottomFrame(pdfAppearance);
        } else if (this.borderStyle == 3) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                pdfAppearance.stroke();
            }
            pdfAppearance.setGrayFill(0.5f);
            this.drawTopFrame(pdfAppearance);
            pdfAppearance.setGrayFill(0.75f);
            this.drawBottomFrame(pdfAppearance);
        } else if (this.borderWidth != 0.0f && this.borderColor != null) {
            pdfAppearance.setColorStroke(this.borderColor);
            pdfAppearance.setLineWidth(this.borderWidth);
            pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
            pdfAppearance.stroke();
        }
        return pdfAppearance;
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.text == null || this.text.length() == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        BaseFont baseFont = this.getRealFont();
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f = this.box.height() - this.borderWidth * 2.0f;
        if (bl) {
            f -= this.borderWidth * 2.0f;
        }
        float f2 = bl ? 2.0f * this.borderWidth : this.borderWidth;
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f2, f2, this.box.width() - 2.0f * f2, this.box.height() - 2.0f * f2);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        if (this.textColor == null) {
            pdfAppearance.setGrayFill(0.0f);
        } else {
            pdfAppearance.setColorFill(this.textColor);
        }
        pdfAppearance.beginText();
        if ((this.options & 4) != 0) {
            float f3;
            float f4;
            ArrayList arrayList;
            float f5 = this.fontSize;
            float f6 = this.box.width() - 3.0f * f2;
            ArrayList arrayList2 = arrayList = TextField.getHardBreaks(this.text);
            float f7 = baseFont.getFontDescriptor(8, 1.0f) - baseFont.getFontDescriptor(6, 1.0f);
            if (f5 == 0.0f) {
                f5 = f / (float)arrayList.size() / f7;
                if (f5 > 4.0f) {
                    if (f5 > 12.0f) {
                        f5 = 12.0f;
                    }
                    f4 = Math.max((f5 - 4.0f) / 10.0f, 0.2f);
                    while (f5 > 4.0f && !((float)(arrayList2 = TextField.breakLines(arrayList, baseFont, f5, f6)).size() * f5 * f7 <= f)) {
                        f5 -= f4;
                    }
                }
                if (f5 <= 4.0f) {
                    f5 = 4.0f;
                    arrayList2 = TextField.breakLines(arrayList, baseFont, f5, f6);
                }
            } else {
                arrayList2 = TextField.breakLines(arrayList, baseFont, f5, f6);
            }
            pdfAppearance.setFontAndSize(baseFont, f5);
            pdfAppearance.setLeading(f5 * f7);
            f4 = f2 + f - baseFont.getFontDescriptor(8, f5);
            String string = (String)arrayList2.get(0);
            if (this.alignment == 2) {
                f3 = baseFont.getWidthPoint(string, f5);
                pdfAppearance.moveText(this.box.width() - 2.0f * f2 - f3, f4);
            } else if (this.alignment == 1) {
                string = string.trim();
                f3 = baseFont.getWidthPoint(string, f5);
                pdfAppearance.moveText(this.box.width() / 2.0f - f3 / 2.0f, f4);
            } else {
                pdfAppearance.moveText(2.0f * f2, f4);
            }
            pdfAppearance.showText(string);
            int n = (int)(f / f5 / f7) + 1;
            n = Math.min(n, arrayList2.size());
            for (int i = 1; i < n; ++i) {
                float f8;
                string = (String)arrayList2.get(i);
                if (this.alignment == 2) {
                    f8 = baseFont.getWidthPoint(string, f5);
                    pdfAppearance.moveText(this.box.width() - 2.0f * f2 - f8 - pdfAppearance.getXTLM(), 0.0f);
                } else if (this.alignment == 1) {
                    string = string.trim();
                    f8 = baseFont.getWidthPoint(string, f5);
                    pdfAppearance.moveText(this.box.width() / 2.0f - f8 / 2.0f - pdfAppearance.getXTLM(), 0.0f);
                }
                pdfAppearance.newlineShowText(string);
            }
        } else {
            float f9;
            float f10;
            float f11 = this.fontSize;
            if (f11 == 0.0f) {
                f10 = f / (baseFont.getFontDescriptor(7, 1.0f) - baseFont.getFontDescriptor(6, 1.0f));
                f9 = baseFont.getWidthPoint(this.text, 1.0f);
                f11 = f9 == 0.0f ? f10 : (this.box.width() - 2.0f * f2) / f9;
                if (f11 > f10) {
                    f11 = f10;
                }
                if (f11 < 4.0f) {
                    f11 = 4.0f;
                }
            }
            pdfAppearance.setFontAndSize(baseFont, f11);
            f10 = f2 + (f - baseFont.getFontDescriptor(1, f11)) / 2.0f;
            if (f10 < f2) {
                f10 = f2;
            }
            if (this.alignment == 2) {
                f9 = baseFont.getWidthPoint(this.text, f11);
                pdfAppearance.moveText(this.box.width() - 2.0f * f2 - f9, f10);
            } else if (this.alignment == 1) {
                f9 = baseFont.getWidthPoint(this.text, f11);
                pdfAppearance.moveText(this.box.width() / 2.0f - f9 / 2.0f, f10);
            } else {
                pdfAppearance.moveText(2.0f * f2, f10);
            }
            pdfAppearance.showText(this.text);
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    PdfAppearance getListAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.choices == null || this.choices.length == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        int n = this.choiceSelection;
        if (n >= this.choices.length) {
            n = this.choices.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        BaseFont baseFont = this.getRealFont();
        float f = this.fontSize;
        if (f == 0.0f) {
            f = 12.0f;
        }
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f2 = this.box.height() - this.borderWidth * 2.0f;
        if (bl) {
            f2 -= this.borderWidth * 2.0f;
        }
        float f3 = bl ? 2.0f * this.borderWidth : this.borderWidth;
        float f4 = baseFont.getFontDescriptor(8, f) - baseFont.getFontDescriptor(6, f);
        int n2 = (int)(f2 / f4) + 1;
        int n3 = 0;
        int n4 = 0;
        n4 = n + n2 / 2 + 1;
        n3 = n4 - n2;
        if (n3 < 0) {
            n4 += n3;
            n3 = 0;
        }
        if ((n4 = n3 + n2) > this.choices.length) {
            n4 = this.choices.length;
        }
        this.topFirst = n3;
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f3, f3, this.box.width() - 2.0f * f3, this.box.height() - 2.0f * f3);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        Color color = this.textColor == null ? new GrayColor(0) : this.textColor;
        pdfAppearance.setColorFill(new Color(10, 36, 106));
        pdfAppearance.rectangle(f3, f3 + f2 - (float)(n - n3 + 1) * f4, this.box.width() - 2.0f * f3, f4);
        pdfAppearance.fill();
        pdfAppearance.beginText();
        pdfAppearance.setFontAndSize(baseFont, f);
        pdfAppearance.setLeading(f4);
        pdfAppearance.moveText(f3 * 2.0f, f3 + f2 - baseFont.getFontDescriptor(8, f) + f4);
        pdfAppearance.setColorFill(color);
        for (int i = n3; i < n4; ++i) {
            if (i == n) {
                pdfAppearance.setGrayFill(1.0f);
                pdfAppearance.newlineShowText(this.choices[i]);
                pdfAppearance.setColorFill(color);
                continue;
            }
            pdfAppearance.newlineShowText(this.choices[i]);
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    protected static ArrayList getHardBreaks(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '\r') {
                if (i + 1 < n && cArray[i + 1] == '\n') {
                    ++i;
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '\n') {
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c);
        }
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    protected static void trimRight(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        while (n != 0) {
            if (stringBuffer.charAt(--n) != ' ') {
                return;
            }
            stringBuffer.setLength(n);
        }
        return;
    }

    protected static ArrayList breakLines(ArrayList arrayList, BaseFont baseFont, float f, float f2) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.setLength(0);
            float f3 = 0.0f;
            char[] cArray = ((String)arrayList.get(i)).toCharArray();
            int n = cArray.length;
            int n2 = 0;
            int n3 = -1;
            char c = '\u0000';
            int n4 = 0;
            block6: for (int j = 0; j < n; ++j) {
                c = cArray[j];
                switch (n2) {
                    case 0: {
                        f3 += baseFont.getWidthPoint(c, f);
                        stringBuffer.append(c);
                        if (f3 > f2) {
                            f3 = 0.0f;
                            if (stringBuffer.length() > 1) {
                                stringBuffer.setLength(stringBuffer.length() - 1);
                            }
                            arrayList2.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n4 = --j;
                            if (c == ' ') {
                                n2 = 2;
                                continue block6;
                            }
                            n2 = 1;
                            continue block6;
                        }
                        if (c == ' ') continue block6;
                        n2 = 1;
                        continue block6;
                    }
                    case 1: {
                        f3 += baseFont.getWidthPoint(c, f);
                        stringBuffer.append(c);
                        if (c == ' ') {
                            n3 = j;
                        }
                        if (!(f3 > f2)) continue block6;
                        f3 = 0.0f;
                        if (n3 >= 0) {
                            j = n3;
                            stringBuffer.setLength(n3 - n4);
                            TextField.trimRight(stringBuffer);
                            arrayList2.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n4 = j;
                            n3 = -1;
                            n2 = 2;
                            continue block6;
                        }
                        if (stringBuffer.length() > 1) {
                            stringBuffer.setLength(stringBuffer.length() - 1);
                        }
                        arrayList2.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        n4 = --j;
                        if (c != ' ') continue block6;
                        n2 = 2;
                        continue block6;
                    }
                    case 2: {
                        if (c == ' ') continue block6;
                        f3 = 0.0f;
                        --j;
                        n2 = 1;
                    }
                }
            }
            TextField.trimRight(stringBuffer);
            arrayList2.add(stringBuffer.toString());
        }
        return arrayList2;
    }

    public PdfFormField getTextField() throws IOException, DocumentException {
        PdfFormField pdfFormField = PdfFormField.createTextField(this.writer, false, false, this.maxCharacterLength);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        pdfFormField.setFieldName(this.fieldName);
        switch (this.alignment) {
            case 1: {
                pdfFormField.setQuadding(1);
                break;
            }
            case 2: {
                pdfFormField.setQuadding(2);
            }
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        pdfFormField.setValueAsString(this.text);
        if (this.defaultText != null) {
            pdfFormField.setDefaultValueAsString(this.defaultText);
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        if ((this.options & 1) != 0) {
            pdfFormField.setFieldFlags(1);
        }
        if ((this.options & 2) != 0) {
            pdfFormField.setFieldFlags(2);
        }
        if ((this.options & 4) != 0) {
            pdfFormField.setFieldFlags(4096);
        }
        if ((this.options & 8) != 0) {
            pdfFormField.setFieldFlags(0x800000);
        }
        if ((this.options & 0x10) != 0) {
            pdfFormField.setFieldFlags(8192);
        }
        if ((this.options & 0x20) != 0) {
            pdfFormField.setFieldFlags(0x100000);
        }
        if ((this.options & 0x40) != 0) {
            pdfFormField.setFieldFlags(0x400000);
        }
        return pdfFormField;
    }

    public PdfFormField getComboField() throws IOException, DocumentException {
        return this.getChoiceField(false);
    }

    public PdfFormField getListField() throws IOException, DocumentException {
        return this.getChoiceField(true);
    }

    protected PdfFormField getChoiceField(boolean bl) throws IOException, DocumentException {
        PdfAppearance pdfAppearance;
        int n;
        this.options &= 0xFFFFFFFB;
        String[] stringArray = this.choices;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if ((n = this.choiceSelection) >= stringArray.length) {
            n = stringArray.length - 1;
        }
        this.text = "";
        if (n >= 0) {
            this.text = stringArray[n];
        }
        if (n < 0) {
            n = 0;
        }
        PdfFormField pdfFormField = null;
        String[][] stringArray2 = null;
        if (this.choiceExports == null) {
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray, n) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, stringArray, n);
        } else {
            int n2;
            stringArray2 = new String[stringArray.length][2];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                String string = stringArray[n2];
                stringArray2[n2][1] = string;
                stringArray2[n2][0] = string;
            }
            n2 = Math.min(stringArray.length, this.choiceExports.length);
            for (int i = 0; i < n2; ++i) {
                if (this.choiceExports[i] == null) continue;
                stringArray2[i][0] = this.choiceExports[i];
            }
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray2, n) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, stringArray2, n);
        }
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        pdfFormField.setFieldName(this.fieldName);
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (stringArray.length > 0) {
            if (stringArray2 != null) {
                pdfFormField.setValueAsString(stringArray2[n][0]);
                pdfFormField.setDefaultValueAsString(stringArray2[n][0]);
            } else {
                pdfFormField.setValueAsString(this.text);
                pdfFormField.setDefaultValueAsString(this.text);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        if (bl) {
            pdfAppearance = this.getListAppearance();
            if (this.topFirst > 0) {
                pdfFormField.put(PdfName.TI, new PdfNumber(this.topFirst));
            }
        } else {
            pdfAppearance = this.getAppearance();
        }
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        if ((this.options & 1) != 0) {
            pdfFormField.setFieldFlags(1);
        }
        if ((this.options & 2) != 0) {
            pdfFormField.setFieldFlags(2);
        }
        if ((this.options & 0x40) != 0) {
            pdfFormField.setFieldFlags(0x400000);
        }
        return pdfFormField;
    }

    private void drawTopFrame(PdfAppearance pdfAppearance) {
        pdfAppearance.moveTo(this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.box.height() - this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.borderWidth);
        pdfAppearance.fill();
    }

    private void drawBottomFrame(PdfAppearance pdfAppearance) {
        pdfAppearance.moveTo(this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - 2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.borderWidth);
        pdfAppearance.fill();
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float f) {
        this.borderWidth = f;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int n) {
        this.borderStyle = n;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public BaseFont getFont() {
        return this.font;
    }

    public void setFont(BaseFont baseFont) {
        this.font = baseFont;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float f) {
        this.fontSize = f;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle rectangle) {
        this.box = rectangle;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n) {
        if (n % 90 != 0) {
            throw new IllegalArgumentException("Rotation must be a multiple of 90.");
        }
        if ((n %= 360) < 0) {
            n += 360;
        }
        this.rotation = n;
    }

    public void setRotationFromPage(Rectangle rectangle) {
        this.setRotation(rectangle.getRotation());
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int n) {
        this.visibility = n;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String string) {
        this.defaultText = string;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int n) {
        this.options = n;
    }

    public int getMaxCharacterLength() {
        return this.maxCharacterLength;
    }

    public void setMaxCharacterLength(int n) {
        this.maxCharacterLength = n;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public void setChoices(String[] stringArray) {
        this.choices = stringArray;
    }

    public String[] getChoiceExports() {
        return this.choiceExports;
    }

    public void setChoiceExports(String[] stringArray) {
        this.choiceExports = stringArray;
    }

    public int getChoiceSelection() {
        return this.choiceSelection;
    }

    public void setChoiceSelection(int n) {
        this.choiceSelection = n;
    }

    int getTopFirst() {
        return this.topFirst;
    }
}

