/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRGraphics2DExporter
extends JRAbstractExporter {
    protected Graphics2D grx = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected float zoom = 1.0f;
    protected JRFont defaultFont = null;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected TextRenderer textRenderer = new TextRenderer();
    private static final double THIN_CORNER_OFFSET = 0.25;
    private static final Stroke STROKE_THIN = new BasicStroke(0.5f);
    private static final Stroke STROKE_1_POINT = new BasicStroke(1.0f);
    private static final Stroke STROKE_2_POINT = new BasicStroke(2.0f);
    private static final Stroke STROKE_4_POINT = new BasicStroke(4.0f);
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);

    public JRGraphics2DExporter() throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
    }

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        this.setPageRange();
        this.grx = (Graphics2D)this.parameters.get(JRGraphics2DExporterParameter.GRAPHICS_2D);
        if (this.grx == null) {
            throw new JRException("No output specified for the exporter. java.awt.Graphics2D object expected.");
        }
        Float zoomRatio = (Float)this.parameters.get(JRGraphics2DExporterParameter.ZOOM_RATIO);
        if (zoomRatio != null) {
            this.zoom = zoomRatio.floatValue();
            if (this.zoom <= 0.0f) {
                throw new JRException("Invalid zoom ratio : " + this.zoom);
            }
        }
        this.exportReportToGraphics2D();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReportToGraphics2D() throws JRException {
        this.grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform atrans = new AffineTransform();
        atrans.scale(this.zoom, this.zoom);
        this.grx.transform(atrans);
        List pages = this.jasperPrint.getPages();
        if (pages != null) {
            Shape oldClipShape = this.grx.getClip();
            this.grx.setClip(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
            try {
                JRPrintPage page = (JRPrintPage)pages.get(this.startPageIndex);
                this.exportPage(page);
            }
            finally {
                this.grx.setClip(oldClipShape);
            }
        }
    }

    protected void exportPage(JRPrintPage page) throws JRException {
        this.grx.setColor(Color.white);
        this.grx.fillRect(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        this.grx.setColor(Color.black);
        this.grx.setStroke(new BasicStroke(1.0f));
        JRPrintElement element = null;
        List elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (!(element instanceof JRPrintText)) continue;
                this.exportText((JRPrintText)element);
            }
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportLine(JRPrintLine line) {
        this.grx.setColor(line.getForecolor());
        Stroke stroke = JRGraphics2DExporter.getStroke(line.getPen());
        if (stroke != null) {
            this.grx.setStroke(stroke);
            if (line.getDirection() == 1) {
                this.grx.drawLine(line.getX() + this.globalOffsetX, line.getY() + this.globalOffsetY, line.getX() + this.globalOffsetX + line.getWidth() - 1, line.getY() + this.globalOffsetY + line.getHeight() - 1);
            } else {
                this.grx.drawLine(line.getX() + this.globalOffsetX, line.getY() + this.globalOffsetY + line.getHeight() - 1, line.getX() + this.globalOffsetX + line.getWidth() - 1, line.getY() + this.globalOffsetY);
            }
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        if (rectangle.getMode() == 1) {
            this.grx.setColor(rectangle.getBackcolor());
            this.grx.fillRoundRect(rectangle.getX() + this.globalOffsetX, rectangle.getY() + this.globalOffsetY, rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
        this.grx.setColor(rectangle.getForecolor());
        Stroke stroke = JRGraphics2DExporter.getStroke(rectangle.getPen());
        if (stroke != null) {
            this.grx.setStroke(stroke);
            this.grx.drawRoundRect(rectangle.getX() + this.globalOffsetX, rectangle.getY() + this.globalOffsetY, rectangle.getWidth() - 1, rectangle.getHeight() - 1, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        if (ellipse.getMode() == 1) {
            this.grx.setColor(ellipse.getBackcolor());
            this.grx.fillOval(ellipse.getX() + this.globalOffsetX, ellipse.getY() + this.globalOffsetY, ellipse.getWidth(), ellipse.getHeight());
        }
        this.grx.setColor(ellipse.getForecolor());
        Stroke stroke = JRGraphics2DExporter.getStroke(ellipse.getPen());
        if (stroke != null) {
            this.grx.setStroke(stroke);
            this.grx.drawOval(ellipse.getX() + this.globalOffsetX, ellipse.getY() + this.globalOffsetY, ellipse.getWidth() - 1, ellipse.getHeight() - 1);
        }
    }

    protected void exportImage(JRPrintImage printImage) throws JRException {
        int availableImageWidth;
        if (printImage.getMode() == 1) {
            this.grx.setColor(printImage.getBackcolor());
            this.grx.fillRect(printImage.getX() + this.globalOffsetX, printImage.getY() + this.globalOffsetY, printImage.getWidth(), printImage.getHeight());
        }
        int topPadding = 0;
        int leftPadding = 0;
        int bottomPadding = 0;
        int rightPadding = 0;
        if (printImage.getBox() != null) {
            topPadding = printImage.getBox().getTopPadding();
            leftPadding = printImage.getBox().getLeftPadding();
            bottomPadding = printImage.getBox().getBottomPadding();
            rightPadding = printImage.getBox().getRightPadding();
        }
        availableImageWidth = (availableImageWidth = printImage.getWidth() - leftPadding - rightPadding) < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = printImage.getRenderer();
        if (availableImageWidth > 0 && availableImageHeight > 0 && renderer != null) {
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            Dimension2D dimension = renderer.getDimension();
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float xalignFactor = 0.0f;
            switch (printImage.getHorizontalAlignment()) {
                case 3: {
                    xalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (printImage.getVerticalAlignment()) {
                case 3: {
                    yalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            switch (printImage.getScaleImage()) {
                case 1: {
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    this.grx.setClip(printImage.getX() + leftPadding + this.globalOffsetX, printImage.getY() + topPadding + this.globalOffsetY, availableImageWidth, availableImageHeight);
                    renderer.render(this.grx, new Rectangle(printImage.getX() + leftPadding + this.globalOffsetX + xoffset, printImage.getY() + topPadding + this.globalOffsetY + yoffset, normalWidth, normalHeight));
                    this.grx.setClip(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                    break;
                }
                case 2: {
                    renderer.render(this.grx, new Rectangle(printImage.getX() + leftPadding + this.globalOffsetX, printImage.getY() + topPadding + this.globalOffsetY, availableImageWidth, availableImageHeight));
                    break;
                }
                default: {
                    if (printImage.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    renderer.render(this.grx, new Rectangle(printImage.getX() + leftPadding + this.globalOffsetX + xoffset, printImage.getY() + topPadding + this.globalOffsetY + yoffset, normalWidth, normalHeight));
                }
            }
        }
        if (printImage.getBox() == null) {
            Stroke stroke = JRGraphics2DExporter.getStroke(printImage.getPen());
            if (stroke != null) {
                this.grx.setColor(printImage.getForecolor());
                this.grx.setStroke(stroke);
                this.grx.drawRect(printImage.getX() + this.globalOffsetX, printImage.getY() + this.globalOffsetY, printImage.getWidth() - 1, printImage.getHeight() - 1);
            }
        } else {
            this.exportBox(printImage.getBox(), printImage);
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            JRFont font = textElement.getFont();
            if (font == null) {
                font = this.getDefaultFont();
            }
            HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
            attributes.putAll(font.getAttributes());
            attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
            if (textElement.getMode() == 1) {
                attributes.put(TextAttribute.BACKGROUND, textElement.getBackcolor());
            }
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(attributes, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
            }
        }
        return styledText;
    }

    protected void exportText(JRPrintText text) {
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        String allText = styledText.getText();
        int x = text.getX() + this.globalOffsetX;
        int y = text.getY() + this.globalOffsetY;
        int width = text.getWidth();
        int height = text.getHeight();
        int topPadding = 0;
        int leftPadding = 0;
        int bottomPadding = 0;
        int rightPadding = 0;
        if (text.getBox() != null) {
            topPadding = text.getBox().getTopPadding();
            leftPadding = text.getBox().getLeftPadding();
            bottomPadding = text.getBox().getBottomPadding();
            rightPadding = text.getBox().getRightPadding();
        }
        double angle = 0.0;
        switch (text.getRotation()) {
            case 1: {
                y = text.getY() + this.globalOffsetY + text.getHeight();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = -1.5707963267948966;
                break;
            }
            case 2: {
                x = text.getX() + this.globalOffsetX + text.getWidth();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                angle = 1.5707963267948966;
                break;
            }
        }
        this.grx.rotate(angle, x, y);
        if (text.getMode() == 1) {
            this.grx.setColor(text.getBackcolor());
            this.grx.fillRect(x, y, width, height);
        }
        if (allText.length() > 0) {
            this.grx.setColor(text.getForecolor());
            this.textRenderer.render(this.grx, x, y, width, height, topPadding, leftPadding, bottomPadding, rightPadding, text.getTextHeight(), text.getTextAlignment(), text.getVerticalAlignment(), text.getLineSpacing(), styledText, allText);
        }
        this.grx.rotate(-angle, x, y);
        this.exportBox(text.getBox(), text);
    }

    protected void exportBox(JRBox box, JRPrintElement element) {
        Stroke topStroke = null;
        Stroke leftStroke = null;
        Stroke bottomStroke = null;
        Stroke rightStroke = null;
        if (box != null) {
            topStroke = JRGraphics2DExporter.getStroke(box.getTopBorder());
            leftStroke = JRGraphics2DExporter.getStroke(box.getLeftBorder());
            bottomStroke = JRGraphics2DExporter.getStroke(box.getBottomBorder());
            rightStroke = JRGraphics2DExporter.getStroke(box.getRightBorder());
        }
        if (topStroke != null) {
            this.grx.setStroke(topStroke);
            this.grx.setColor(box.getTopBorderColor() == null ? element.getForecolor() : box.getTopBorderColor());
            if (topStroke == STROKE_THIN) {
                this.grx.translate(-0.25, -0.25);
                this.grx.drawLine(element.getX() + this.globalOffsetX, element.getY() + this.globalOffsetY, element.getX() + this.globalOffsetX + element.getWidth(), element.getY() + this.globalOffsetY);
                this.grx.translate(0.25, 0.25);
            } else {
                this.grx.drawLine(element.getX() + this.globalOffsetX, element.getY() + this.globalOffsetY, element.getX() + this.globalOffsetX + element.getWidth() - 1, element.getY() + this.globalOffsetY);
            }
        }
        if (leftStroke != null) {
            this.grx.setStroke(leftStroke);
            this.grx.setColor(box.getLeftBorderColor() == null ? element.getForecolor() : box.getLeftBorderColor());
            if (leftStroke == STROKE_THIN) {
                this.grx.translate(-0.25, -0.25);
                this.grx.drawLine(element.getX() + this.globalOffsetX, element.getY() + this.globalOffsetY, element.getX() + this.globalOffsetX, element.getY() + this.globalOffsetY + element.getHeight());
                this.grx.translate(0.25, 0.25);
            } else {
                this.grx.drawLine(element.getX() + this.globalOffsetX, element.getY() + this.globalOffsetY, element.getX() + this.globalOffsetX, element.getY() + this.globalOffsetY + element.getHeight() - 1);
            }
        }
        if (bottomStroke != null) {
            this.grx.setStroke(bottomStroke);
            this.grx.setColor(box.getBottomBorderColor() == null ? element.getForecolor() : box.getBottomBorderColor());
            if (bottomStroke == STROKE_THIN) {
                this.grx.translate(-0.25, 0.25);
                this.grx.drawLine(element.getX() + this.globalOffsetX, element.getY() + this.globalOffsetY + element.getHeight() - 1, element.getX() + this.globalOffsetX + element.getWidth(), element.getY() + this.globalOffsetY + element.getHeight() - 1);
                this.grx.translate(0.25, -0.25);
            } else {
                this.grx.drawLine(element.getX() + this.globalOffsetX, element.getY() + this.globalOffsetY + element.getHeight() - 1, element.getX() + this.globalOffsetX + element.getWidth() - 1, element.getY() + this.globalOffsetY + element.getHeight() - 1);
            }
        }
        if (rightStroke != null) {
            this.grx.setStroke(rightStroke);
            this.grx.setColor(box.getRightBorderColor() == null ? element.getForecolor() : box.getRightBorderColor());
            if (rightStroke == STROKE_THIN) {
                this.grx.translate(0.25, -0.25);
                this.grx.drawLine(element.getX() + this.globalOffsetX + element.getWidth() - 1, element.getY() + this.globalOffsetY, element.getX() + this.globalOffsetX + element.getWidth() - 1, element.getY() + this.globalOffsetY + element.getHeight());
                this.grx.translate(-0.25, 0.25);
            } else {
                this.grx.drawLine(element.getX() + this.globalOffsetX + element.getWidth() - 1, element.getY() + this.globalOffsetY, element.getX() + this.globalOffsetX + element.getWidth() - 1, element.getY() + this.globalOffsetY + element.getHeight() - 1);
            }
        }
    }

    private static Stroke getStroke(byte pen) {
        switch (pen) {
            case 4: {
                return STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return STROKE_THIN;
            }
        }
        return STROKE_1_POINT;
    }
}

