/*
 * FormatCommandEqualsSpaceV.java
 *
 * Created on 9 mei 2005, 21:36
 * Original code: Giulio
 * Redesigned code: Robert Lamping
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;


/**
 *
 *
 */
public class FormatCommandEqualsSpaceV extends FormatCommand {
    int actual_y;
    int available_height;
    Band activeBand ;
    ReportElement bottomElement;
    Vector myElements = null;
    Vector bands = null;
    
    {
        operationType = OperationType.EQUALS_SPACE_V;
    }
    
   
        
    boolean preCondition(){
        activeBand = (Band) ((ReportElement) jrf.getSelectedElements().firstElement()).getBand();
        int counter = 0;
        
        for (Iterator i = jrf.getSelectedElements().iterator(); i.hasNext(); ) {
            ReportElement re = (ReportElement) i.next();
            if (re.getBand() == activeBand) {
                counter++;
            }
        }
        return ( counter > 1 );
        
    }
    
    void executeDeeper(){
        Vector used_bands = new Vector();
        
        resetEnumeration();

        preparation();
                
        bands = getBands();
        
        for (Iterator h = bands.iterator(); h.hasNext(); ) {
            Band b = (Band) h.next();
            Vector bandElements = getBandElements(b);
            bandElements = sortYX( bandElements.elements());
            
            if (bandElements.size()>1) {
                ReportElement re = (ReportElement) bandElements.firstElement();
                actual_y = re.getPosition().y + re.getHeight() + available_height;
                
                // the highest element in the band doesn't have to be moved
                bandElements.removeElement(re);
                
                // remove bottom element as well if this band is the active band
                if (b == activeBand) {
                    bandElements.remove( bandElements.indexOf(bottomElement) );
                }
                
                processElements(bandElements.elements());
            }
            
        }
        
    }
    
    /*
     * Calculate available height
     */
    void preparation() {
        // Sort all the selected elements bij Y coordinate.
        // 2. calculate vertical interspace between the elements of each band.
        // accumulate over the bands.
        // interspace between elements of different bands is not accumulated.
        // total vertical interspace is divided by the number of vertical interspaces.
        // 3. Then all the bands are once again travers.
        //
        Vector used_bands = new Vector();
        int gaps = 0;
        int used_height;
        
        myElements = sortYX(jrf.getSelectedElements().elements() );
        
        // calculate the average interdistance of the selected elements in the active Band
        // The active Band is the band with the first selected element.
        // The active band is set in the preCondition() method.
        
        Band b = activeBand;
        
        int counter = 0;
        int used_subheight = 0;
        int min_y = 0;
        int max_y = 0;
        
        ReportElement re = null;
        
        for (Iterator i = jrf.getSelectedElements().iterator(); i.hasNext(); ) {
            re = (ReportElement) i.next();
            
            if( re.getBand() == b){
                counter++;
                used_subheight += re.getHeight();
                
                if (counter == 1) {
                    min_y = re.getPosition().y;
                    max_y = re.getPosition().y + re.getHeight();
                    bottomElement = re;
                } else {
                    if (min_y > re.getPosition().y ) {
                        min_y = re.getPosition().y;
                    }
                    if (max_y < re.getPosition().y + re.getHeight()) {
                        max_y = re.getPosition().y + re.getHeight();
                        bottomElement = re;  // bottomElement of active Band
                    }
                }
            }
        }
        
        if (counter > 1)     {
            gaps += counter-1;
            available_height += max_y - min_y - used_subheight;
        }
        
        // the preCondition makes sure that the gaps is always > 0
        // so need for exception   "~Division by zero"
        available_height /= gaps;
        
    }
    
    public void modify() {
        
        re.setPosition(new Point(re.getPosition().x, actual_y) );
        actual_y += re.getHeight() + available_height;
    }
    
    Vector sortYX( Enumeration enum2 ) {
        //Enumeration enum2 = jrf.getSelectedElements().elements();
        Vector myElements = new Vector();
        
        while (enum2.hasMoreElements()) {
            re = (ReportElement) enum2.nextElement();
            // insert this element in the right position...
            if (myElements.size() == 0) {
                myElements.add(re);
            } else {
                
                boolean inserted = false;
                
                for (int i=0; i<myElements.size(); ++i) {
                    ReportElement re2 = (ReportElement)myElements.elementAt(i);
                    if (re.getPosition().y < re2.getPosition().y) {
                        myElements.insertElementAt(re, i);
                        inserted = true;
                        break;
                    } else if (re.getPosition().y == re2.getPosition().y) {
                        if (re.getPosition().x < re2.getPosition().x) {
                            myElements.insertElementAt(re, i);
                            inserted = true;
                            break;
                        }
                    }
                }
                if (!inserted) {
                    myElements.addElement(re);
                }
            }
        }
        return myElements;
    }
    
}
